/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.base.key;

import com.alexbarter.ciphertool.lib.characters.CharSequenceUtils;
import com.alexbarter.ciphertool.lib.characters.CharacterArrayUtils;
import com.alexbarter.ciphertool.lib.matrix.Matrix;
import com.alexbarter.lib.util.ArrayUtil;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.function.BiPredicate;
import java.util.function.Function;

public class KeyIterator {
    public static boolean permuteIntegerOrderedKey(Function<Integer[], Boolean> consumer, int length) {
        return KeyIterator.permuteObject(consumer, ArrayUtil.createRangeInteger((int)length));
    }

    public static boolean permuteString(Function<String, Boolean> consumer, CharSequence str) {
        return KeyIterator.permuteString(consumer, CharSequenceUtils.toArray((CharSequence)str));
    }

    public static boolean permuteString(Function<String, Boolean> consumer, Character[] str) {
        return KeyIterator.permuteObject(d -> (Boolean)consumer.apply(CharacterArrayUtils.toString((Character[])d)), str);
    }

    public static <T> boolean permuteObject(Function<T[], Boolean> consumer, T[] items) {
        return KeyIterator.permuteObject(consumer, items, 0);
    }

    private static <T> boolean permuteObject(Function<T[], Boolean> consumer, T[] arr, int pos) {
        if (arr.length - pos == 1) {
            return consumer.apply(Arrays.copyOf(arr, arr.length));
        }
        for (int i = pos; i < arr.length; ++i) {
            T j;
            T h = arr[pos];
            arr[pos] = j = arr[i];
            arr[i] = h;
            if (!KeyIterator.permuteObject(consumer, arr, pos + 1)) {
                return false;
            }
            arr[pos] = h;
            arr[i] = j;
        }
        return true;
    }

    public static boolean iterateIntegerArray(Function<Integer[], Boolean> consumer, int length, int range, boolean repeats) {
        return KeyIterator.iterateObject(consumer, new Integer[length], ArrayUtil.createRangeInteger((int)range), repeats ? null : (a, b) -> a == b);
    }

    public static boolean iterateShortCustomKey(Function<String, Boolean> consumer, CharSequence keyAlphabet, int length, boolean repeats) {
        return KeyIterator.iterateShortKey(consumer, CharSequenceUtils.toArray((CharSequence)keyAlphabet), length, repeats);
    }

    public static boolean iterateShortKey(Function<String, Boolean> consumer, Character[] characters, int length, boolean repeats) {
        return KeyIterator.iterateObject(o -> (Boolean)consumer.apply(CharacterArrayUtils.toString((Character[])o)), new Character[length], characters, repeats ? null : (a, b) -> a == b);
    }

    public static boolean iterateMatrix(Function<Matrix, Boolean> consumer, int size) {
        return KeyIterator.iterateMatrix(consumer, size, size, 26);
    }

    public static boolean iterateMatrix(Function<Matrix, Boolean> consumer, int noRows, int noColumns, int base) {
        return KeyIterator.iterateObject((T[] o) -> (Boolean)consumer.apply(new Matrix(o, noRows, noColumns)), new Integer[noRows * noColumns], ArrayUtil.createRangeInteger((int)base));
    }

    public static <T> boolean iterateObject(Function<T[], Boolean> consumer, int length, T[] items) {
        return KeyIterator.iterateObject(consumer, (Object[])Array.newInstance(items.getClass().getComponentType(), length), items);
    }

    public static <T> boolean iterateObject(Function<T[], Boolean> consumer, T[] holder, T[] items) {
        return KeyIterator.iterateObject(consumer, holder, items, null, 0);
    }

    public static <T> boolean iterateObject(Function<T[], Boolean> consumer, T[] holder, T[] items, BiPredicate<T, T> equalsPred) {
        return KeyIterator.iterateObject(consumer, holder, items, equalsPred, 0);
    }

    private static <T> boolean iterateObject(Function<T[], Boolean> consumer, T[] holder, T[] items, BiPredicate<T, T> equalsPred, int pos) {
        if (holder.length - pos == 0) {
            return consumer.apply(Arrays.copyOf(holder, holder.length));
        }
        block0: for (T i : items) {
            if (equalsPred != null) {
                for (int j = 0; j < pos; ++j) {
                    if (equalsPred.test(holder[j], i)) continue block0;
                }
            }
            holder[pos] = i;
            if (KeyIterator.iterateObject(consumer, holder, items, equalsPred, pos + 1)) continue;
            return false;
        }
        return true;
    }

    public static boolean iterateGrille(Function<Integer[], Boolean> consumer, int size) {
        double halfSize = (double)size / 2.0;
        int rows = (int)Math.ceil(halfSize);
        int cols = (int)Math.floor(halfSize);
        int keySize = rows * cols;
        int[] key = new int[keySize];
        int count = 0;
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                key[count++] = r * size + c;
            }
        }
        return KeyIterator.iterateIntegerArray(o -> {
            int[] starting = key;
            Integer[] next = new Integer[starting.length];
            for (int i = 0; i < key.length; ++i) {
                int quadrant = o[i];
                int value = starting[i];
                for (int rot = 0; rot < quadrant; ++rot) {
                    int row = value / size;
                    int col = value % size;
                    value = col * size + (size - row - 1);
                }
                next[i] = value;
            }
            return (Boolean)consumer.apply(next);
        }, keySize, 4, true);
    }
}

