/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.examples.tetris.service;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tools.aqua.bgw.examples.tetris.entity.Piece;
import tools.aqua.bgw.examples.tetris.entity.Tetris;
import tools.aqua.bgw.examples.tetris.entity.Tile;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nJ\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\n\u00a8\u0006\u000e"}, d2={"Ltools/aqua/bgw/examples/tetris/service/TetrisChecker;", "", "()V", "checkCollision", "", "tetris", "Ltools/aqua/bgw/examples/tetris/entity/Tetris;", "piece", "Ltools/aqua/bgw/examples/tetris/entity/Piece;", "offsetY", "", "offsetX", "isRowFull", "row", "bgw-tetris-example"})
public final class TetrisChecker {
    @NotNull
    public static final TetrisChecker INSTANCE = new TetrisChecker();

    private TetrisChecker() {
    }

    public final boolean checkCollision(@NotNull Tetris tetris, @NotNull Piece piece, int offsetY, int offsetX) {
        Intrinsics.checkNotNullParameter((Object)tetris, (String)"tetris");
        Intrinsics.checkNotNullParameter((Object)piece, (String)"piece");
        Tile[][] grid = tetris.getTetrisGrid();
        int n = 0;
        int n2 = piece.getHeight();
        while (n < n2) {
            int y = n++;
            int n3 = 0;
            int n4 = piece.getWidth();
            while (n3 < n4) {
                int x = n3++;
                int yPos = y + tetris.getCurrentYPosition() + offsetY - 1;
                int xPos = x + tetris.getCurrentXPosition() + offsetX - 1;
                if (yPos < 0) continue;
                if (yPos > 19 || xPos > 9 || xPos < 0) {
                    return true;
                }
                if (piece.getTiles()[y][x] == null || grid[yPos][xPos].getImageVisual() == null) continue;
                return true;
            }
        }
        return false;
    }

    public static /* synthetic */ boolean checkCollision$default(TetrisChecker tetrisChecker, Tetris tetris, Piece piece, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            piece = tetris.getCurrentPiece();
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        return tetrisChecker.checkCollision(tetris, piece, n, n2);
    }

    public final boolean isRowFull(@NotNull Tetris tetris, int row) {
        Intrinsics.checkNotNullParameter((Object)tetris, (String)"tetris");
        int n = 0;
        while (n < 10) {
            int x = n++;
            if (tetris.getTetrisGrid()[row][x].getImageVisual() != null) continue;
            return false;
        }
        return true;
    }
}

