/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.examples.sudoku.view;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tools.aqua.bgw.core.BoardGameApplication;
import tools.aqua.bgw.core.MenuScene;
import tools.aqua.bgw.event.KeyCode;
import tools.aqua.bgw.event.KeyEvent;
import tools.aqua.bgw.event.MouseEvent;
import tools.aqua.bgw.examples.sudoku.entity.Difficulty;
import tools.aqua.bgw.examples.sudoku.service.LogicController;
import tools.aqua.bgw.examples.sudoku.view.RefreshViewController;
import tools.aqua.bgw.examples.sudoku.view.customcomponents.SudokuCell;
import tools.aqua.bgw.examples.sudoku.view.scenes.SudokuGameScene;
import tools.aqua.bgw.examples.sudoku.view.scenes.SudokuMenuScene;
import tools.aqua.bgw.examples.sudoku.view.scenes.SudokuSettingsScene;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u0010H\u0002J\f\u0010\u0016\u001a\u00020\u0010*\u00020\bH\u0002J\f\u0010\u0016\u001a\u00020\u0010*\u00020\fH\u0002J\f\u0010\u0016\u001a\u00020\u0010*\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ltools/aqua/bgw/examples/sudoku/view/SudokuViewController;", "Ltools/aqua/bgw/core/BoardGameApplication;", "()V", "logicController", "Ltools/aqua/bgw/examples/sudoku/service/LogicController;", "refreshViewController", "Ltools/aqua/bgw/examples/sudoku/view/RefreshViewController;", "sudokuGameScene", "Ltools/aqua/bgw/examples/sudoku/view/scenes/SudokuGameScene;", "getSudokuGameScene", "()Ltools/aqua/bgw/examples/sudoku/view/scenes/SudokuGameScene;", "sudokuMenuScene", "Ltools/aqua/bgw/examples/sudoku/view/scenes/SudokuMenuScene;", "sudokuSettingsScene", "Ltools/aqua/bgw/examples/sudoku/view/scenes/SudokuSettingsScene;", "onCursorMoved", "", "keyCode", "Ltools/aqua/bgw/event/KeyCode;", "onDigitEntered", "digit", "onValueDeleted", "registerEvents", "bgw-sudoku-example"})
public final class SudokuViewController
extends BoardGameApplication {
    @NotNull
    private final SudokuMenuScene sudokuMenuScene = new SudokuMenuScene();
    @NotNull
    private final SudokuSettingsScene sudokuSettingsScene = new SudokuSettingsScene();
    @NotNull
    private final SudokuGameScene sudokuGameScene = new SudokuGameScene();
    @NotNull
    private final RefreshViewController refreshViewController = new RefreshViewController(this);
    @NotNull
    private final LogicController logicController = new LogicController(this.refreshViewController);

    public SudokuViewController() {
        super("Sudoku", null, null, 6, null);
        this.registerEvents(this.sudokuMenuScene);
        this.registerEvents(this.sudokuSettingsScene);
        this.registerEvents(this.sudokuGameScene);
        this.showGameScene(this.sudokuGameScene);
        BoardGameApplication.showMenuScene$default((BoardGameApplication)this, (MenuScene)this.sudokuMenuScene, null, (int)2, null);
        this.show();
    }

    @NotNull
    public final SudokuGameScene getSudokuGameScene() {
        return this.sudokuGameScene;
    }

    private final void registerEvents(SudokuMenuScene $this$registerEvents) {
        $this$registerEvents.getContinueGameButton().setOnMouseClicked((Function1)new Function1<MouseEvent, Unit>(this){
            final /* synthetic */ SudokuViewController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                BoardGameApplication.hideMenuScene$default((BoardGameApplication)this.this$0, null, (int)1, null);
            }
        });
        $this$registerEvents.getNewGameEasyButton().setOnMouseClicked((Function1)new Function1<MouseEvent, Unit>(this){
            final /* synthetic */ SudokuViewController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SudokuViewController.access$getLogicController$p(this.this$0).newGame(Difficulty.EASY);
                BoardGameApplication.hideMenuScene$default((BoardGameApplication)this.this$0, null, (int)1, null);
            }
        });
        $this$registerEvents.getNewGameMediumButton().setOnMouseClicked((Function1)new Function1<MouseEvent, Unit>(this){
            final /* synthetic */ SudokuViewController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SudokuViewController.access$getLogicController$p(this.this$0).newGame(Difficulty.MEDIUM);
                BoardGameApplication.hideMenuScene$default((BoardGameApplication)this.this$0, null, (int)1, null);
            }
        });
        $this$registerEvents.getNewGameHardButton().setOnMouseClicked((Function1)new Function1<MouseEvent, Unit>(this){
            final /* synthetic */ SudokuViewController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SudokuViewController.access$getLogicController$p(this.this$0).newGame(Difficulty.HARD);
                BoardGameApplication.hideMenuScene$default((BoardGameApplication)this.this$0, null, (int)1, null);
            }
        });
        $this$registerEvents.getExitButton().setOnMouseClicked((Function1)new Function1<MouseEvent, Unit>(this){
            final /* synthetic */ SudokuViewController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.exit();
            }
        });
    }

    private final void registerEvents(SudokuSettingsScene $this$registerEvents) {
        $this$registerEvents.getShowTimerToggleButton().getButton().getSelectedProperty().addListener((arg_0, arg_1) -> SudokuViewController.registerEvents$lambda-0(this, arg_0, arg_1));
        $this$registerEvents.getInstantCheckToggleButton().getButton().getSelectedProperty().addListener((arg_0, arg_1) -> SudokuViewController.registerEvents$lambda-1(this, arg_0, arg_1));
        $this$registerEvents.getContinueGameButton().setOnMouseClicked((Function1)new Function1<MouseEvent, Unit>(this){
            final /* synthetic */ SudokuViewController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                BoardGameApplication.hideMenuScene$default((BoardGameApplication)this.this$0, null, (int)1, null);
            }
        });
    }

    private final void registerEvents(SudokuGameScene $this$registerEvents) {
        $this$registerEvents.setOnKeyPressed((Function1)new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ SudokuViewController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull KeyEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it.getKeyCode().isArrow()) {
                    SudokuViewController.access$onCursorMoved(this.this$0, it.getKeyCode());
                } else if (it.getKeyCode().isDigit()) {
                    SudokuViewController.access$onDigitEntered(this.this$0, it.getKeyCode());
                } else if (it.getKeyCode() == KeyCode.DELETE) {
                    SudokuViewController.access$onValueDeleted(this.this$0);
                }
            }
        });
        this.logicController.getSettings().getShowTimer().addListener((arg_0, arg_1) -> SudokuViewController.registerEvents$lambda-2($this$registerEvents, arg_0, arg_1));
        $this$registerEvents.getMenuButton().setOnMouseClicked((Function1)new Function1<MouseEvent, Unit>(this){
            final /* synthetic */ SudokuViewController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                BoardGameApplication.showMenuScene$default((BoardGameApplication)this.this$0, (MenuScene)SudokuViewController.access$getSudokuMenuScene$p(this.this$0), null, (int)2, null);
            }
        });
        $this$registerEvents.getSettingsButton().setOnMouseClicked((Function1)new Function1<MouseEvent, Unit>(this){
            final /* synthetic */ SudokuViewController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                BoardGameApplication.showMenuScene$default((BoardGameApplication)this.this$0, (MenuScene)SudokuViewController.access$getSudokuSettingsScene$p(this.this$0), null, (int)2, null);
            }
        });
        $this$registerEvents.getHintButton().setOnMouseClicked((Function1)new Function1<MouseEvent, Unit>(this){
            final /* synthetic */ SudokuViewController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SudokuViewController.access$getLogicController$p(this.this$0).requestHint();
            }
        });
        $this$registerEvents.getClearHintsButton().setOnMouseClicked((Function1)new Function1<MouseEvent, Unit>($this$registerEvents){
            final /* synthetic */ SudokuGameScene $this_registerEvents;
            {
                this.$this_registerEvents = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$this_registerEvents.getSudokuGrid().clearHints();
            }
        });
    }

    private final void onDigitEntered(KeyCode digit) {
        SudokuCell sudokuCell = this.sudokuGameScene.getSudokuGrid().getSelectedCell();
        if (sudokuCell == null) {
            return;
        }
        SudokuCell cell = sudokuCell;
        if (cell.isFixed() || digit == KeyCode.NUMPAD0) {
            return;
        }
        this.logicController.setValue(cell.getBoxIndex(), cell.getRowIndex(), cell.getColIndex(), Integer.parseInt(digit.getString()));
    }

    private final void onValueDeleted() {
        SudokuCell sudokuCell = this.sudokuGameScene.getSudokuGrid().getSelectedCell();
        if (sudokuCell == null) {
            return;
        }
        SudokuCell cell = sudokuCell;
        this.logicController.setValue(cell.getBoxIndex(), cell.getRowIndex(), cell.getColIndex(), null);
    }

    private final void onCursorMoved(KeyCode keyCode) {
        if (!keyCode.isArrow()) {
            boolean $i$a$-require-SudokuViewController$onCursorMoved$22 = false;
            String $i$a$-require-SudokuViewController$onCursorMoved$22 = keyCode + " is not an arrow key.";
            throw new IllegalArgumentException($i$a$-require-SudokuViewController$onCursorMoved$22.toString());
        }
        SudokuCell sudokuCell = this.sudokuGameScene.getSudokuGrid().getSelectedCell();
        if (sudokuCell == null) {
            return;
        }
        SudokuCell selectedCell = sudokuCell;
        int box = selectedCell.getBoxIndex();
        int col = selectedCell.getColIndex();
        int row = selectedCell.getRowIndex();
        switch (WhenMappings.$EnumSwitchMapping$0[keyCode.ordinal()]) {
            case 1: {
                if (row == 0) {
                    box = Math.floorMod(box - 3, 9);
                    row = 2;
                    break;
                }
                --row;
                break;
            }
            case 2: {
                if (row == 2) {
                    box = (box + 3) % 9;
                    row = 0;
                    break;
                }
                ++row;
                break;
            }
            case 3: {
                if (col == 0) {
                    box += box % 3 != 0 ? -1 : 2;
                    col = 2;
                    break;
                }
                --col;
                break;
            }
            case 4: {
                if (col == 2) {
                    box -= box % 3 != 2 ? -1 : 2;
                    col = 0;
                    break;
                }
                ++col;
                break;
            }
            default: {
                throw new IllegalStateException((keyCode + " is not an arrow key.").toString());
            }
        }
        this.sudokuGameScene.getSudokuGrid().getCell(box, row, col).select();
    }

    private static final void registerEvents$lambda-0(SudokuViewController this$0, boolean bl, boolean nV) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.logicController.getSettings().getShowTimer().setValue((Object)nV);
    }

    private static final void registerEvents$lambda-1(SudokuViewController this$0, boolean bl, boolean nV) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.logicController.getSettings().getInstantCheck().setValue((Object)nV);
        if (nV) {
            this$0.logicController.showErrors();
        } else {
            this$0.sudokuGameScene.getSudokuGrid().clearHints();
        }
    }

    private static final void registerEvents$lambda-2(SudokuGameScene $this_registerEvents, boolean bl, boolean nV) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_registerEvents), (String)"$this_registerEvents");
        $this_registerEvents.getTimer().setVisible(nV);
    }

    public static final /* synthetic */ LogicController access$getLogicController$p(SudokuViewController $this) {
        return $this.logicController;
    }

    public static final /* synthetic */ void access$onCursorMoved(SudokuViewController $this, KeyCode keyCode) {
        $this.onCursorMoved(keyCode);
    }

    public static final /* synthetic */ void access$onDigitEntered(SudokuViewController $this, KeyCode digit) {
        $this.onDigitEntered(digit);
    }

    public static final /* synthetic */ void access$onValueDeleted(SudokuViewController $this) {
        $this.onValueDeleted();
    }

    public static final /* synthetic */ SudokuMenuScene access$getSudokuMenuScene$p(SudokuViewController $this) {
        return $this.sudokuMenuScene;
    }

    public static final /* synthetic */ SudokuSettingsScene access$getSudokuSettingsScene$p(SudokuViewController $this) {
        return $this.sudokuSettingsScene;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KeyCode.values().length];
            nArray[KeyCode.UP.ordinal()] = 1;
            nArray[KeyCode.DOWN.ordinal()] = 2;
            nArray[KeyCode.LEFT.ordinal()] = 3;
            nArray[KeyCode.RIGHT.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

