/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.examples.sudoku.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import tools.aqua.bgw.examples.sudoku.entity.Sudoku;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0010"}, d2={"Ltools/aqua/bgw/examples/sudoku/service/SudokuChecker;", "", "()V", "checkBoxes", "", "Ltools/aqua/bgw/examples/sudoku/entity/Sudoku$SudokuTuple;", "sudoku", "Ltools/aqua/bgw/examples/sudoku/entity/Sudoku;", "checkCols", "checkDuplicates", "digits", "", "checkFull", "", "checkRows", "checkSudoku", "bgw-sudoku-example"})
public final class SudokuChecker {
    @NotNull
    public static final SudokuChecker INSTANCE = new SudokuChecker();

    private SudokuChecker() {
    }

    @NotNull
    public final Set<Sudoku.SudokuTuple> checkSudoku(@NotNull Sudoku sudoku) {
        Intrinsics.checkNotNullParameter((Object)sudoku, (String)"sudoku");
        return SetsKt.plus((Set)SetsKt.plus(this.checkBoxes(sudoku), (Iterable)this.checkRows(sudoku)), (Iterable)this.checkCols(sudoku));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Sudoku.SudokuTuple> checkBoxes(Sudoku sudoku) {
        Set errors = new LinkedHashSet();
        Object[] $this$forEachIndexed$iv = (Object[])sudoku.getGrid();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        Object[] objectArray = $this$forEachIndexed$iv;
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            void boxArray;
            Object item$iv = objectArray[n];
            ++n;
            int n3 = index$iv;
            index$iv = n3 + 1;
            Sudoku.SudokuCell[][] sudokuCellArray = (Sudoku.SudokuCell[][])item$iv;
            int box = n3;
            boolean bl = false;
            List digits = new ArrayList();
            Object[] $this$forEachIndexed$iv2 = (Object[])boxArray;
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            Object[] objectArray2 = $this$forEachIndexed$iv2;
            int n4 = 0;
            int n5 = objectArray2.length;
            while (n4 < n5) {
                void rowArray;
                Object item$iv2 = objectArray2[n4];
                ++n4;
                int n6 = index$iv2;
                index$iv2 = n6 + 1;
                Sudoku.SudokuCell[] sudokuCellArray2 = (Sudoku.SudokuCell[])item$iv2;
                int row = n6;
                boolean bl2 = false;
                void $this$forEachIndexed$iv3 = rowArray;
                boolean $i$f$forEachIndexed3 = false;
                int index$iv3 = 0;
                for (void item$iv3 : $this$forEachIndexed$iv3) {
                    void cell;
                    int n7 = index$iv3;
                    index$iv3 = n7 + 1;
                    void var34_34 = item$iv3;
                    int col = n7;
                    boolean bl3 = false;
                    digits.add(new Sudoku.SudokuTuple(box, row, col, cell.getValue()));
                }
            }
            errors.addAll((Collection)INSTANCE.checkDuplicates(digits));
        }
        return errors;
    }

    private final Set<Sudoku.SudokuTuple> checkRows(Sudoku sudoku) {
        Set errors = new LinkedHashSet();
        int n = 0;
        while (n < 3) {
            int i = n++;
            int n2 = 0;
            while (n2 < 3) {
                int n3;
                int row = n2++;
                List digits = new ArrayList();
                IntRange intRange = new IntRange(3 * i, 3 * i + 2);
                int n4 = intRange.getFirst();
                if (n4 <= (n3 = intRange.getLast())) {
                    int box;
                    do {
                        box = n4++;
                        int n5 = 0;
                        while (n5 < 3) {
                            int col = n5++;
                            digits.add(new Sudoku.SudokuTuple(box, row, col, sudoku.get(box, row, col)));
                        }
                    } while (box != n3);
                }
                errors.addAll((Collection)this.checkDuplicates(digits));
            }
        }
        return errors;
    }

    private final Set<Sudoku.SudokuTuple> checkCols(Sudoku sudoku) {
        Set errors = new LinkedHashSet();
        int n = 0;
        while (n < 3) {
            int i = n++;
            int n2 = 0;
            while (n2 < 3) {
                int col = n2++;
                List digits = new ArrayList();
                Object[] objectArray = new Integer[]{i, i + 3, i + 6};
                Iterator iterator = CollectionsKt.listOf((Object[])objectArray).iterator();
                while (iterator.hasNext()) {
                    int box = ((Number)iterator.next()).intValue();
                    int n3 = 0;
                    while (n3 < 3) {
                        int row = n3++;
                        digits.add(new Sudoku.SudokuTuple(box, row, col, sudoku.get(box, row, col)));
                    }
                }
                errors.addAll((Collection)this.checkDuplicates(digits));
            }
        }
        return errors;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Sudoku.SudokuTuple> checkDuplicates(List<Sudoku.SudokuTuple> digits) {
        Object key$iv;
        void $this$distinctBy$iv;
        Set errors = new LinkedHashSet();
        Iterable iterable = digits;
        Iterable iterable2 = digits;
        boolean $i$f$distinctBy = false;
        HashSet<Integer> set$iv = new HashSet<Integer>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Sudoku.SudokuTuple it = (Sudoku.SudokuTuple)e$iv;
            boolean bl = false;
            key$iv = it.getValue();
            if (!set$iv.add((Integer)key$iv)) continue;
            list$iv.add(e$iv);
        }
        Iterable $this$forEach$iv = CollectionsKt.subtract((Iterable)iterable2, (Iterable)CollectionsKt.toSet((Iterable)list$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Sudoku.SudokuTuple it = (Sudoku.SudokuTuple)element$iv;
            boolean bl = false;
            if (it.getValue() == null) continue;
            key$iv = digits;
            Set set = errors;
            boolean $i$f$filter = false;
            void var12_15 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Sudoku.SudokuTuple t = (Sudoku.SudokuTuple)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getValue(), (Object)t.getValue())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            set.addAll((List)destination$iv$iv);
        }
        return errors;
    }

    public final boolean checkFull(@NotNull Sudoku sudoku) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)sudoku, (String)"sudoku");
            Object[] $this$any$iv = (Object[])sudoku.getGrid();
            boolean $i$f$any = false;
            Object[] objectArray = $this$any$iv;
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                boolean bl2;
                block4: {
                    Object element$iv = objectArray[n];
                    ++n;
                    Sudoku.SudokuCell[][] box = (Sudoku.SudokuCell[][])element$iv;
                    boolean bl3 = false;
                    Object[] $this$any$iv2 = (Object[])box;
                    boolean $i$f$any2 = false;
                    Object[] objectArray2 = $this$any$iv2;
                    int n3 = 0;
                    int n4 = objectArray2.length;
                    while (n3 < n4) {
                        boolean bl4;
                        block3: {
                            Object element$iv2 = objectArray2[n3];
                            ++n3;
                            Sudoku.SudokuCell[] row = (Sudoku.SudokuCell[])element$iv2;
                            boolean bl5 = false;
                            Sudoku.SudokuCell[] $this$any$iv3 = row;
                            boolean $i$f$any3 = false;
                            for (Sudoku.SudokuCell element$iv3 : $this$any$iv3) {
                                Sudoku.SudokuCell col = element$iv3;
                                boolean bl6 = false;
                                if (!(col.getValue() == null)) continue;
                                bl4 = true;
                                break block3;
                            }
                            bl4 = false;
                        }
                        if (!bl4) continue;
                        bl2 = true;
                        break block4;
                    }
                    bl2 = false;
                }
                if (!bl2) continue;
                bl = true;
                break block5;
            }
            bl = false;
        }
        return !bl;
    }
}

