/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.net.common.annotations;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tools.aqua.bgw.net.common.GameAction;
import tools.aqua.bgw.net.common.annotations.GameActionReceiver;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00070\u00042\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00052\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\n\u00a8\u0006\u000b"}, d2={"Ltools/aqua/bgw/net/common/annotations/GameActionReceiverProcessor;", "", "()V", "getAnnotatedReceivers", "", "Ljava/lang/Class;", "Ltools/aqua/bgw/net/common/GameAction;", "Ljava/lang/reflect/Method;", "target", "classes", "", "bgw-net-common"})
public final class GameActionReceiverProcessor {
    @NotNull
    public static final GameActionReceiverProcessor INSTANCE = new GameActionReceiverProcessor();

    private GameActionReceiverProcessor() {
    }

    @NotNull
    public final Map<Class<? extends GameAction>, Method> getAnnotatedReceivers(@NotNull Class<?> target, @NotNull Set<? extends Class<? extends GameAction>> classes) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        Map map = new LinkedHashMap();
        List annotatedMethods = new ArrayList();
        Class clazz = target;
        while (!Intrinsics.areEqual((Object)clazz, Object.class)) {
            Method[] methodArray = clazz.getDeclaredMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"clazz.declaredMethods");
            for (Method method : methodArray) {
                if (!method.isAnnotationPresent(GameActionReceiver.class)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
                annotatedMethods.add(method);
            }
            Class object = clazz.getSuperclass();
            Intrinsics.checkNotNullExpressionValue(object, (String)"clazz.superclass");
            clazz = object;
        }
        for (Method method : annotatedMethods) {
            Class<?>[] classArray = method.getParameterTypes();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"method.parameterTypes");
            Class<?>[] params = classArray;
            if (params.length != 2) {
                System.err.println("Found function " + method + " annotated with @GameActionReceiver that does not declare the expected parameter count. Ignoring.");
                continue;
            }
            if (!GameAction.class.isAssignableFrom(params[0])) {
                System.err.println("Found function " + method + " annotated with @GameActionReceiver with first parameter not conforming to GameAction which was expected. Ignoring.");
                continue;
            }
            if (!String.class.isAssignableFrom(params[1])) {
                System.err.println("Found function " + method + " annotated with @GameActionReceiver with second parameter not conforming to String which was expected. Ignoring.");
                continue;
            }
            Class<?> clazz2 = params[0];
            if (!classes.contains(clazz2)) {
                System.err.println("Found function " + method + " annotated with @GameActionReceiver with target type " + clazz2 + " but no class " + clazz2 + " annotated with @GameActionClass that extends GameAction has been found. Ignoring.");
                continue;
            }
            if (map.putIfAbsent(clazz2, method) != null) {
                Method $this$getAnnotatedReceivers_u24lambda_u2d0;
                boolean bl = false;
                System.err.println("Found function " + method + " annotated with @GameActionReceiver that has the same parameter types as " + $this$getAnnotatedReceivers_u24lambda_u2d0 + ". Ignoring duplicate.");
            }
            method.setAccessible(true);
        }
        Iterable iterable = SetsKt.minus((Set)SetsKt.minus(classes, (Iterable)map.keySet()), GameAction.class);
        boolean $i$f$forEach = false;
        for (Object t : iterable) {
            Class it = (Class)t;
            boolean bl = false;
            System.err.println("GameAction " + it + " has no valid receiver function. Incoming messages will be delegated to catchall function onGameActionReceived. Consider adding a handler.");
        }
        return map;
    }
}

