/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.net.common.annotations;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tools.aqua.bgw.net.common.GameAction;
import tools.aqua.bgw.net.common.annotations.GameActionClass;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b0\u0007J\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0002J\u0012\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b*\u00020\fH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ltools/aqua/bgw/net/common/annotations/GameActionClassProcessor;", "", "()V", "forbiddenPackagePrefix", "", "", "getAnnotatedClasses", "", "Ljava/lang/Class;", "Ltools/aqua/bgw/net/common/GameAction;", "isCandidate", "", "Lcom/google/common/reflect/ClassPath$ClassInfo;", "loadOrNull", "bgw-net-common"})
public final class GameActionClassProcessor {
    @NotNull
    public static final GameActionClassProcessor INSTANCE = new GameActionClassProcessor();
    @NotNull
    private static final List<String> forbiddenPackagePrefix;

    private GameActionClassProcessor() {
    }

    @NotNull
    public final Set<Class<? extends GameAction>> getAnnotatedClasses() {
        Iterable $this$mapNotNullTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        ImmutableSet immutableSet = ClassPath.from((ClassLoader)ClassLoader.getSystemClassLoader()).getAllClasses();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"from(ClassLoader.getSyst\u2026())\n          .allClasses");
        Iterable $this$filter$iv = (Iterable)immutableSet;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ClassPath.ClassInfo)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!INSTANCE.isCandidate((ClassPath.ClassInfo)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            Class<?> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            ClassPath.ClassInfo it2 = (ClassPath.ClassInfo)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
            if (INSTANCE.loadOrNull(it2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Class)element$iv$iv;
            boolean bl = false;
            boolean isGameAction = GameAction.class.isAssignableFrom((Class<?>)it);
            boolean isAnnotationPresent = ((Class)it).isAnnotationPresent(GameActionClass.class);
            if (isGameAction && !isAnnotationPresent) {
                System.err.println("Found class " + (Class)it + " not annotated with @GameActionClass that does inherit from GameAction. Add missing annotation to use class as message type. Ignoring.");
            } else if (!isGameAction && isAnnotationPresent) {
                System.err.println("Found class " + (Class)it + " annotated with @GameActionClass that does not inherit from GameAction. This Class will not be usable as Message type. Ignoring.");
            }
            if (!(isGameAction && isAnnotationPresent)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCandidate(ClassPath.ClassInfo $this$isCandidate) {
        String it;
        String string;
        String string2 = $this$isCandidate.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"packageName");
        if (StringsKt.startsWith$default((String)string2, (String)"tools.aqua.bgw.examples", (boolean)false, (int)2, null)) return true;
        Iterable $this$none$iv = forbiddenPackagePrefix;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
            string = $this$isCandidate.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"packageName");
        } while (!StringsKt.startsWith$default((String)string, (String)it, (boolean)false, (int)2, null));
        return false;
    }

    private final Class<?> loadOrNull(ClassPath.ClassInfo $this$loadOrNull) {
        Class clazz;
        try {
            clazz = $this$loadOrNull.load();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            clazz = null;
        }
        return clazz;
    }

    static {
        Object[] objectArray = new String[]{"META-INF", "kotlin", "javax", "javafx", "com.jfoenix", "tools.aqua.bgw", "com.sun", "com.google", "com.fasterxml", "org.java_websocket", "org.jetbrains", "org.intellij", "org.slf4j", "org.checkerframework"};
        forbiddenPackagePrefix = CollectionsKt.listOf((Object[])objectArray);
    }
}

