/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.net.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.aqua.bgw.net.client.BoardGameClient;
import tools.aqua.bgw.net.client.NetworkLogger;
import tools.aqua.bgw.net.common.GameAction;
import tools.aqua.bgw.net.common.Message;
import tools.aqua.bgw.net.common.message.GameActionMessage;
import tools.aqua.bgw.net.common.notification.PlayerJoinedNotification;
import tools.aqua.bgw.net.common.notification.PlayerLeftNotification;
import tools.aqua.bgw.net.common.request.Request;
import tools.aqua.bgw.net.common.response.CreateGameResponse;
import tools.aqua.bgw.net.common.response.GameActionResponse;
import tools.aqua.bgw.net.common.response.JoinGameResponse;
import tools.aqua.bgw.net.common.response.LeaveGameResponse;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\"\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00122\u000e\u0010\u001c\u001a\n\u0018\u00010\u001dj\u0004\u0018\u0001`\u001eH\u0016J\u0012\u0010\u001f\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u0016J\u0012\u0010 \u001a\u00020\u00122\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u000e\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020'R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Ltools/aqua/bgw/net/client/BGWWebSocketClient;", "Lorg/java_websocket/client/WebSocketClient;", "uri", "Ljava/net/URI;", "playerName", "", "secret", "callback", "Ltools/aqua/bgw/net/client/BoardGameClient;", "logger", "Ltools/aqua/bgw/net/client/NetworkLogger;", "(Ljava/net/URI;Ljava/lang/String;Ljava/lang/String;Ltools/aqua/bgw/net/client/BoardGameClient;Ltools/aqua/bgw/net/client/NetworkLogger;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "getMapper$bgw_net_client", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "messageMapping", "", "message", "Ltools/aqua/bgw/net/common/Message;", "onClose", "code", "", "reason", "remote", "", "onError", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onMessage", "onOpen", "handshakedata", "Lorg/java_websocket/handshake/ServerHandshake;", "sendGameActionMessage", "payload", "Ltools/aqua/bgw/net/common/GameAction;", "sendRequest", "Ltools/aqua/bgw/net/common/request/Request;", "bgw-net-client"})
public final class BGWWebSocketClient
extends WebSocketClient {
    @NotNull
    private final URI uri;
    @NotNull
    private final String playerName;
    @NotNull
    private final String secret;
    @NotNull
    private final BoardGameClient callback;
    @NotNull
    private final NetworkLogger logger;
    private final ObjectMapper mapper;

    public BGWWebSocketClient(@NotNull URI uri, @NotNull String playerName, @NotNull String secret, @NotNull BoardGameClient callback, @NotNull NetworkLogger logger) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        super(uri);
        this.uri = uri;
        this.playerName = playerName;
        this.secret = secret;
        this.callback = callback;
        this.logger = logger;
        this.mapper = new ObjectMapper().registerModule((Module)ExtensionsKt.kotlinModule$default(null, (int)1, null));
        this.addHeader("PlayerName", this.playerName);
        this.addHeader("NetworkSecret", this.secret);
    }

    public final ObjectMapper getMapper$bgw_net_client() {
        return this.mapper;
    }

    public final void sendRequest(@NotNull Request message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.send(this.mapper.writeValueAsString((Object)message));
    }

    public final void sendGameActionMessage(@NotNull GameAction payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        String string = this.mapper.writeValueAsString((Object)payload);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mapper.writeValueAsString(payload)");
        this.send(this.mapper.writeValueAsString((Object)new GameActionMessage(string, payload.toString(), "")));
    }

    public void onOpen(@Nullable ServerHandshake handshakedata) {
        this.logger.info("Connection is now open.");
        this.callback.onOpen();
    }

    public void onClose(int code, @Nullable String reason, boolean remote) {
        this.logger.info("Connection is now closed.");
        this.logger.debug("Status code is: " + code + ". The connection was closed with the following reason: " + reason + ". The closing was initiated by the " + (remote ? "remote" : "local") + " host.");
        String string = reason;
        if (string == null) {
            string = "n/a";
        }
        this.callback.onClose(code, string, remote);
    }

    public void onError(@Nullable Exception ex) {
        this.logger.error("An uncaught error occurred.", ex);
        Exception exception = ex;
        if (exception == null) {
            exception = new NullPointerException("Exception itself is null.");
        }
        this.callback.onError(exception);
    }

    public void onMessage(@Nullable String message) {
        this.logger.info("Received message: " + message);
        try {
            Message msg = (Message)this.mapper.readValue(message, Message.class);
            this.logger.debug("Received message of type " + msg);
            Intrinsics.checkNotNullExpressionValue((Object)msg, (String)"msg");
            this.messageMapping(msg);
        }
        catch (IllegalArgumentException ise) {
            this.onError(ise);
        }
        catch (JsonProcessingException jse) {
            this.onError((Exception)((Object)jse));
        }
    }

    private final void messageMapping(Message message) {
        if (!(!(message instanceof Request))) {
            boolean bl = false;
            String string = "Client received a request";
            throw new IllegalArgumentException(string.toString());
        }
        Message message2 = message;
        if (message2 instanceof GameActionMessage) {
            this.logger.debug("Received GameActionMessage. Invoking annotated receiver function.");
            this.callback.invokeAnnotatedReceiver$bgw_net_client((GameActionMessage)message);
        } else if (message2 instanceof GameActionResponse) {
            this.logger.debug("Received GameActionResponse. Invoking handler for onGameActionResponse.");
            this.callback.onGameActionResponse((GameActionResponse)message);
        } else if (message2 instanceof CreateGameResponse) {
            this.logger.debug("Received CreateGameResponse. Invoking handler for onCreateGameResponse.");
            this.callback.onCreateGameResponse((CreateGameResponse)message);
        } else if (message2 instanceof JoinGameResponse) {
            this.logger.debug("Received JoinGameResponse. Invoking handler for onJoinGameResponse.");
            this.callback.onJoinGameResponse((JoinGameResponse)message);
        } else if (message2 instanceof LeaveGameResponse) {
            this.logger.debug("Received LeaveGameResponse. Invoking handler for onLeaveGameResponse.");
            this.callback.onLeaveGameResponse((LeaveGameResponse)message);
        } else if (message2 instanceof PlayerJoinedNotification) {
            this.logger.debug("Received PlayerJoinedNotification. Invoking handler for onPlayerJoined.");
            this.callback.onPlayerJoined((PlayerJoinedNotification)message);
        } else if (message2 instanceof PlayerLeftNotification) {
            this.logger.debug("Received PlayerLeftNotification. Invoking handler for onPlayerLeft.");
            this.callback.onPlayerLeft((PlayerLeftNotification)message);
        }
    }
}

