/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.net.client;

import com.fasterxml.jackson.databind.JsonMappingException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.aqua.bgw.net.client.BGWWebSocketClient;
import tools.aqua.bgw.net.common.GameAction;
import tools.aqua.bgw.net.common.annotations.GameActionClassProcessor;
import tools.aqua.bgw.net.common.annotations.GameActionReceiverProcessor;
import tools.aqua.bgw.net.common.message.GameActionMessage;
import tools.aqua.bgw.net.common.notification.UserDisconnectedNotification;
import tools.aqua.bgw.net.common.notification.UserJoinedNotification;
import tools.aqua.bgw.net.common.request.CreateGameMessage;
import tools.aqua.bgw.net.common.request.JoinGameMessage;
import tools.aqua.bgw.net.common.request.LeaveGameMessage;
import tools.aqua.bgw.net.common.request.Request;
import tools.aqua.bgw.net.common.response.CreateGameResponse;
import tools.aqua.bgw.net.common.response.GameActionResponse;
import tools.aqua.bgw.net.common.response.JoinGameResponse;
import tools.aqua.bgw.net.common.response.LeaveGameResponse;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B1\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003J\u0006\u0010\u001a\u001a\u00020\u0016J\u0015\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ\u0016\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003J\u000e\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u0003J \u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010/\u001a\u00020\u0003H\u0016J\u0010\u00100\u001a\u00020\u00162\u0006\u0010)\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u00162\u0006\u0010)\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\u00162\u0006\u0010)\u001a\u000205H\u0016J\b\u00106\u001a\u00020\u0016H\u0016J\u0010\u00107\u001a\u00020\u00162\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020\u00162\u0006\u00108\u001a\u00020;H\u0016J\u000e\u0010<\u001a\u00020\u00162\u0006\u0010=\u001a\u00020\rR\u001e\u0010\n\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u0018\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Ltools/aqua/bgw/net/client/BoardGameClient;", "", "playerName", "", "host", "port", "", "endpoint", "secret", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "gameActionClasses", "", "Ljava/lang/Class;", "Ltools/aqua/bgw/net/common/GameAction;", "gameActionReceivers", "", "Ljava/lang/reflect/Method;", "initializationJob", "Lkotlinx/coroutines/Job;", "wsClient", "Ltools/aqua/bgw/net/client/BGWWebSocketClient;", "connect", "", "createGame", "gameID", "sessionID", "disconnect", "invokeAnnotatedReceiver", "message", "Ltools/aqua/bgw/net/common/message/GameActionMessage;", "invokeAnnotatedReceiver$bgw_net_client", "joinGame", "greetingMessage", "leaveGame", "goodbyeMessage", "onClose", "code", "reason", "remote", "", "onCreateGameResponse", "response", "Ltools/aqua/bgw/net/common/response/CreateGameResponse;", "onError", "throwable", "", "onGameActionReceived", "sender", "onGameActionResponse", "Ltools/aqua/bgw/net/common/response/GameActionResponse;", "onJoinGameResponse", "Ltools/aqua/bgw/net/common/response/JoinGameResponse;", "onLeaveGameResponse", "Ltools/aqua/bgw/net/common/response/LeaveGameResponse;", "onOpen", "onUserJoined", "notification", "Ltools/aqua/bgw/net/common/notification/UserJoinedNotification;", "onUserLeft", "Ltools/aqua/bgw/net/common/notification/UserDisconnectedNotification;", "sendGameActionMessage", "payload", "bgw-net-client"})
public class BoardGameClient {
    @NotNull
    private final BGWWebSocketClient wsClient;
    @Nullable
    private Set<? extends Class<? extends GameAction>> gameActionClasses;
    @Nullable
    private Map<Class<? extends GameAction>, Method> gameActionReceivers;
    @NotNull
    private final Job initializationJob;

    protected BoardGameClient(@NotNull String playerName, @NotNull String host, int port, @NotNull String endpoint, @NotNull String secret) {
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        URI uRI = URI.create("ws://" + host + ":" + port + "/" + endpoint);
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(\"ws://$host:$port/$endpoint\")");
        this.wsClient = new BGWWebSocketClient(uRI, playerName, secret, this);
        this.initializationJob = BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ BoardGameClient this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Set annotatedClasses = GameActionClassProcessor.INSTANCE.getAnnotatedClasses();
                        Map annotatedFunctions = GameActionReceiverProcessor.INSTANCE.getAnnotatedReceivers(this.this$0.getClass(), annotatedClasses);
                        this.this$0.gameActionClasses = annotatedClasses;
                        this.this$0.gameActionReceivers = annotatedFunctions;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public /* synthetic */ BoardGameClient(String string, String string2, int n, String string3, String string4, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            string3 = "chat";
        }
        this(string, string2, n, string3, string4);
    }

    public final void connect() {
        this.wsClient.connectBlocking();
    }

    public final void disconnect() {
        this.wsClient.closeBlocking();
    }

    public void onError(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        throw throwable;
    }

    public void onOpen() {
    }

    public void onClose(int code, @NotNull String reason, boolean remote) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
    }

    public final void createGame(@NotNull String gameID, @NotNull String sessionID) {
        Intrinsics.checkNotNullParameter((Object)gameID, (String)"gameID");
        Intrinsics.checkNotNullParameter((Object)sessionID, (String)"sessionID");
        this.wsClient.sendRequest((Request)new CreateGameMessage(gameID, sessionID));
    }

    public final void joinGame(@NotNull String sessionID, @NotNull String greetingMessage) {
        Intrinsics.checkNotNullParameter((Object)sessionID, (String)"sessionID");
        Intrinsics.checkNotNullParameter((Object)greetingMessage, (String)"greetingMessage");
        this.wsClient.sendRequest((Request)new JoinGameMessage(sessionID, greetingMessage));
    }

    public final void leaveGame(@NotNull String goodbyeMessage) {
        Intrinsics.checkNotNullParameter((Object)goodbyeMessage, (String)"goodbyeMessage");
        this.wsClient.sendRequest((Request)new LeaveGameMessage(goodbyeMessage));
    }

    public void onCreateGameResponse(@NotNull CreateGameResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
    }

    public void onJoinGameResponse(@NotNull JoinGameResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
    }

    public void onLeaveGameResponse(@NotNull LeaveGameResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
    }

    public void onUserJoined(@NotNull UserJoinedNotification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
    }

    public void onUserLeft(@NotNull UserDisconnectedNotification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
    }

    public final void sendGameActionMessage(@NotNull GameAction payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        this.wsClient.sendGameActionMessage(payload);
    }

    public void onGameActionResponse(@NotNull GameActionResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
    }

    public void onGameActionReceived(@NotNull GameAction message, @NotNull String sender) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        System.err.println("An incoming GameAction has been handled by the fallback function. Override onGameActionReceived or create dedicated handler for message type " + message.getClass().getCanonicalName() + ".");
    }

    public final void invokeAnnotatedReceiver$bgw_net_client(@NotNull GameActionMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, message, null){
            int label;
            final /* synthetic */ BoardGameClient this$0;
            final /* synthetic */ GameActionMessage $message;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        if (!BoardGameClient.access$getInitializationJob$p(this.this$0).isCompleted()) {
                            this.label = 1;
                            v0 = BoardGameClient.access$getInitializationJob$p(this.this$0).join((Continuation)this);
                            if (v0 == var11_2) {
                                return var11_2;
                            }
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        v1 = BoardGameClient.access$getGameActionClasses$p(this.this$0);
                        if (v1 == null) {
                            var4_3 = "Required value was null.";
                            throw new IllegalStateException(var4_3.toString());
                        }
                        targetClasses = v1;
                        v2 = BoardGameClient.access$getGameActionReceivers$p(this.this$0);
                        if (v2 == null) {
                            var5_6 = "Required value was null.";
                            throw new IllegalStateException(var5_6.toString());
                        }
                        targetReceivers = v2;
                        for (Class target : targetClasses) {
                            try {
                                payload = (GameAction)BoardGameClient.access$getWsClient$p(this.this$0).getMapper$bgw_net_client().readValue(this.$message.getPayload(), target);
                                var9_11 = targetReceivers;
                                var10_12 = targetReceivers.get(GameAction.class);
                                var8_13 = (Object[])var9_11.getOrDefault(target, var10_12);
                                if (var8_13 == null) {
                                    v3 = ReflectJvmMapping.getJavaMethod((KFunction)((KFunction)new Function2<GameAction, String, Unit>((Object)this.this$0){

                                        public final void invoke(@NotNull GameAction p0, @NotNull String p1) {
                                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                            ((BoardGameClient)this.receiver).onGameActionReceived(p0, p1);
                                        }
                                    }));
                                    if (v3 == null) {
                                        var10_12 = "Required value was null.";
                                        throw new IllegalStateException(var10_12.toString());
                                    }
                                } else {
                                    v3 = var8_13;
                                }
                                method = v3;
                                var8_13 = new Object[]{payload, this.$message.getSender()};
                                method.invoke((Object)this.this$0, var8_13);
                                return Unit.INSTANCE;
                            }
                            catch (JsonMappingException var6_9) {
                            }
                        }
                        System.err.println("Received GameActionMessage " + this.$message + " but no target class was Found. Create class annotated @GameActionClass extending GameAction in your classpath.");
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static final /* synthetic */ Job access$getInitializationJob$p(BoardGameClient $this) {
        return $this.initializationJob;
    }

    public static final /* synthetic */ Set access$getGameActionClasses$p(BoardGameClient $this) {
        return $this.gameActionClasses;
    }

    public static final /* synthetic */ Map access$getGameActionReceivers$p(BoardGameClient $this) {
        return $this.gameActionReceivers;
    }

    public static final /* synthetic */ BGWWebSocketClient access$getWsClient$p(BoardGameClient $this) {
        return $this.wsClient;
    }
}

