/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.net.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.aqua.bgw.net.client.BoardGameClient;
import tools.aqua.bgw.net.common.GameAction;
import tools.aqua.bgw.net.common.Message;
import tools.aqua.bgw.net.common.message.GameActionMessage;
import tools.aqua.bgw.net.common.notification.UserDisconnectedNotification;
import tools.aqua.bgw.net.common.notification.UserJoinedNotification;
import tools.aqua.bgw.net.common.request.Request;
import tools.aqua.bgw.net.common.response.CreateGameResponse;
import tools.aqua.bgw.net.common.response.GameActionResponse;
import tools.aqua.bgw.net.common.response.JoinGameResponse;
import tools.aqua.bgw.net.common.response.LeaveGameResponse;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00102\u000e\u0010\u001a\u001a\n\u0018\u00010\u001bj\u0004\u0018\u0001`\u001cH\u0016J\u0012\u0010\u001d\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0016J\u0012\u0010\u001e\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u000e\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020%R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006&"}, d2={"Ltools/aqua/bgw/net/client/BGWWebSocketClient;", "Lorg/java_websocket/client/WebSocketClient;", "uri", "Ljava/net/URI;", "playerName", "", "secret", "callback", "Ltools/aqua/bgw/net/client/BoardGameClient;", "(Ljava/net/URI;Ljava/lang/String;Ljava/lang/String;Ltools/aqua/bgw/net/client/BoardGameClient;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "getMapper$bgw_net_client", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "messageMapping", "", "message", "Ltools/aqua/bgw/net/common/Message;", "onClose", "code", "", "reason", "remote", "", "onError", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onMessage", "onOpen", "handshakedata", "Lorg/java_websocket/handshake/ServerHandshake;", "sendGameActionMessage", "payload", "Ltools/aqua/bgw/net/common/GameAction;", "sendRequest", "Ltools/aqua/bgw/net/common/request/Request;", "bgw-net-client"})
public final class BGWWebSocketClient
extends WebSocketClient {
    @NotNull
    private final BoardGameClient callback;
    private final ObjectMapper mapper;

    public BGWWebSocketClient(@NotNull URI uri, @NotNull String playerName, @NotNull String secret, @NotNull BoardGameClient callback) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        super(uri);
        this.callback = callback;
        this.mapper = new ObjectMapper().registerModule((Module)ExtensionsKt.kotlinModule$default(null, (int)1, null));
        this.addHeader("PlayerName", playerName);
        this.addHeader("SoPraSecret", secret);
    }

    public final ObjectMapper getMapper$bgw_net_client() {
        return this.mapper;
    }

    public final void sendRequest(@NotNull Request message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.send(this.mapper.writeValueAsString((Object)message));
    }

    public final void sendGameActionMessage(@NotNull GameAction payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        String string = this.mapper.writeValueAsString((Object)payload);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mapper.writeValueAsString(payload)");
        this.send(this.mapper.writeValueAsString((Object)new GameActionMessage(string, payload.toString(), "")));
    }

    public void onOpen(@Nullable ServerHandshake handshakedata) {
        this.callback.onOpen();
    }

    public void onClose(int code, @Nullable String reason, boolean remote) {
        String string = reason;
        if (string == null) {
            string = "n/a";
        }
        this.callback.onClose(code, string, remote);
    }

    public void onError(@Nullable Exception ex) {
        Exception exception = ex;
        if (exception == null) {
            exception = new NullPointerException("Exception itself is null.");
        }
        this.callback.onError(exception);
    }

    public void onMessage(@Nullable String message) {
        try {
            Object object = this.mapper.readValue(message, Message.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mapper.readValue(message, Message::class.java)");
            this.messageMapping((Message)object);
        }
        catch (IllegalArgumentException ise) {
            this.onError(ise);
        }
        catch (JsonProcessingException jse) {
            this.onError((Exception)((Object)jse));
        }
    }

    private final void messageMapping(Message message) {
        if (!(!(message instanceof Request))) {
            boolean bl = false;
            String string = "Client received a request";
            throw new IllegalArgumentException(string.toString());
        }
        Message message2 = message;
        if (message2 instanceof GameActionMessage) {
            this.callback.invokeAnnotatedReceiver$bgw_net_client((GameActionMessage)message);
        } else if (message2 instanceof GameActionResponse) {
            this.callback.onGameActionResponse((GameActionResponse)message);
        } else if (message2 instanceof CreateGameResponse) {
            this.callback.onCreateGameResponse((CreateGameResponse)message);
        } else if (message2 instanceof JoinGameResponse) {
            this.callback.onJoinGameResponse((JoinGameResponse)message);
        } else if (message2 instanceof LeaveGameResponse) {
            this.callback.onLeaveGameResponse((LeaveGameResponse)message);
        } else if (message2 instanceof UserJoinedNotification) {
            this.callback.onUserJoined((UserJoinedNotification)message);
        } else if (message2 instanceof UserDisconnectedNotification) {
            this.callback.onUserLeft((UserDisconnectedNotification)message);
        }
    }
}

