/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.net.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.net.URI;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.aqua.bgw.net.client.BoardGameClient;
import tools.aqua.bgw.net.client.NetworkLogger;
import tools.aqua.bgw.net.common.GameAction;
import tools.aqua.bgw.net.common.Message;
import tools.aqua.bgw.net.common.message.GameActionMessage;
import tools.aqua.bgw.net.common.notification.PlayerJoinedNotification;
import tools.aqua.bgw.net.common.notification.PlayerLeftNotification;
import tools.aqua.bgw.net.common.notification.SpectatorJoinedNotification;
import tools.aqua.bgw.net.common.request.Request;
import tools.aqua.bgw.net.common.response.CreateGameResponse;
import tools.aqua.bgw.net.common.response.GameActionResponse;
import tools.aqua.bgw.net.common.response.JoinGameResponse;
import tools.aqua.bgw.net.common.response.LeaveGameResponse;
import tools.aqua.bgw.net.common.response.SpectatorJoinGameResponse;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dJ\u0012\u0010\u001e\u001a\u00020\u00182\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\"\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u00052\u0006\u0010%\u001a\u00020&H\u0016J\u001d\u0010'\u001a\u00020\u00182\u000e\u0010(\u001a\n\u0018\u00010*j\u0004\u0018\u0001`)H\u0016\u00a2\u0006\u0002\u0010+J\u0012\u0010,\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020.H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006/"}, d2={"Ltools/aqua/bgw/net/client/BGWWebSocketClient;", "Lorg/java_websocket/client/WebSocketClient;", "uri", "Ljava/net/URI;", "playerName", "", "secret", "callback", "Ltools/aqua/bgw/net/client/BoardGameClient;", "logger", "Ltools/aqua/bgw/net/client/NetworkLogger;", "<init>", "(Ljava/net/URI;Ljava/lang/String;Ljava/lang/String;Ltools/aqua/bgw/net/client/BoardGameClient;Ltools/aqua/bgw/net/client/NetworkLogger;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "getMapper$bgw_net_client", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "getScope$bgw_net_client", "()Lkotlinx/coroutines/CoroutineScope;", "sendRequest", "", "message", "Ltools/aqua/bgw/net/common/request/Request;", "sendGameActionMessage", "payload", "Ltools/aqua/bgw/net/common/GameAction;", "onOpen", "handshakedata", "Lorg/java_websocket/handshake/ServerHandshake;", "onClose", "code", "", "reason", "remote", "", "onError", "ex", "Lkotlin/Exception;", "Ljava/lang/Exception;", "(Ljava/lang/Exception;)V", "onMessage", "messageMapping", "Ltools/aqua/bgw/net/common/Message;", "bgw-net-client"})
@SourceDebugExtension(value={"SMAP\nBGWWebSocketClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BGWWebSocketClient.kt\ntools/aqua/bgw/net/client/BGWWebSocketClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,203:1\n1#2:204\n*E\n"})
public final class BGWWebSocketClient
extends WebSocketClient {
    @NotNull
    private final URI uri;
    @NotNull
    private final String playerName;
    @NotNull
    private final String secret;
    @NotNull
    private final BoardGameClient callback;
    @NotNull
    private final NetworkLogger logger;
    private final ObjectMapper mapper;
    @NotNull
    private final CoroutineScope scope;

    public BGWWebSocketClient(@NotNull URI uri, @NotNull String playerName, @NotNull String secret, @NotNull BoardGameClient callback, @NotNull NetworkLogger logger) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        super(uri);
        this.uri = uri;
        this.playerName = playerName;
        this.secret = secret;
        this.callback = callback;
        this.logger = logger;
        this.mapper = new ObjectMapper().registerModule((Module)ExtensionsKt.kotlinModule$default(null, (int)1, null));
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()));
        this.addHeader("PlayerName", this.playerName);
        this.addHeader("NetworkSecret", this.secret);
    }

    public final ObjectMapper getMapper$bgw_net_client() {
        return this.mapper;
    }

    @NotNull
    public final CoroutineScope getScope$bgw_net_client() {
        return this.scope;
    }

    public final void sendRequest(@NotNull Request message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.send(this.mapper.writeValueAsString((Object)message));
    }

    public final void sendGameActionMessage(@NotNull GameAction payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        String payloadJson = this.mapper.writeValueAsString((Object)payload);
        String clazz = payload.getClass().getName();
        Intrinsics.checkNotNull((Object)clazz);
        Intrinsics.checkNotNull((Object)payloadJson);
        GameActionMessage msg = new GameActionMessage(clazz, payloadJson, payload.toString(), this.playerName);
        this.logger.debug("Sending GameAction as JSON: " + payloadJson);
        this.send(this.mapper.writeValueAsString((Object)msg));
    }

    public void onOpen(@Nullable ServerHandshake handshakedata) {
        this.logger.info("Connection is now open.");
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ BGWWebSocketClient this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        BGWWebSocketClient.access$getCallback$p(this.this$0).onOpen();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void onClose(int code, @Nullable String reason, boolean remote) {
        this.logger.info("Connection is now closed.");
        this.logger.debug("Status code is: " + code + ". The connection was closed with the following reason: " + reason + ". The closing was initiated by the " + (remote ? "remote" : "local") + " host.");
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, code, reason, remote, null){
            int label;
            final /* synthetic */ BGWWebSocketClient this$0;
            final /* synthetic */ int $code;
            final /* synthetic */ String $reason;
            final /* synthetic */ boolean $remote;
            {
                this.this$0 = $receiver;
                this.$code = $code;
                this.$reason = $reason;
                this.$remote = $remote;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        BoardGameClient boardGameClient = BGWWebSocketClient.access$getCallback$p(this.this$0);
                        String string = this.$reason;
                        if (string == null) {
                            string = "n/a";
                        }
                        boardGameClient.onClose(this.$code, string, this.$remote);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void onError(@Nullable Exception ex) {
        this.logger.error("An uncaught error occurred.", ex);
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, ex, null){
            int label;
            final /* synthetic */ BGWWebSocketClient this$0;
            final /* synthetic */ Exception $ex;
            {
                this.this$0 = $receiver;
                this.$ex = $ex;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        BoardGameClient boardGameClient = BGWWebSocketClient.access$getCallback$p(this.this$0);
                        Exception exception = this.$ex;
                        if (exception == null) {
                            exception = new NullPointerException("Exception itself is null.");
                        }
                        boardGameClient.onError(exception);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void onMessage(@Nullable String message) {
        this.logger.info("Received message: " + message);
        try {
            Message msg = (Message)this.mapper.readValue(message, Message.class);
            this.logger.debug("Received message of type " + msg);
            BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, msg, null){
                int label;
                final /* synthetic */ BGWWebSocketClient this$0;
                final /* synthetic */ Message $msg;
                {
                    this.this$0 = $receiver;
                    this.$msg = $msg;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            Message message = this.$msg;
                            Intrinsics.checkNotNull((Object)message);
                            BGWWebSocketClient.access$messageMapping(this.this$0, message);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        catch (IllegalArgumentException ise) {
            this.onError(ise);
        }
        catch (JsonProcessingException jse) {
            this.onError((Exception)((Object)jse));
        }
    }

    private final void messageMapping(Message message) {
        if (!(!(message instanceof Request))) {
            boolean bl = false;
            String string = "Client received a request";
            throw new IllegalArgumentException(string.toString());
        }
        Message message2 = message;
        if (message2 instanceof GameActionMessage) {
            this.logger.debug("Received GameActionMessage. Invoking annotated receiver function.");
            this.callback.invokeAnnotatedReceiver$bgw_net_client((GameActionMessage)message);
        } else if (message2 instanceof GameActionResponse) {
            this.logger.debug("Received GameActionResponse. Invoking handler for onGameActionResponse.");
            this.callback.onGameActionResponse((GameActionResponse)message);
        } else if (message2 instanceof CreateGameResponse) {
            this.logger.debug("Received CreateGameResponse. Invoking handler for onCreateGameResponse.");
            this.callback.onCreateGameResponse((CreateGameResponse)message);
        } else if (message2 instanceof JoinGameResponse) {
            this.logger.debug("Received JoinGameResponse. Invoking handler for onJoinGameResponse.");
            this.callback.onJoinGameResponse((JoinGameResponse)message);
        } else if (message2 instanceof SpectatorJoinGameResponse) {
            this.logger.debug("Received SpectatorJoinGameResponse. Invoking handler for onSpectatorJoinGameResponse.");
            this.callback.onSpectatorJoinGameResponse((SpectatorJoinGameResponse)message);
        } else if (message2 instanceof LeaveGameResponse) {
            this.logger.debug("Received LeaveGameResponse. Invoking handler for onLeaveGameResponse.");
            this.callback.onLeaveGameResponse((LeaveGameResponse)message);
        } else if (message2 instanceof PlayerJoinedNotification) {
            this.logger.debug("Received PlayerJoinedNotification. Invoking handler for onPlayerJoined.");
            this.callback.onPlayerJoined((PlayerJoinedNotification)message);
        } else if (message2 instanceof SpectatorJoinedNotification) {
            this.logger.debug("Received SpectatorJoinedNotification. Invoking handler for onSpectatorJoined.");
            this.callback.onSpectatorJoined((SpectatorJoinedNotification)message);
        } else if (message2 instanceof PlayerLeftNotification) {
            this.logger.debug("Received PlayerLeftNotification. Invoking handler for onPlayerLeft.");
            this.callback.onPlayerLeft((PlayerLeftNotification)message);
        }
    }

    public static final /* synthetic */ BoardGameClient access$getCallback$p(BGWWebSocketClient $this) {
        return $this.callback;
    }

    public static final /* synthetic */ void access$messageMapping(BGWWebSocketClient $this, Message message) {
        $this.messageMapping(message);
    }
}

