/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.examples.maumau.service.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tools.aqua.bgw.examples.maumau.entity.CardSuit;
import tools.aqua.bgw.examples.maumau.entity.CardValue;
import tools.aqua.bgw.examples.maumau.entity.GameActionType;
import tools.aqua.bgw.examples.maumau.entity.MauMauCard;
import tools.aqua.bgw.examples.maumau.entity.MauMauGame;
import tools.aqua.bgw.examples.maumau.service.network.messages.MauMauGameCard;
import tools.aqua.bgw.examples.maumau.service.network.messages.MauMauInitGameAction;
import tools.aqua.bgw.examples.maumau.service.network.messages.MauMauShuffleStackGameAction;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002J\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013J\n\u0010\u0016\u001a\u00020\u0017*\u00020\u0018J\n\u0010\u0019\u001a\u00020\u0018*\u00020\u0017\u00a8\u0006\u001a"}, d2={"Ltools/aqua/bgw/examples/maumau/service/network/NetworkSerialization;", "", "()V", "deserializeCardSuit", "Ltools/aqua/bgw/examples/maumau/entity/CardSuit;", "suit", "", "deserializeCardValue", "Ltools/aqua/bgw/examples/maumau/entity/CardValue;", "value", "deserializeGameAction", "Ltools/aqua/bgw/examples/maumau/entity/GameActionType;", "action", "serializeCardSuit", "serializeCardValue", "serializeGameAction", "serializeInitMessage", "Ltools/aqua/bgw/examples/maumau/service/network/messages/MauMauInitGameAction;", "game", "Ltools/aqua/bgw/examples/maumau/entity/MauMauGame;", "serializeStacksShuffledMessage", "Ltools/aqua/bgw/examples/maumau/service/network/messages/MauMauShuffleStackGameAction;", "deserialize", "Ltools/aqua/bgw/examples/maumau/entity/MauMauCard;", "Ltools/aqua/bgw/examples/maumau/service/network/messages/MauMauGameCard;", "serialize", "bgw-maumau-example"})
public final class NetworkSerialization {
    @NotNull
    public static final NetworkSerialization INSTANCE = new NetworkSerialization();

    private NetworkSerialization() {
    }

    @NotNull
    public final MauMauGameCard serialize(@NotNull MauMauCard $this$serialize) {
        Intrinsics.checkNotNullParameter((Object)$this$serialize, (String)"<this>");
        return new MauMauGameCard(this.serializeCardSuit($this$serialize.getCardSuit()), this.serializeCardValue($this$serialize.getCardValue()));
    }

    @NotNull
    public final MauMauCard deserialize(@NotNull MauMauGameCard $this$deserialize) {
        Intrinsics.checkNotNullParameter((Object)$this$deserialize, (String)"<this>");
        CardSuit cardSuit = this.deserializeCardSuit($this$deserialize.getSuit());
        CardValue cardValue = this.deserializeCardValue($this$deserialize.getValue());
        return new MauMauCard(cardValue, cardSuit);
    }

    @NotNull
    public final MauMauInitGameAction serializeInitMessage(@NotNull MauMauGame game) {
        Collection<MauMauGameCard> collection;
        Collection collection2;
        MauMauCard it;
        Collection collection3;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)game, (String)"game");
        Iterable $this$map$iv = game.getPlayers().get(0).getHand().getCards();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MauMauCard mauMauCard = (MauMauCard)item$iv$iv;
            collection3 = destination$iv$iv;
            boolean bl = false;
            collection3.add(INSTANCE.serialize(it));
        }
        $this$map$iv = game.getPlayers().get(1).getHand().getCards();
        collection3 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (MauMauCard)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(INSTANCE.serialize(it));
        }
        $this$map$iv = game.getDrawStack().getCards();
        collection2 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (MauMauCard)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(INSTANCE.serialize(it));
        }
        collection = (List)destination$iv$iv;
        Object object = CollectionsKt.first((List)game.getGameStack().getCards());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"game.gameStack.cards.first()");
        MauMauGameCard mauMauGameCard = this.serialize((MauMauCard)object);
        List list = collection;
        Collection collection4 = collection2;
        Collection collection5 = collection3;
        return new MauMauInitGameAction((List<MauMauGameCard>)collection5, (List<MauMauGameCard>)collection4, list, mauMauGameCard);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MauMauShuffleStackGameAction serializeStacksShuffledMessage(@NotNull MauMauGame game) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)game, (String)"game");
        Iterable $this$map$iv = game.getDrawStack().getCards();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MauMauCard mauMauCard = (MauMauCard)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(INSTANCE.serialize((MauMauCard)it));
        }
        List list = (List)destination$iv$iv;
        Object object = CollectionsKt.first((List)game.getGameStack().getCards());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"game.gameStack.cards.first()");
        MauMauGameCard mauMauGameCard = this.serialize((MauMauCard)object);
        List list2 = list;
        return new MauMauShuffleStackGameAction(list2, mauMauGameCard);
    }

    @NotNull
    public final String serializeGameAction(@NotNull GameActionType action) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        switch (WhenMappings.$EnumSwitchMapping$0[action.ordinal()]) {
            case 1: {
                string = "PLAY_CARD";
                break;
            }
            case 2: {
                string = "DRAW_CARD";
                break;
            }
            case 3: {
                string = "OPPONENT_DRAW_TWO_CARDS";
                break;
            }
            case 4: {
                string = "REQUEST_SUIT_SELECTION";
                break;
            }
            case 5: {
                string = "END_TURN";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public final GameActionType deserializeGameAction(@NotNull String action) {
        GameActionType gameActionType;
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        switch (action) {
            case "PLAY_CARD": {
                gameActionType = GameActionType.PLAY;
                break;
            }
            case "DRAW_CARD": {
                gameActionType = GameActionType.DRAW;
                break;
            }
            case "OPPONENT_DRAW_TWO_CARDS": {
                gameActionType = GameActionType.REQUEST_DRAW_TWO;
                break;
            }
            case "REQUEST_SUIT_SELECTION": {
                gameActionType = GameActionType.REQUEST_SUIT;
                break;
            }
            case "END_TURN": {
                gameActionType = GameActionType.END_TURN;
                break;
            }
            default: {
                throw new NoSuchElementException("Invalid json enum value: " + action);
            }
        }
        return gameActionType;
    }

    private final String serializeCardSuit(CardSuit suit) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$1[suit.ordinal()]) {
            case 1: {
                string = "C";
                break;
            }
            case 2: {
                string = "S";
                break;
            }
            case 3: {
                string = "H";
                break;
            }
            case 4: {
                string = "D";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final CardSuit deserializeCardSuit(String suit) {
        CardSuit cardSuit;
        switch (suit) {
            case "C": {
                cardSuit = CardSuit.CLUBS;
                break;
            }
            case "S": {
                cardSuit = CardSuit.SPADES;
                break;
            }
            case "H": {
                cardSuit = CardSuit.HEARTS;
                break;
            }
            case "D": {
                cardSuit = CardSuit.DIAMONDS;
                break;
            }
            default: {
                throw new NoSuchElementException("Invalid json enum value: " + suit);
            }
        }
        return cardSuit;
    }

    private final String serializeCardValue(CardValue value) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$2[value.ordinal()]) {
            case 1: {
                string = "A";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                throw new NoSuchElementException("This card value does not exist in MauMau.");
            }
            case 7: {
                string = "7";
                break;
            }
            case 8: {
                string = "8";
                break;
            }
            case 9: {
                string = "9";
                break;
            }
            case 10: {
                string = "10";
                break;
            }
            case 11: {
                string = "J";
                break;
            }
            case 12: {
                string = "Q";
                break;
            }
            case 13: {
                string = "K";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final CardValue deserializeCardValue(String value) {
        CardValue cardValue;
        switch (value) {
            case "7": {
                cardValue = CardValue.SEVEN;
                break;
            }
            case "8": {
                cardValue = CardValue.EIGHT;
                break;
            }
            case "9": {
                cardValue = CardValue.NINE;
                break;
            }
            case "10": {
                cardValue = CardValue.TEN;
                break;
            }
            case "J": {
                cardValue = CardValue.JACK;
                break;
            }
            case "Q": {
                cardValue = CardValue.QUEEN;
                break;
            }
            case "K": {
                cardValue = CardValue.KING;
                break;
            }
            case "A": {
                cardValue = CardValue.ACE;
                break;
            }
            default: {
                throw new NoSuchElementException("Invalid json enum value: " + value);
            }
        }
        return cardValue;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[GameActionType.values().length];
            nArray[GameActionType.PLAY.ordinal()] = 1;
            nArray[GameActionType.DRAW.ordinal()] = 2;
            nArray[GameActionType.REQUEST_DRAW_TWO.ordinal()] = 3;
            nArray[GameActionType.REQUEST_SUIT.ordinal()] = 4;
            nArray[GameActionType.END_TURN.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CardSuit.values().length];
            nArray[CardSuit.CLUBS.ordinal()] = 1;
            nArray[CardSuit.SPADES.ordinal()] = 2;
            nArray[CardSuit.HEARTS.ordinal()] = 3;
            nArray[CardSuit.DIAMONDS.ordinal()] = 4;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[CardValue.values().length];
            nArray[CardValue.ACE.ordinal()] = 1;
            nArray[CardValue.TWO.ordinal()] = 2;
            nArray[CardValue.THREE.ordinal()] = 3;
            nArray[CardValue.FOUR.ordinal()] = 4;
            nArray[CardValue.FIVE.ordinal()] = 5;
            nArray[CardValue.SIX.ordinal()] = 6;
            nArray[CardValue.SEVEN.ordinal()] = 7;
            nArray[CardValue.EIGHT.ordinal()] = 8;
            nArray[CardValue.NINE.ordinal()] = 9;
            nArray[CardValue.TEN.ordinal()] = 10;
            nArray[CardValue.JACK.ordinal()] = 11;
            nArray[CardValue.QUEEN.ordinal()] = 12;
            nArray[CardValue.KING.ordinal()] = 13;
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

