/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.examples.maumau.service.network;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tools.aqua.bgw.core.BoardGameApplication;
import tools.aqua.bgw.examples.maumau.entity.GameActionType;
import tools.aqua.bgw.examples.maumau.entity.MauMauPlayer;
import tools.aqua.bgw.examples.maumau.service.LogicController;
import tools.aqua.bgw.examples.maumau.service.network.NetworkSerialization;
import tools.aqua.bgw.examples.maumau.service.network.messages.MauMauEndGameAction;
import tools.aqua.bgw.examples.maumau.service.network.messages.MauMauGameAction;
import tools.aqua.bgw.examples.maumau.service.network.messages.MauMauInitGameAction;
import tools.aqua.bgw.examples.maumau.service.network.messages.MauMauShuffleStackGameAction;
import tools.aqua.bgw.examples.maumau.view.Refreshable;
import tools.aqua.bgw.net.client.BoardGameClient;
import tools.aqua.bgw.net.client.NetworkLogging;
import tools.aqua.bgw.net.common.annotations.GameActionReceiver;
import tools.aqua.bgw.net.common.notification.PlayerJoinedNotification;
import tools.aqua.bgw.net.common.notification.PlayerLeftNotification;
import tools.aqua.bgw.net.common.response.CreateGameResponse;
import tools.aqua.bgw.net.common.response.CreateGameResponseStatus;
import tools.aqua.bgw.net.common.response.JoinGameResponse;
import tools.aqua.bgw.net.common.response.JoinGameResponseStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0003J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0003H\u0003J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0003H\u0003J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u0003H\u0003R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006$"}, d2={"Ltools/aqua/bgw/examples/maumau/service/network/MauMauBoardGameClient;", "Ltools/aqua/bgw/net/client/BoardGameClient;", "playerName", "", "host", "secret", "logicController", "Ltools/aqua/bgw/examples/maumau/service/LogicController;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ltools/aqua/bgw/examples/maumau/service/LogicController;)V", "getLogicController", "()Ltools/aqua/bgw/examples/maumau/service/LogicController;", "view", "Ltools/aqua/bgw/examples/maumau/view/Refreshable;", "getView", "()Ltools/aqua/bgw/examples/maumau/view/Refreshable;", "onCreateGameResponse", "", "response", "Ltools/aqua/bgw/net/common/response/CreateGameResponse;", "onEndGameReceived", "message", "Ltools/aqua/bgw/examples/maumau/service/network/messages/MauMauEndGameAction;", "sender", "onGameActionReceived", "Ltools/aqua/bgw/examples/maumau/service/network/messages/MauMauGameAction;", "onInitReceived", "Ltools/aqua/bgw/examples/maumau/service/network/messages/MauMauInitGameAction;", "onJoinGameResponse", "Ltools/aqua/bgw/net/common/response/JoinGameResponse;", "onPlayerJoined", "notification", "Ltools/aqua/bgw/net/common/notification/PlayerJoinedNotification;", "onPlayerLeft", "Ltools/aqua/bgw/net/common/notification/PlayerLeftNotification;", "onShuffleDrawStackReceived", "Ltools/aqua/bgw/examples/maumau/service/network/messages/MauMauShuffleStackGameAction;", "bgw-maumau-example"})
public final class MauMauBoardGameClient
extends BoardGameClient {
    @NotNull
    private final LogicController logicController;
    @NotNull
    private final Refreshable view;

    public MauMauBoardGameClient(@NotNull String playerName, @NotNull String host, @NotNull String secret, @NotNull LogicController logicController) {
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter((Object)logicController, (String)"logicController");
        super(playerName, host, secret, NetworkLogging.VERBOSE);
        this.logicController = logicController;
        this.view = this.logicController.getView();
    }

    @NotNull
    public final LogicController getLogicController() {
        return this.logicController;
    }

    @NotNull
    public final Refreshable getView() {
        return this.view;
    }

    public void onCreateGameResponse(@NotNull CreateGameResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        BoardGameApplication.Companion.runOnGUIThread(() -> MauMauBoardGameClient.onCreateGameResponse$lambda-0(response, this));
    }

    public void onJoinGameResponse(@NotNull JoinGameResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        BoardGameApplication.Companion.runOnGUIThread(() -> MauMauBoardGameClient.onJoinGameResponse$lambda-1(response, this));
    }

    public void onPlayerJoined(@NotNull PlayerJoinedNotification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        BoardGameApplication.Companion.runOnGUIThread(() -> MauMauBoardGameClient.onPlayerJoined$lambda-2(this, notification));
    }

    public void onPlayerLeft(@NotNull PlayerLeftNotification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        BoardGameApplication.Companion.runOnGUIThread(() -> MauMauBoardGameClient.onPlayerLeft$lambda-3(this, notification));
    }

    @GameActionReceiver
    private final void onInitReceived(MauMauInitGameAction message, String sender) {
        BoardGameApplication.Companion.runOnGUIThread(() -> MauMauBoardGameClient.onInitReceived$lambda-4(this, message));
    }

    @GameActionReceiver
    private final void onShuffleDrawStackReceived(MauMauShuffleStackGameAction message, String sender) {
        BoardGameApplication.Companion.runOnGUIThread(() -> MauMauBoardGameClient.onShuffleDrawStackReceived$lambda-5(this, message));
    }

    @GameActionReceiver
    private final void onGameActionReceived(MauMauGameAction message, String sender) {
        BoardGameApplication.Companion.runOnGUIThread(() -> MauMauBoardGameClient.onGameActionReceived$lambda-6(message, this));
    }

    @GameActionReceiver
    private final void onEndGameReceived(MauMauEndGameAction message, String sender) {
        BoardGameApplication.Companion.runOnGUIThread(() -> MauMauBoardGameClient.onEndGameReceived$lambda-7(this, sender));
    }

    private static final void onCreateGameResponse$lambda-0(CreateGameResponse $response, MauMauBoardGameClient this$0) {
        Intrinsics.checkNotNullParameter((Object)$response, (String)"$response");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        switch (WhenMappings.$EnumSwitchMapping$0[$response.getStatus().ordinal()]) {
            case 1: {
                this$0.view.onCreateGameSuccess($response.getSessionID());
                break;
            }
            case 2: {
                this$0.view.onCreateGameError("You are already in a game.");
                break;
            }
            case 3: {
                this$0.view.onCreateGameError("Session id already exists.");
                break;
            }
            case 4: {
                throw new IllegalStateException($response.toString());
            }
            case 5: {
                this$0.view.onServerError();
            }
        }
    }

    private static final void onJoinGameResponse$lambda-1(JoinGameResponse $response, MauMauBoardGameClient this$0) {
        Intrinsics.checkNotNullParameter((Object)$response, (String)"$response");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        switch (WhenMappings.$EnumSwitchMapping$1[$response.getStatus().ordinal()]) {
            case 1: {
                String string = (String)CollectionsKt.firstOrNull((List)$response.getOpponents());
                if (string == null) {
                    string = "Host";
                }
                this$0.logicController.getGame().getPlayers().get(1).setName(string);
                this$0.view.onJoinGameSuccess();
                break;
            }
            case 2: {
                this$0.view.onCreateGameError("You are already in a game.");
                break;
            }
            case 3: {
                this$0.view.onCreateGameError("Session id invalid.");
                break;
            }
            case 4: {
                this$0.view.onJoinGameError("Player name is already taken.");
                break;
            }
            case 5: {
                this$0.view.onServerError();
            }
        }
    }

    private static final void onPlayerJoined$lambda-2(MauMauBoardGameClient this$0, PlayerJoinedNotification $notification) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$notification, (String)"$notification");
        this$0.logicController.getGame().getPlayers().set(1, new MauMauPlayer($notification.getSender()));
        this$0.logicController.getView().onUserJoined($notification.getSender());
    }

    private static final void onPlayerLeft$lambda-3(MauMauBoardGameClient this$0, PlayerLeftNotification $notification) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$notification, (String)"$notification");
        this$0.logicController.getView().onUserLeft($notification.getSender());
    }

    private static final void onInitReceived$lambda-4(MauMauBoardGameClient this$0, MauMauInitGameAction $message) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$message), (String)"$message");
        this$0.logicController.initGame($message);
        this$0.view.onInitializeGameReceived();
    }

    private static final void onShuffleDrawStackReceived$lambda-5(MauMauBoardGameClient this$0, MauMauShuffleStackGameAction $message) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$message), (String)"$message");
        this$0.logicController.shuffleStack($message);
        this$0.view.onShuffleStackReceived();
    }

    private static final void onGameActionReceived$lambda-6(MauMauGameAction $message, MauMauBoardGameClient this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)$message), (String)"$message");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        switch (WhenMappings.$EnumSwitchMapping$2[NetworkSerialization.INSTANCE.deserializeGameAction($message.getAction()).ordinal()]) {
            case 1: {
                if ($message.getCard() == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                this$0.logicController.playCard(NetworkSerialization.INSTANCE.deserialize($message.getCard()), true, false);
                break;
            }
            case 2: {
                this$0.logicController.drawCard(false, false);
                break;
            }
            case 3: {
                this$0.logicController.drawCard(true, false);
                this$0.logicController.drawCard(true, false);
                break;
            }
            case 4: {
                if ($message.getCard() == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                this$0.logicController.selectSuit(NetworkSerialization.INSTANCE.deserialize($message.getCard()).getCardSuit(), false);
                break;
            }
            case 5: {
                this$0.view.refreshEndTurn();
            }
        }
    }

    private static final void onEndGameReceived$lambda-7(MauMauBoardGameClient this$0, String $sender) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$sender, (String)"$sender");
        this$0.view.refreshEndGame($sender);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[CreateGameResponseStatus.values().length];
            nArray[CreateGameResponseStatus.SUCCESS.ordinal()] = 1;
            nArray[CreateGameResponseStatus.ALREADY_ASSOCIATED_WITH_GAME.ordinal()] = 2;
            nArray[CreateGameResponseStatus.SESSION_WITH_ID_ALREADY_EXISTS.ordinal()] = 3;
            nArray[CreateGameResponseStatus.GAME_ID_DOES_NOT_EXIST.ordinal()] = 4;
            nArray[CreateGameResponseStatus.SERVER_ERROR.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[JoinGameResponseStatus.values().length];
            nArray[JoinGameResponseStatus.SUCCESS.ordinal()] = 1;
            nArray[JoinGameResponseStatus.ALREADY_ASSOCIATED_WITH_GAME.ordinal()] = 2;
            nArray[JoinGameResponseStatus.INVALID_SESSION_ID.ordinal()] = 3;
            nArray[JoinGameResponseStatus.PLAYER_NAME_ALREADY_TAKEN.ordinal()] = 4;
            nArray[JoinGameResponseStatus.SERVER_ERROR.ordinal()] = 5;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[GameActionType.values().length];
            nArray[GameActionType.PLAY.ordinal()] = 1;
            nArray[GameActionType.DRAW.ordinal()] = 2;
            nArray[GameActionType.REQUEST_DRAW_TWO.ordinal()] = 3;
            nArray[GameActionType.REQUEST_SUIT.ordinal()] = 4;
            nArray[GameActionType.END_TURN.ordinal()] = 5;
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

