/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.examples.maumau.view;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.aqua.bgw.animation.Animation;
import tools.aqua.bgw.animation.DelayAnimation;
import tools.aqua.bgw.animation.FlipAnimation;
import tools.aqua.bgw.animation.MovementAnimation;
import tools.aqua.bgw.components.ComponentView;
import tools.aqua.bgw.components.container.CardStack;
import tools.aqua.bgw.components.container.GameComponentContainer;
import tools.aqua.bgw.components.container.LinearLayout;
import tools.aqua.bgw.components.gamecomponentviews.CardView;
import tools.aqua.bgw.components.gamecomponentviews.GameComponentView;
import tools.aqua.bgw.core.BoardGameApplication;
import tools.aqua.bgw.core.MenuScene;
import tools.aqua.bgw.core.Scene;
import tools.aqua.bgw.dialog.ButtonType;
import tools.aqua.bgw.dialog.Dialog;
import tools.aqua.bgw.dialog.DialogType;
import tools.aqua.bgw.event.AnimationFinishedEvent;
import tools.aqua.bgw.event.DragEvent;
import tools.aqua.bgw.event.DropEvent;
import tools.aqua.bgw.event.MouseEvent;
import tools.aqua.bgw.examples.maumau.entity.MauMauCard;
import tools.aqua.bgw.examples.maumau.entity.MauMauGame;
import tools.aqua.bgw.examples.maumau.view.MauMauViewController;
import tools.aqua.bgw.examples.maumau.view.Refreshable;
import tools.aqua.bgw.examples.maumau.view.scenes.MauMauPlayerWonScene;
import tools.aqua.bgw.examples.maumau.view.scenes.MauMauWaitForOpponentMenuScene;
import tools.aqua.bgw.util.BidirectionalMap;
import tools.aqua.bgw.visual.ColorVisual;
import tools.aqua.bgw.visual.CompoundVisual;
import tools.aqua.bgw.visual.ImageVisual;
import tools.aqua.bgw.visual.SingleLayerVisual;
import tools.aqua.bgw.visual.Visual;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\fH\u0016J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\fH\u0016J\b\u0010\u0017\u001a\u00020\nH\u0016J\b\u0010\u0018\u001a\u00020\nH\u0016J\u0018\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\fH\u0016J\b\u0010\"\u001a\u00020\nH\u0016J\b\u0010#\u001a\u00020\nH\u0016J\b\u0010$\u001a\u00020\nH\u0002J\b\u0010%\u001a\u00020\nH\u0016J\u0010\u0010&\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010'\u001a\u00020\nH\u0016J\b\u0010(\u001a\u00020\nH\u0016J\b\u0010)\u001a\u00020\nH\u0016J\u0018\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010,\u001a\u00020\nH\u0016J\u0010\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020\u001dH\u0002J\f\u0010.\u001a\u00020\n*\u00020/H\u0002J\f\u00100\u001a\u00020\n*\u00020/H\u0002J\f\u00101\u001a\u00020\n*\u00020/H\u0002J\f\u00102\u001a\u00020\n*\u00020/H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Ltools/aqua/bgw/examples/maumau/view/RefreshViewController;", "Ltools/aqua/bgw/examples/maumau/view/Refreshable;", "viewController", "Ltools/aqua/bgw/examples/maumau/view/MauMauViewController;", "(Ltools/aqua/bgw/examples/maumau/view/MauMauViewController;)V", "hintOverlay", "Ltools/aqua/bgw/visual/ColorVisual;", "image", "Ljava/awt/image/BufferedImage;", "onCreateGameError", "", "message", "", "onCreateGameSuccess", "sessionID", "onInitializeGameReceived", "onJoinGameError", "onJoinGameSuccess", "onServerError", "onShuffleStackReceived", "onUserJoined", "sender", "onUserLeft", "refreshAdvanceOnlinePlayer", "refreshAll", "refreshCardDrawn", "card", "Ltools/aqua/bgw/examples/maumau/entity/MauMauCard;", "isCurrentPlayer", "", "refreshCardPlayed", "animated", "refreshEndGame", "playerWon", "refreshEndTurn", "refreshGameStackShuffledBack", "refreshHands", "refreshHintDrawCard", "refreshHintPlayCard", "refreshPlayAgain", "refreshSuitSelected", "refreshSwapPlayers", "showConnectWarningDialog", "title", "showJackEffectSelection", "visible", "addInteraction", "Ltools/aqua/bgw/components/gamecomponentviews/CardView;", "addSneakInteraction", "removeInteraction", "removeSneakInteraction", "bgw-maumau-example"})
public final class RefreshViewController
implements Refreshable {
    @NotNull
    private final MauMauViewController viewController;
    @NotNull
    private final BufferedImage image;
    @Nullable
    private ColorVisual hintOverlay;

    public RefreshViewController(@NotNull MauMauViewController viewController) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewController), (String)"viewController");
        this.viewController = viewController;
        BufferedImage bufferedImage = ImageIO.read(this.getClass().getClassLoader().getResource("assets/card_deck.png"));
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"read(this::class.java.cl\u2026.getResource(CARDS_FILE))");
        this.image = bufferedImage;
    }

    @Override
    public void refreshCardDrawn(@NotNull MauMauCard card, boolean isCurrentPlayer) {
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        LinearLayout<CardView> playerHandView = isCurrentPlayer ? this.viewController.getMauMauGameScene().getCurrentPlayerHand() : this.viewController.getMauMauGameScene().getOtherPlayerHand();
        CardView cardView = (CardView)this.viewController.getCardMap().forward((Object)card);
        this.viewController.getMauMauGameScene().getDrawStack().remove((GameComponentView)cardView);
        GameComponentContainer.add$default((GameComponentContainer)((GameComponentContainer)playerHandView), (GameComponentView)((GameComponentView)cardView), (int)0, (int)2, null);
        if (isCurrentPlayer) {
            cardView.showFront();
        }
        this.viewController.getMauMauGameScene().getDrawStackInfo().getTextProperty().setValue((Object)String.valueOf(this.viewController.getLogicController().getGame().getDrawStack().size()));
        if (isCurrentPlayer) {
            this.addInteraction(cardView);
        } else {
            this.addSneakInteraction(cardView);
        }
        this.showJackEffectSelection(false);
        ColorVisual colorVisual = this.hintOverlay;
        if (colorVisual != null) {
            colorVisual.setTransparency(0.0);
        }
    }

    @Override
    public void refreshCardPlayed(@NotNull MauMauCard card, boolean animated, boolean isCurrentPlayer) {
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        CardView cardView = (CardView)this.viewController.getCardMap().forward((Object)card);
        LinearLayout<CardView> hand = isCurrentPlayer ? this.viewController.getMauMauGameScene().getCurrentPlayerHand() : this.viewController.getMauMauGameScene().getOtherPlayerHand();
        this.removeInteraction(cardView);
        cardView.showFront();
        this.showJackEffectSelection(false);
        if (animated) {
            MovementAnimation anim = MovementAnimation.Companion.toComponentView((ComponentView)cardView, (ComponentView)this.viewController.getMauMauGameScene().getGameStack(), (Scene)this.viewController.getMauMauGameScene(), 500);
            anim.setOnFinished((Function1)new Function1<AnimationFinishedEvent, Unit>(hand, cardView, this){
                final /* synthetic */ LinearLayout<CardView> $hand;
                final /* synthetic */ CardView $cardView;
                final /* synthetic */ RefreshViewController this$0;
                {
                    this.$hand = $hand;
                    this.$cardView = $cardView;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull AnimationFinishedEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$hand.remove((GameComponentView)this.$cardView);
                    GameComponentContainer.add$default((GameComponentContainer)((GameComponentContainer)RefreshViewController.access$getViewController$p(this.this$0).getMauMauGameScene().getGameStack()), (GameComponentView)((GameComponentView)this.$cardView), (int)0, (int)2, null);
                    this.$cardView.setPosX(0.0);
                    this.$cardView.setPosY(0.0);
                    RefreshViewController.access$getViewController$p(this.this$0).getMauMauGameScene().getGameStackInfo().getTextProperty().setValue((Object)RefreshViewController.access$getViewController$p(this.this$0).getLogicController().getGame().getGameStack().getCards().peek().getCardSuit().toString());
                }
            });
            this.viewController.getMauMauGameScene().lock();
            this.viewController.getMauMauGameScene().playAnimation((Animation)anim);
        } else {
            hand.remove((GameComponentView)cardView);
            this.viewController.getMauMauGameScene().getGameStack().push(cardView);
            cardView.setPosX(0.0);
            cardView.setPosY(0.0);
            this.viewController.getMauMauGameScene().getGameStackInfo().getTextProperty().setValue((Object)this.viewController.getLogicController().getGame().getGameStack().getCards().peek().getCardSuit().toString());
        }
        ColorVisual colorVisual = this.hintOverlay;
        if (colorVisual != null) {
            colorVisual.setTransparency(0.0);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void refreshGameStackShuffledBack() {
        void $this$onEach$iv;
        void var3_5;
        CardView it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object object;
        CardStack<CardView> $this$refreshGameStackShuffledBack_u24lambda_u2d0 = object = this.viewController.getMauMauGameScene().getGameStack();
        boolean $i$a$-apply-RefreshViewController$refreshGameStackShuffledBack$22 = false;
        CardView saved = $this$refreshGameStackShuffledBack_u24lambda_u2d0.pop();
        $this$refreshGameStackShuffledBack_u24lambda_u2d0.clear();
        $this$refreshGameStackShuffledBack_u24lambda_u2d0.push(saved);
        object = this.viewController.getLogicController().getGame().getDrawStack().getCards();
        CardStack<CardView> cardStack = this.viewController.getMauMauGameScene().getDrawStack();
        boolean $i$f$map = false;
        void $i$a$-apply-RefreshViewController$refreshGameStackShuffledBack$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MauMauCard mauMauCard = (MauMauCard)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            BidirectionalMap<MauMauCard, CardView> bidirectionalMap = this.viewController.getCardMap();
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add((CardView)bidirectionalMap.forward((Object)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$onEach = false;
        void $this$onEach_u24lambda_u2d16$iv = var3_5 = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2d16$iv) {
            it = (CardView)element$iv;
            boolean bl2 = false;
            this.removeInteraction(it);
            it.showBack();
        }
        cardStack.addAll((Collection)var3_5);
    }

    @Override
    public void refreshPlayAgain() {
        this.viewController.getMauMauGameScene().unlock();
    }

    @Override
    public void showJackEffectSelection() {
        this.showJackEffectSelection(true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void refreshHintDrawCard() {
        void $this$refreshHintDrawCard_u24lambda_u2d3;
        ColorVisual colorVisual;
        ColorVisual colorVisual2 = colorVisual = (ColorVisual)CollectionsKt.last((List)((CompoundVisual)((CardView)CollectionsKt.last((List)this.viewController.getMauMauGameScene().getDrawStack().getComponents())).getVisual()).getChildren());
        RefreshViewController refreshViewController = this;
        boolean bl = false;
        Color color = Color.YELLOW;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"YELLOW");
        $this$refreshHintDrawCard_u24lambda_u2d3.setColor(color);
        $this$refreshHintDrawCard_u24lambda_u2d3.setTransparency(0.5);
        refreshViewController.hintOverlay = colorVisual;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void refreshHintPlayCard(@NotNull MauMauCard card) {
        void $this$refreshHintPlayCard_u24lambda_u2d4;
        ColorVisual colorVisual;
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        ColorVisual colorVisual2 = colorVisual = (ColorVisual)CollectionsKt.last((List)((CompoundVisual)((CardView)this.viewController.getCardMap().forward((Object)card)).getVisual()).getChildren());
        RefreshViewController refreshViewController = this;
        boolean bl = false;
        Color color = Color.YELLOW;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"YELLOW");
        $this$refreshHintPlayCard_u24lambda_u2d4.setColor(color);
        $this$refreshHintPlayCard_u24lambda_u2d4.setTransparency(0.5);
        refreshViewController.hintOverlay = colorVisual;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void refreshEndGame(@NotNull String playerWon) {
        void $this$refreshEndGame_u24lambda_u2d5;
        MauMauPlayerWonScene mauMauPlayerWonScene;
        Intrinsics.checkNotNullParameter((Object)playerWon, (String)"playerWon");
        MauMauPlayerWonScene mauMauPlayerWonScene2 = mauMauPlayerWonScene = this.viewController.getMauMauPlayerWonMenuScene();
        MauMauViewController mauMauViewController = this.viewController;
        boolean bl = false;
        $this$refreshEndGame_u24lambda_u2d5.setPlayerWon(playerWon);
        mauMauViewController.showMenuScene(mauMauPlayerWonScene, 2000);
    }

    @Override
    public void refreshAdvanceOnlinePlayer() {
        this.viewController.getMauMauGameScene().lock();
    }

    @Override
    public void refreshSwapPlayers() {
        DelayAnimation delayAnimation;
        this.viewController.getMauMauGameScene().lock();
        DelayAnimation $this$refreshSwapPlayers_u24lambda_u2d6 = delayAnimation = new DelayAnimation(1000);
        boolean bl = false;
        $this$refreshSwapPlayers_u24lambda_u2d6.setOnFinished((Function1)new Function1<AnimationFinishedEvent, Unit>(this){
            final /* synthetic */ RefreshViewController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull AnimationFinishedEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                RefreshViewController.access$refreshHands(this.this$0);
                RefreshViewController.access$getViewController$p(this.this$0).getMauMauGameScene().unlock();
            }
        });
        DelayAnimation delay2 = delayAnimation;
        this.viewController.getMauMauGameScene().lock();
        this.viewController.getMauMauGameScene().playAnimation((Animation)delay2);
    }

    @Override
    public void refreshSuitSelected() {
        this.viewController.getMauMauGameScene().getGameStackInfo().setText(this.viewController.getLogicController().getGame().getNextSuit().toString());
        this.showJackEffectSelection(false);
    }

    @Override
    public void refreshAll() {
        Object object;
        MauMauCard card;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        ImageVisual cardFront;
        MauMauGame game = this.viewController.getLogicController().getGame();
        ImageVisual cardBack = new ImageVisual(this.image, 130, 200, 260, 800);
        this.viewController.getCardMap().clear();
        for (MauMauCard card2 : game.getMauMauCards()) {
            cardFront = new ImageVisual(this.image, 130, 200, card2.getCardValue().ordinal() * 130, card2.getCardSuit().ordinal() * 200);
            Object object2 = new SingleLayerVisual[]{(SingleLayerVisual)cardFront, (SingleLayerVisual)ColorVisual.Companion.getTRANSPARENT()};
            CompoundVisual compoundVisual = new CompoundVisual((SingleLayerVisual[])object2);
            SingleLayerVisual[] singleLayerVisualArray = new SingleLayerVisual[]{(SingleLayerVisual)cardBack, (SingleLayerVisual)ColorVisual.Companion.getTRANSPARENT()};
            object2 = new CompoundVisual(singleLayerVisualArray);
            CompoundVisual $this$refreshAll_u24lambda_u2d7 = compoundVisual = new CardView(null, null, (Number)130, (Number)200, (Visual)compoundVisual, (Visual)object2, 3, null);
            boolean bl = false;
            $this$refreshAll_u24lambda_u2d7.setName(card2.toString());
            CompoundVisual cardView = compoundVisual;
            this.viewController.getCardMap().add((Object)card2, (Object)cardView);
        }
        this.viewController.getMauMauGameScene().getDrawStack().clear();
        Iterable iterable = CollectionsKt.asReversedMutable((List)game.getDrawStack().getCards());
        CardStack<CardView> cardStack = this.viewController.getMauMauGameScene().getDrawStack();
        boolean $i$f$map = false;
        cardFront = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MauMauCard mauMauCard = (MauMauCard)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            BidirectionalMap<MauMauCard, CardView> bidirectionalMap = this.viewController.getCardMap();
            Intrinsics.checkNotNullExpressionValue((Object)card, (String)"card");
            object = bidirectionalMap.forward((Object)card);
            CardView $this$refreshAll_u24lambda_u2d9_u24lambda_u2d8 = (CardView)object;
            boolean bl2 = false;
            $this$refreshAll_u24lambda_u2d9_u24lambda_u2d8.showBack();
            collection.add((CardView)object);
        }
        cardStack.addAll((Collection)((List)destination$iv$iv));
        this.viewController.getMauMauGameScene().getGameStack().clear();
        $this$map$iv = CollectionsKt.asReversedMutable((List)game.getGameStack().getCards());
        cardStack = this.viewController.getMauMauGameScene().getGameStack();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            card = (MauMauCard)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            BidirectionalMap<MauMauCard, CardView> bidirectionalMap = this.viewController.getCardMap();
            Intrinsics.checkNotNullExpressionValue((Object)card, (String)"card");
            object = bidirectionalMap.forward((Object)card);
            CardView $this$refreshAll_u24lambda_u2d11_u24lambda_u2d10 = (CardView)object;
            boolean bl3 = false;
            $this$refreshAll_u24lambda_u2d11_u24lambda_u2d10.showFront();
            collection.add((CardView)object);
        }
        cardStack.addAll((Collection)((List)destination$iv$iv));
        this.viewController.getMauMauGameScene().getDrawStackInfo().getTextProperty().setValue((Object)String.valueOf(this.viewController.getLogicController().getGame().getDrawStack().size()));
        this.viewController.getMauMauGameScene().getGameStackInfo().getTextProperty().setValue((Object)this.viewController.getLogicController().getGame().getGameStack().getCards().peek().getCardSuit().toString());
        this.refreshHands();
        this.showJackEffectSelection(false);
    }

    /*
     * WARNING - void declaration
     */
    private final void refreshHands() {
        CardView $this$refreshHands_u24lambda_u2d12;
        GameComponentContainer gameComponentContainer;
        Iterator iterator;
        int i;
        MauMauGame game = this.viewController.getLogicController().getGame();
        this.viewController.getMauMauGameScene().getCurrentPlayerHand().clear();
        this.viewController.getMauMauGameScene().getOtherPlayerHand().clear();
        int n = game.getPlayers().get(0).getHand().getCards().size();
        for (i = 0; i < n; ++i) {
            GameComponentContainer gameComponentContainer2 = (GameComponentContainer)this.viewController.getMauMauGameScene().getCurrentPlayerHand();
            BidirectionalMap<MauMauCard, CardView> bidirectionalMap = this.viewController.getCardMap();
            MauMauCard mauMauCard = game.getPlayers().get(0).getHand().getCards().get(i);
            Intrinsics.checkNotNullExpressionValue((Object)mauMauCard, (String)"game.players[0].hand.cards[i]");
            iterator = bidirectionalMap.forward((Object)mauMauCard);
            CardView cardView = (CardView)iterator;
            gameComponentContainer = gameComponentContainer2;
            boolean bl = false;
            $this$refreshHands_u24lambda_u2d12.showFront();
            GameComponentContainer.add$default((GameComponentContainer)gameComponentContainer, (GameComponentView)((GameComponentView)iterator), (int)0, (int)2, null);
        }
        n = game.getPlayers().get(1).getHand().getCards().size();
        for (i = 0; i < n; ++i) {
            void $this$refreshHands_u24lambda_u2d13;
            GameComponentContainer gameComponentContainer3 = (GameComponentContainer)this.viewController.getMauMauGameScene().getOtherPlayerHand();
            BidirectionalMap<MauMauCard, CardView> bidirectionalMap = this.viewController.getCardMap();
            MauMauCard mauMauCard = game.getPlayers().get(1).getHand().getCards().get(i);
            Intrinsics.checkNotNullExpressionValue((Object)mauMauCard, (String)"game.players[1].hand.cards[i]");
            iterator = bidirectionalMap.forward((Object)mauMauCard);
            $this$refreshHands_u24lambda_u2d12 = (CardView)iterator;
            gameComponentContainer = gameComponentContainer3;
            boolean bl = false;
            $this$refreshHands_u24lambda_u2d13.showBack();
            GameComponentContainer.add$default((GameComponentContainer)gameComponentContainer, (GameComponentView)((GameComponentView)iterator), (int)0, (int)2, null);
        }
        Iterable $this$forEach$iv = this.viewController.getMauMauGameScene().getCurrentPlayerHand().getComponents();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CardView it = (CardView)element$iv;
            boolean bl = false;
            this.addInteraction(it);
            this.removeSneakInteraction(it);
        }
        $this$forEach$iv = this.viewController.getMauMauGameScene().getOtherPlayerHand().getComponents();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CardView it = (CardView)element$iv;
            boolean bl = false;
            this.removeInteraction(it);
            this.addSneakInteraction(it);
        }
    }

    @Override
    public void showConnectWarningDialog(@NotNull String title, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.viewController.showDialog(new Dialog(DialogType.WARNING, title, title, message, new ButtonType[0]));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onCreateGameSuccess(@Nullable String sessionID) {
        void it;
        MauMauWaitForOpponentMenuScene mauMauWaitForOpponentMenuScene;
        this.viewController.showDialogNonBlocking(new Dialog(DialogType.INFORMATION, "Session ID", "Session ID", "Session ID is " + sessionID, new ButtonType[0]));
        MauMauWaitForOpponentMenuScene mauMauWaitForOpponentMenuScene2 = mauMauWaitForOpponentMenuScene = this.viewController.getMauMauWaitForOpponentMenuScene();
        BoardGameApplication boardGameApplication = this.viewController;
        boolean bl = false;
        it.startAnimation();
        BoardGameApplication.showMenuScene$default((BoardGameApplication)boardGameApplication, (MenuScene)mauMauWaitForOpponentMenuScene, null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onJoinGameSuccess() {
        void it;
        MauMauWaitForOpponentMenuScene mauMauWaitForOpponentMenuScene;
        MauMauWaitForOpponentMenuScene mauMauWaitForOpponentMenuScene2 = mauMauWaitForOpponentMenuScene = this.viewController.getMauMauWaitForOpponentMenuScene();
        BoardGameApplication boardGameApplication = this.viewController;
        boolean bl = false;
        it.startAnimation();
        BoardGameApplication.showMenuScene$default((BoardGameApplication)boardGameApplication, (MenuScene)mauMauWaitForOpponentMenuScene, null, (int)2, null);
    }

    @Override
    public void onCreateGameError(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.viewController.showDialog(new Dialog(DialogType.ERROR, "Error creating game", "Error creating game", message, new ButtonType[0]));
    }

    @Override
    public void onJoinGameError(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.viewController.showDialog(new Dialog(DialogType.ERROR, "Error joining game", "Error joining game", message, new ButtonType[0]));
    }

    @Override
    public void onInitializeGameReceived() {
        MauMauViewController mauMauViewController;
        MauMauViewController $this$onInitializeGameReceived_u24lambda_u2d18 = mauMauViewController = this.viewController;
        boolean bl = false;
        $this$onInitializeGameReceived_u24lambda_u2d18.getMauMauGameScene().startAnimation();
        $this$onInitializeGameReceived_u24lambda_u2d18.getMauMauGameScene().lock();
        BoardGameApplication.hideMenuScene$default((BoardGameApplication)$this$onInitializeGameReceived_u24lambda_u2d18, null, (int)1, null);
    }

    @Override
    public void onShuffleStackReceived() {
        Object object;
        MauMauCard card;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        MauMauViewController mauMauViewController;
        MauMauViewController $this$onShuffleStackReceived_u24lambda_u2d23 = mauMauViewController = this.viewController;
        boolean bl = false;
        $this$onShuffleStackReceived_u24lambda_u2d23.getMauMauGameScene().getDrawStack().clear();
        Iterable iterable = CollectionsKt.asReversedMutable((List)$this$onShuffleStackReceived_u24lambda_u2d23.getLogicController().getGame().getDrawStack().getCards());
        CardStack<CardView> cardStack = $this$onShuffleStackReceived_u24lambda_u2d23.getMauMauGameScene().getDrawStack();
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MauMauCard mauMauCard = (MauMauCard)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            BidirectionalMap<MauMauCard, CardView> bidirectionalMap = $this$onShuffleStackReceived_u24lambda_u2d23.getCardMap();
            Intrinsics.checkNotNullExpressionValue((Object)card, (String)"card");
            object = bidirectionalMap.forward((Object)card);
            CardView $this$onShuffleStackReceived_u24lambda_u2d23_u24lambda_u2d20_u24lambda_u2d19 = (CardView)object;
            boolean bl3 = false;
            $this$onShuffleStackReceived_u24lambda_u2d23_u24lambda_u2d20_u24lambda_u2d19.showBack();
            collection.add((CardView)object);
        }
        cardStack.addAll((Collection)((List)destination$iv$iv));
        $this$onShuffleStackReceived_u24lambda_u2d23.getMauMauGameScene().getGameStack().clear();
        $this$map$iv = CollectionsKt.asReversedMutable((List)$this$onShuffleStackReceived_u24lambda_u2d23.getLogicController().getGame().getGameStack().getCards());
        cardStack = $this$onShuffleStackReceived_u24lambda_u2d23.getMauMauGameScene().getGameStack();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            card = (MauMauCard)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            BidirectionalMap<MauMauCard, CardView> bidirectionalMap = $this$onShuffleStackReceived_u24lambda_u2d23.getCardMap();
            Intrinsics.checkNotNullExpressionValue((Object)card, (String)"card");
            object = bidirectionalMap.forward((Object)card);
            CardView $this$onShuffleStackReceived_u24lambda_u2d23_u24lambda_u2d22_u24lambda_u2d21 = (CardView)object;
            boolean bl5 = false;
            $this$onShuffleStackReceived_u24lambda_u2d23_u24lambda_u2d22_u24lambda_u2d21.showFront();
            collection.add((CardView)object);
        }
        cardStack.addAll((Collection)((List)destination$iv$iv));
        $this$onShuffleStackReceived_u24lambda_u2d23.getMauMauGameScene().getDrawStackInfo().getTextProperty().setValue((Object)String.valueOf($this$onShuffleStackReceived_u24lambda_u2d23.getLogicController().getGame().getDrawStack().size()));
        $this$onShuffleStackReceived_u24lambda_u2d23.getMauMauGameScene().getGameStackInfo().getTextProperty().setValue((Object)$this$onShuffleStackReceived_u24lambda_u2d23.getLogicController().getGame().getGameStack().getCards().peek().getCardSuit().toString());
    }

    @Override
    public void refreshEndTurn() {
        this.viewController.getMauMauGameScene().unlock();
    }

    @Override
    public void onUserJoined(@NotNull String sender) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        this.viewController.getMauMauWaitForOpponentMenuScene().onOpponentConnected(sender);
    }

    @Override
    public void onUserLeft(@NotNull String sender) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        System.out.println((Object)(sender + " left."));
    }

    @Override
    public void onServerError() {
        throw new IllegalStateException("Server error".toString());
    }

    private final void addInteraction(CardView $this$addInteraction) {
        $this$addInteraction.setDraggable(true);
        Ref.ObjectRef overlay = new Ref.ObjectRef();
        $this$addInteraction.setOnDragGestureStarted((Function1)new Function1<DragEvent, Unit>((Ref.ObjectRef<ColorVisual>)overlay, this, $this$addInteraction){
            final /* synthetic */ Ref.ObjectRef<ColorVisual> $overlay;
            final /* synthetic */ RefreshViewController this$0;
            final /* synthetic */ CardView $this_addInteraction;
            {
                this.$overlay = $overlay;
                this.this$0 = $receiver;
                this.$this_addInteraction = $receiver2;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull DragEvent it) {
                void $this$invoke_u24lambda_u2d0;
                Color color;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ColorVisual colorVisual = (ColorVisual)CollectionsKt.last((List)((CompoundVisual)((CardView)CollectionsKt.last((List)RefreshViewController.access$getViewController$p(this.this$0).getMauMauGameScene().getGameStack().getComponents())).getVisual()).getChildren());
                RefreshViewController refreshViewController = this.this$0;
                CardView cardView = this.$this_addInteraction;
                ColorVisual colorVisual2 = colorVisual;
                Ref.ObjectRef<ColorVisual> objectRef = this.$overlay;
                boolean bl = false;
                if (RefreshViewController.access$getViewController$p(refreshViewController).getLogicController().checkRules((MauMauCard)RefreshViewController.access$getViewController$p(refreshViewController).getCardMap().backward((Object)cardView))) {
                    Color color2 = Color.GREEN;
                    color = color2;
                    Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"GREEN");
                } else {
                    Color color3 = Color.RED;
                    color = color3;
                    Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"RED");
                }
                $this$invoke_u24lambda_u2d0.setColor(color);
                $this$invoke_u24lambda_u2d0.setTransparency(0.5);
                objectRef.element = colorVisual;
            }
        });
        $this$addInteraction.setOnDragGestureEnded((Function2)new Function2<DropEvent, Boolean, Unit>((Ref.ObjectRef<ColorVisual>)overlay){
            final /* synthetic */ Ref.ObjectRef<ColorVisual> $overlay;
            {
                this.$overlay = $overlay;
                super(2);
            }

            public final void invoke(@NotNull DropEvent dropEvent, boolean bl) {
                Intrinsics.checkNotNullParameter((Object)dropEvent, (String)"<anonymous parameter 0>");
                ColorVisual colorVisual = (ColorVisual)this.$overlay.element;
                if (colorVisual != null) {
                    colorVisual.setTransparency(0.0);
                }
            }
        });
        $this$addInteraction.setOnMouseClicked((Function1)new Function1<MouseEvent, Unit>(this, $this$addInteraction){
            final /* synthetic */ RefreshViewController this$0;
            final /* synthetic */ CardView $this_addInteraction;
            {
                this.this$0 = $receiver;
                this.$this_addInteraction = $receiver2;
                super(1);
            }

            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                RefreshViewController.access$getViewController$p(this.this$0).getLogicController().playCard((MauMauCard)RefreshViewController.access$getViewController$p(this.this$0).getCardMap().backward((Object)this.$this_addInteraction), true, true);
            }
        });
    }

    private final void removeInteraction(CardView $this$removeInteraction) {
        $this$removeInteraction.setDraggable(false);
        $this$removeInteraction.setOnMouseClicked(null);
        $this$removeInteraction.setOnMouseEntered(null);
        $this$removeInteraction.setOnMouseExited(null);
    }

    private final void addSneakInteraction(CardView $this$addSneakInteraction) {
        $this$addSneakInteraction.setOnMouseEntered((Function1)new Function1<MouseEvent, Unit>(this, $this$addSneakInteraction){
            final /* synthetic */ RefreshViewController this$0;
            final /* synthetic */ CardView $this_addSneakInteraction;
            {
                this.this$0 = $receiver;
                this.$this_addSneakInteraction = $receiver2;
                super(1);
            }

            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                RefreshViewController.access$getViewController$p(this.this$0).getMauMauGameScene().playAnimation((Animation)new FlipAnimation((ComponentView)this.$this_addSneakInteraction, this.$this_addSneakInteraction.getBackVisual(), this.$this_addSneakInteraction.getFrontVisual(), 0, 8, null));
            }
        });
        $this$addSneakInteraction.setOnMouseExited((Function1)new Function1<MouseEvent, Unit>(this, $this$addSneakInteraction){
            final /* synthetic */ RefreshViewController this$0;
            final /* synthetic */ CardView $this_addSneakInteraction;
            {
                this.this$0 = $receiver;
                this.$this_addSneakInteraction = $receiver2;
                super(1);
            }

            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                RefreshViewController.access$getViewController$p(this.this$0).getMauMauGameScene().playAnimation((Animation)new FlipAnimation((ComponentView)this.$this_addSneakInteraction, this.$this_addSneakInteraction.getFrontVisual(), this.$this_addSneakInteraction.getBackVisual(), 0, 8, null));
            }
        });
    }

    private final void removeSneakInteraction(CardView $this$removeSneakInteraction) {
        $this$removeSneakInteraction.setOnMouseEntered(null);
        $this$removeSneakInteraction.setOnMouseExited(null);
    }

    private final void showJackEffectSelection(boolean visible) {
        this.viewController.getMauMauGameScene().getButtonDiamonds().setVisible(visible);
        this.viewController.getMauMauGameScene().getButtonHearts().setVisible(visible);
        this.viewController.getMauMauGameScene().getButtonSpades().setVisible(visible);
        this.viewController.getMauMauGameScene().getButtonClubs().setVisible(visible);
    }

    public static final /* synthetic */ MauMauViewController access$getViewController$p(RefreshViewController $this) {
        return $this.viewController;
    }

    public static final /* synthetic */ void access$refreshHands(RefreshViewController $this) {
        $this.refreshHands();
    }
}

