/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.builder.components;

import java.io.FileNotFoundException;
import java.net.URL;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.aqua.bgw.components.layoutviews.CameraPane;
import tools.aqua.bgw.components.layoutviews.LayoutView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010;\u001a\u00020:2\u0006\u0010<\u001a\u00020:H\u0002J\b\u0010=\u001a\u00020\u000fH\u0002J\b\u0010>\u001a\u00020\u000fH\u0002J\u0010\u0010?\u001a\u00020\u000f2\u0006\u0010@\u001a\u00020\tH\u0002J\u0018\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\u00152\u0006\u0010D\u001a\u00020\tH\u0002J\u0010\u0010E\u001a\u00020:2\u0006\u0010<\u001a\u00020:H\u0002J\u0006\u0010F\u001a\u00020BJ\u0016\u0010G\u001a\u00020B2\u0006\u0010H\u001a\u00020\u00152\u0006\u0010I\u001a\u00020\u0015J\u000e\u0010J\u001a\u00020B2\u0006\u0010@\u001a\u00020\tJ\u000e\u0010K\u001a\u00020B2\u0006\u0010@\u001a\u00020\tR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0011\"\u0004\b\u001c\u0010\u0013R\u000e\u0010\u001d\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R$\u0010%\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u0015@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0017\"\u0004\b'\u0010\u0019R\u001a\u0010(\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0011\"\u0004\b*\u0010\u0013R\u001a\u0010+\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0011\"\u0004\b-\u0010\u0013R\u000e\u0010.\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00102\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u0011\"\u0004\b4\u0010\u0013R\u001a\u00105\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0017\"\u0004\b7\u0010\u0019R\u000e\u00108\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Ltools/aqua/bgw/builder/components/ZoomableScrollPane;", "Ljavafx/scene/control/ScrollPane;", "target", "Ljavafx/scene/layout/Pane;", "cameraPane", "Ltools/aqua/bgw/components/layoutviews/CameraPane;", "Ltools/aqua/bgw/components/layoutviews/LayoutView;", "(Ljavafx/scene/layout/Pane;Ltools/aqua/bgw/components/layoutviews/CameraPane;)V", "anchorPoint", "Ljavafx/geometry/Point2D;", "getAnchorPoint", "()Ljavafx/geometry/Point2D;", "setAnchorPoint", "(Ljavafx/geometry/Point2D;)V", "hPanLocked", "", "getHPanLocked", "()Z", "setHPanLocked", "(Z)V", "hValueLocked", "", "getHValueLocked", "()D", "setHValueLocked", "(D)V", "interactive", "getInteractive", "setInteractive", "lerpTime", "panMouseButton", "Ljavafx/scene/input/MouseButton;", "getPanMouseButton", "()Ljavafx/scene/input/MouseButton;", "setPanMouseButton", "(Ljavafx/scene/input/MouseButton;)V", "value", "scaleValue", "getScaleValue", "setScaleValue", "scrollLocked", "getScrollLocked", "setScrollLocked", "smooth", "getSmooth", "setSmooth", "startX", "startY", "timeline", "Ljavafx/animation/Timeline;", "vPanLocked", "getVPanLocked", "setVPanLocked", "vValueLocked", "getVValueLocked", "setVValueLocked", "zoomIntensity", "zoomNode", "Ljavafx/scene/Node;", "centeredNode", "node", "inFullHorizontalView", "inFullVerticalView", "inTargetBounds", "point", "onScroll", "", "wheelDelta", "mousePoint", "outerNode", "reset", "scrollBy", "xOffset", "yOffset", "scrollTo", "smoothScrollTo", "bgw-gui"})
public final class ZoomableScrollPane
extends ScrollPane {
    @NotNull
    private final Pane target;
    @NotNull
    private final CameraPane<? extends LayoutView<?>> cameraPane;
    private double scaleValue;
    private final double zoomIntensity;
    @NotNull
    private final Node zoomNode;
    @Nullable
    private Timeline timeline;
    private double lerpTime;
    @NotNull
    private Point2D anchorPoint;
    private boolean smooth;
    private double startX;
    private double startY;
    @NotNull
    private MouseButton panMouseButton;
    private double hValueLocked;
    private double vValueLocked;
    private boolean hPanLocked;
    private boolean vPanLocked;
    private boolean scrollLocked;
    private boolean interactive;

    public ZoomableScrollPane(@NotNull Pane target, @NotNull CameraPane<? extends LayoutView<?>> cameraPane) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(cameraPane, (String)"cameraPane");
        this.target = target;
        this.cameraPane = cameraPane;
        this.scaleValue = 1.0;
        this.zoomIntensity = 0.02;
        this.anchorPoint = new Point2D(0.0, 0.0);
        URL uRL = ((Object)((Object)this)).getClass().getResource("/style.css");
        if (uRL == null) {
            throw new FileNotFoundException();
        }
        URL resource = uRL;
        this.getStylesheets().add((Object)resource.toExternalForm());
        this.setBackground(Background.fill((Paint)((Paint)Color.TRANSPARENT)));
        Node[] nodeArray = new Node[]{(Node)this.target};
        this.zoomNode = (Node)new Group(nodeArray);
        this.setContent(this.outerNode(this.zoomNode));
        this.setPannable(false);
        this.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.hvalueProperty().addListener((arg_0, arg_1, arg_2) -> ZoomableScrollPane._init_$lambda-0(this, arg_0, arg_1, arg_2));
        this.vvalueProperty().addListener((arg_0, arg_1, arg_2) -> ZoomableScrollPane._init_$lambda-1(this, arg_0, arg_1, arg_2));
        this.panMouseButton = MouseButton.MIDDLE;
    }

    public final double getScaleValue() {
        return this.scaleValue;
    }

    public final void setScaleValue(double value) {
        this.scaleValue = RangesKt.coerceIn((double)value, (double)0.01, (double)10.0);
        this.target.setScaleX(this.scaleValue);
        this.target.setScaleY(this.scaleValue);
        this.cameraPane.getZoomProperty().setSilent$bgw_gui(this.scaleValue);
    }

    @NotNull
    public final Point2D getAnchorPoint() {
        return this.anchorPoint;
    }

    public final void setAnchorPoint(@NotNull Point2D point2D) {
        Intrinsics.checkNotNullParameter((Object)point2D, (String)"<set-?>");
        this.anchorPoint = point2D;
    }

    public final boolean getSmooth() {
        return this.smooth;
    }

    public final void setSmooth(boolean bl) {
        this.smooth = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean inTargetBounds(Point2D point) {
        double d = this.cameraPane.getTarget$bgw_gui().getWidth();
        double d2 = point.getX();
        if (!(0.0 <= d2)) return false;
        if (!(d2 <= d)) return false;
        boolean bl = true;
        if (!bl) return false;
        d = this.cameraPane.getTarget$bgw_gui().getHeight();
        d2 = point.getY();
        if (!(0.0 <= d2)) return false;
        if (!(d2 <= d)) return false;
        return true;
    }

    private final boolean inFullHorizontalView() {
        return this.cameraPane.getTarget$bgw_gui().getWidth() == this.cameraPane.getWidth();
    }

    private final boolean inFullVerticalView() {
        return this.cameraPane.getTarget$bgw_gui().getHeight() == this.cameraPane.getHeight();
    }

    public final void scrollTo(@NotNull Point2D point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        if (this.inTargetBounds(point)) {
            this.anchorPoint = point;
            double viewWidth = this.cameraPane.getWidth() / this.cameraPane.getZoom();
            double viewHeight = this.cameraPane.getHeight() / this.cameraPane.getZoom();
            this.setHvalue(point.getX() / (this.cameraPane.getTarget$bgw_gui().getWidth() - viewWidth));
            this.setVvalue(point.getY() / (this.cameraPane.getTarget$bgw_gui().getHeight() - viewHeight));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void smoothScrollTo(@NotNull Point2D point) {
        block2: {
            void $this$smoothScrollTo_u24lambda_u2d3;
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            if (!this.inTargetBounds(point)) break block2;
            double viewWidth = this.cameraPane.getWidth() / this.cameraPane.getZoom();
            double viewHeight = this.cameraPane.getHeight() / this.cameraPane.getZoom();
            double newHValue = point.getX() / (this.cameraPane.getTarget$bgw_gui().getWidth() - viewWidth);
            double newVValue = point.getY() / (this.cameraPane.getTarget$bgw_gui().getHeight() - viewHeight);
            double clampedHValue = RangesKt.coerceIn((double)newHValue, (double)0.0, (double)1.0);
            double clampedVValue = RangesKt.coerceIn((double)newVValue, (double)0.0, (double)1.0);
            Timeline timeline = this.timeline;
            if ((timeline != null ? timeline.getStatus() : null) == Animation.Status.RUNNING) {
                return;
            }
            Timeline timeline2 = new Timeline[]{new KeyFrame(Duration.millis((double)10.0), arg_0 -> ZoomableScrollPane.smoothScrollTo$lambda-2(this, clampedHValue, clampedVValue, arg_0), new KeyValue[0])};
            Timeline timeline3 = timeline2 = new Timeline((KeyFrame[])timeline2);
            ZoomableScrollPane zoomableScrollPane = this;
            boolean bl = false;
            $this$smoothScrollTo_u24lambda_u2d3.setCycleCount(-1);
            zoomableScrollPane.timeline = timeline2;
            Timeline timeline4 = this.timeline;
            if (timeline4 != null) {
                timeline4.play();
            }
        }
    }

    public final void scrollBy(double xOffset, double yOffset) {
        Point2D point2D = this.anchorPoint.add(xOffset, yOffset);
        Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"anchorPoint.add(xOffset, yOffset)");
        if (this.inTargetBounds(point2D)) {
            Point2D point2D2 = this.anchorPoint.add(xOffset, yOffset);
            Intrinsics.checkNotNullExpressionValue((Object)point2D2, (String)"anchorPoint.add(xOffset, yOffset)");
            this.anchorPoint = point2D2;
            this.scrollTo(this.anchorPoint);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void reset() {
        block1: {
            void $this$reset_u24lambda_u2d5;
            Timeline timeline = this.timeline;
            if ((timeline != null ? timeline.getStatus() : null) == Animation.Status.RUNNING) {
                return;
            }
            Timeline timeline2 = new Timeline[]{new KeyFrame(Duration.millis((double)10.0), arg_0 -> ZoomableScrollPane.reset$lambda-4(this, arg_0), new KeyValue[0])};
            Timeline timeline3 = timeline2 = new Timeline((KeyFrame[])timeline2);
            ZoomableScrollPane zoomableScrollPane = this;
            boolean bl = false;
            $this$reset_u24lambda_u2d5.setCycleCount(-1);
            zoomableScrollPane.timeline = timeline2;
            Timeline timeline4 = this.timeline;
            if (timeline4 == null) break block1;
            timeline4.play();
        }
    }

    @NotNull
    public final MouseButton getPanMouseButton() {
        return this.panMouseButton;
    }

    public final void setPanMouseButton(@NotNull MouseButton mouseButton) {
        Intrinsics.checkNotNullParameter((Object)mouseButton, (String)"<set-?>");
        this.panMouseButton = mouseButton;
    }

    public final double getHValueLocked() {
        return this.hValueLocked;
    }

    public final void setHValueLocked(double d) {
        this.hValueLocked = d;
    }

    public final double getVValueLocked() {
        return this.vValueLocked;
    }

    public final void setVValueLocked(double d) {
        this.vValueLocked = d;
    }

    public final boolean getHPanLocked() {
        return this.hPanLocked;
    }

    public final void setHPanLocked(boolean bl) {
        this.hPanLocked = bl;
    }

    public final boolean getVPanLocked() {
        return this.vPanLocked;
    }

    public final void setVPanLocked(boolean bl) {
        this.vPanLocked = bl;
    }

    public final boolean getScrollLocked() {
        return this.scrollLocked;
    }

    public final void setScrollLocked(boolean bl) {
        this.scrollLocked = bl;
    }

    public final boolean getInteractive() {
        return this.interactive;
    }

    public final void setInteractive(boolean bl) {
        this.interactive = bl;
    }

    private final Node outerNode(Node node2) {
        Node outerNode = this.centeredNode(node2);
        outerNode.setOnScroll(arg_0 -> ZoomableScrollPane.outerNode$lambda-6(this, arg_0));
        outerNode.setOnMousePressed(arg_0 -> ZoomableScrollPane.outerNode$lambda-7(this, arg_0));
        outerNode.setOnMouseReleased(arg_0 -> ZoomableScrollPane.outerNode$lambda-8(this, arg_0));
        return outerNode;
    }

    private final Node centeredNode(Node node2) {
        Node[] nodeArray = new Node[]{node2};
        VBox vBox = new VBox(nodeArray);
        vBox.setAlignment(Pos.TOP_LEFT);
        return (Node)vBox;
    }

    private final void onScroll(double wheelDelta, Point2D mousePoint) {
        Timeline timeline = this.timeline;
        if ((timeline != null ? timeline.getStatus() : null) == Animation.Status.RUNNING) {
            return;
        }
        double zoomFactor = Math.exp(wheelDelta * this.zoomIntensity);
        Bounds innerBounds = this.zoomNode.getLayoutBounds();
        Bounds viewportBounds = this.getViewportBounds();
        double valX = this.getHvalue() * (innerBounds.getWidth() - viewportBounds.getWidth());
        double valY = this.getVvalue() * (innerBounds.getHeight() - viewportBounds.getHeight());
        this.setScaleValue(this.scaleValue * zoomFactor);
        this.layout();
        Point2D posInZoomTarget = this.target.parentToLocal(this.zoomNode.parentToLocal(mousePoint));
        Point2D adjustment = this.target.getLocalToParentTransform().deltaTransform(posInZoomTarget.multiply(zoomFactor - 1.0));
        Bounds updatedInnerBounds = this.zoomNode.getBoundsInLocal();
        this.setHvalue((valX + adjustment.getX()) / (updatedInnerBounds.getWidth() - viewportBounds.getWidth()));
        this.setVvalue((valY + adjustment.getY()) / (updatedInnerBounds.getHeight() - viewportBounds.getHeight()));
    }

    private static final void _init_$lambda-0(ZoomableScrollPane this$0, ObservableValue observableValue, Number number, Number nV) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.hPanLocked && !Intrinsics.areEqual((Object)nV, (Object)this$0.hValueLocked)) {
            this$0.setHvalue(this$0.hValueLocked);
        }
        double viewWidth = this$0.cameraPane.getWidth() / this$0.cameraPane.getZoom();
        this$0.anchorPoint = new Point2D(this$0.getHvalue() * (this$0.cameraPane.getTarget$bgw_gui().getWidth() - viewWidth), this$0.anchorPoint.getY());
    }

    private static final void _init_$lambda-1(ZoomableScrollPane this$0, ObservableValue observableValue, Number number, Number nV) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.vPanLocked && !Intrinsics.areEqual((Object)nV, (Object)this$0.vValueLocked)) {
            this$0.setVvalue(this$0.vValueLocked);
        }
        double viewHeight = this$0.cameraPane.getHeight() / this$0.cameraPane.getZoom();
        this$0.anchorPoint = new Point2D(this$0.anchorPoint.getX(), this$0.getVvalue() * (this$0.cameraPane.getTarget$bgw_gui().getHeight() - viewHeight));
    }

    private static final void smoothScrollTo$lambda-2(ZoomableScrollPane this$0, double $clampedHValue, double $clampedVValue, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.setHvalue(this$0.getHvalue() + ($clampedHValue - this$0.getHvalue()) * this$0.lerpTime);
        this$0.setVvalue(this$0.getVvalue() + ($clampedVValue - this$0.getVvalue()) * this$0.lerpTime);
        this$0.lerpTime += 0.001;
        if (Math.abs(this$0.getHvalue() - $clampedHValue) <= 0.01 && Math.abs(this$0.getVvalue() - $clampedVValue) <= 0.01) {
            Timeline timeline = this$0.timeline;
            if (timeline != null) {
                timeline.stop();
            }
            this$0.setHvalue($clampedHValue);
            this$0.setVvalue($clampedVValue);
            this$0.lerpTime = 0.0;
        }
    }

    private static final void reset$lambda-4(ZoomableScrollPane this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.setHvalue(this$0.getHvalue() + ((double)0.0f - this$0.getHvalue()) * this$0.lerpTime);
        this$0.setVvalue(this$0.getVvalue() + ((double)0.0f - this$0.getVvalue()) * this$0.lerpTime);
        this$0.setScaleValue(this$0.scaleValue + ((double)1.0f - this$0.scaleValue) * this$0.lerpTime);
        this$0.lerpTime += 0.001;
        if (Math.abs(this$0.getHvalue() - 0.0) <= 0.01 && Math.abs(this$0.getVvalue() - 0.0) <= 0.01 && Math.abs(this$0.scaleValue - 1.0) <= 0.01) {
            Timeline timeline = this$0.timeline;
            if (timeline != null) {
                timeline.stop();
            }
            this$0.setHvalue(0.0);
            this$0.setVvalue(0.0);
            this$0.setScaleValue(1.0);
            this$0.lerpTime = 0.0;
        }
    }

    private static final void outerNode$lambda-6(ZoomableScrollPane this$0, ScrollEvent e) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.consume();
        if (this$0.scrollLocked) {
            return;
        }
        if (this$0.interactive) {
            double d;
            ScrollEvent.HorizontalTextScrollUnits horizontalTextScrollUnits = e.getTextDeltaXUnits();
            switch (horizontalTextScrollUnits == null ? -1 : WhenMappings.$EnumSwitchMapping$0[horizontalTextScrollUnits.ordinal()]) {
                case 1: {
                    d = e.getDeltaY();
                    break;
                }
                case 2: {
                    d = e.getTextDeltaY();
                    break;
                }
                case -1: {
                    d = 0.0;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            double delta = d;
            this$0.onScroll(delta, new Point2D(e.getX(), e.getY()));
        }
        e.getDeltaY();
    }

    private static final void outerNode$lambda-7(ZoomableScrollPane this$0, MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (e.getButton() == this$0.panMouseButton && this$0.interactive) {
            this$0.setPannable(true);
        }
    }

    private static final void outerNode$lambda-8(ZoomableScrollPane this$0, MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (e.getButton() == this$0.panMouseButton && this$0.interactive) {
            this$0.setPannable(false);
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScrollEvent.HorizontalTextScrollUnits.values().length];
            nArray[ScrollEvent.HorizontalTextScrollUnits.NONE.ordinal()] = 1;
            nArray[ScrollEvent.HorizontalTextScrollUnits.CHARACTERS.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

