/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tools.aqua.bgw.builder.FXConverters;
import tools.aqua.bgw.builder.VisualBuilder;
import tools.aqua.bgw.components.gamecomponentviews.HexagonView;
import tools.aqua.bgw.visual.ColorVisual;
import tools.aqua.bgw.visual.CompoundVisual;
import tools.aqua.bgw.visual.ImageVisual;
import tools.aqua.bgw.visual.SingleLayerVisual;
import tools.aqua.bgw.visual.TextVisual;
import tools.aqua.bgw.visual.Visual;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ltools/aqua/bgw/builder/HexagonBuilder;", "", "()V", "BORDER_WIDTH", "", "FULL_CIRCLE_DEGREES", "", "HEXAGON_SIDES", "buildHexagonView", "Ljavafx/scene/layout/Region;", "hexagonView", "Ltools/aqua/bgw/components/gamecomponentviews/HexagonView;", "buildHexagonView$bgw_gui", "buildPaint", "Ljavafx/scene/paint/Paint;", "visual", "Ltools/aqua/bgw/visual/SingleLayerVisual;", "buildPolygon", "points", "", "compoundVisual", "Ltools/aqua/bgw/visual/CompoundVisual;", "Ltools/aqua/bgw/visual/TextVisual;", "generatePoints", "size", "roundCorners", "", "Ljavafx/scene/shape/Polygon;", "paint", "bgw-gui"})
public final class HexagonBuilder {
    @NotNull
    public static final HexagonBuilder INSTANCE = new HexagonBuilder();
    private static final int FULL_CIRCLE_DEGREES = 360;
    private static final int HEXAGON_SIDES = 6;
    private static final double BORDER_WIDTH = 50.0;

    private HexagonBuilder() {
    }

    @NotNull
    public final Region buildHexagonView$bgw_gui(@NotNull HexagonView hexagonView) {
        Region region;
        Region region2;
        Intrinsics.checkNotNullParameter((Object)hexagonView, (String)"hexagonView");
        double[] points = this.generatePoints(hexagonView.getSize().doubleValue());
        Visual visual = hexagonView.getVisual();
        if (visual instanceof TextVisual) {
            region2 = this.buildPolygon(points, (TextVisual)visual);
        } else if (visual instanceof SingleLayerVisual) {
            region2 = this.buildPolygon(points, (SingleLayerVisual)visual);
        } else if (visual instanceof CompoundVisual) {
            region2 = this.buildPolygon(points, (CompoundVisual)visual);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Region it = region = region2;
        boolean bl = false;
        hexagonView.setVisual(Visual.Companion.getEMPTY());
        return region;
    }

    /*
     * WARNING - void declaration
     */
    private final Region buildPolygon(double[] points, CompoundVisual compoundVisual) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Iterable iterable = compoundVisual.getChildren();
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SingleLayerVisual singleLayerVisual = (SingleLayerVisual)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it instanceof TextVisual ? INSTANCE.buildPolygon(points, (TextVisual)it) : INSTANCE.buildPolygon(points, (SingleLayerVisual)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        StackPane stackPane = thisCollection$iv.toArray(new Region[0]);
        Intrinsics.checkNotNull((Object)stackPane, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        StackPane stackPane2 = stackPane;
        Node[] nodeArray = (Node[])Arrays.copyOf(stackPane2, ((Region[])stackPane2).length);
        StackPane $this$buildPolygon_u24lambda_u2d2 = stackPane2 = new StackPane(nodeArray);
        boolean bl = false;
        $this$buildPolygon_u24lambda_u2d2.setPickOnBounds(false);
        return (Region)stackPane2;
    }

    /*
     * WARNING - void declaration
     */
    private final Region buildPolygon(double[] points, SingleLayerVisual visual) {
        void $this$buildPolygon_u24lambda_u2d3;
        Polygon polygon;
        Pane pane = new Node[1];
        Polygon polygon2 = polygon = new Polygon(Arrays.copyOf(points, points.length));
        int n = 0;
        Pane pane2 = pane;
        boolean bl = false;
        Paint paint = INSTANCE.buildPaint(visual);
        $this$buildPolygon_u24lambda_u2d3.setFill(paint);
        visual.getTransparencyProperty().addListenerAndInvoke(visual.getTransparency(), (Function2)new Function2<Double, Double, Unit>((Polygon)$this$buildPolygon_u24lambda_u2d3){
            final /* synthetic */ Polygon $this_apply;
            {
                this.$this_apply = $receiver;
                super(2);
            }

            public final void invoke(double d, double nV) {
                this.$this_apply.setOpacity(nV);
            }
        });
        $this$buildPolygon_u24lambda_u2d3.setStroke((Paint)Color.BLACK);
        $this$buildPolygon_u24lambda_u2d3.setStrokeType(StrokeType.INSIDE);
        Unit unit = Unit.INSTANCE;
        pane2[n] = (Node)polygon;
        Pane pane3 = pane;
        Pane $this$buildPolygon_u24lambda_u2d4 = pane = new Pane((Node[])pane3);
        boolean bl2 = false;
        $this$buildPolygon_u24lambda_u2d4.setPickOnBounds(false);
        return (Region)pane;
    }

    /*
     * WARNING - void declaration
     */
    private final Region buildPolygon(double[] points, TextVisual visual) {
        void $this$buildPolygon_u24lambda_u2d5;
        Region region;
        StackPane stackPane = new Node[2];
        Intrinsics.checkNotNull((Object)visual, (String)"null cannot be cast to non-null type tools.aqua.bgw.visual.SingleLayerVisual");
        stackPane[0] = (Node)this.buildPolygon(points, (SingleLayerVisual)visual);
        Region region2 = region = VisualBuilder.INSTANCE.buildVisual$bgw_gui(visual);
        int n = 1;
        StackPane stackPane2 = stackPane;
        boolean bl = false;
        $this$buildPolygon_u24lambda_u2d5.setPickOnBounds(false);
        Unit unit = Unit.INSTANCE;
        stackPane2[n] = (Node)region;
        StackPane stackPane3 = stackPane;
        StackPane $this$buildPolygon_u24lambda_u2d6 = stackPane = new StackPane((Node[])stackPane3);
        boolean bl2 = false;
        $this$buildPolygon_u24lambda_u2d6.setPickOnBounds(false);
        return (Region)stackPane;
    }

    private final void roundCorners(Polygon $this$roundCorners, Paint paint) {
        $this$roundCorners.setStroke(paint);
        $this$roundCorners.setStrokeWidth(50.0);
        $this$roundCorners.setStrokeType(StrokeType.CENTERED);
        $this$roundCorners.setStrokeLineJoin(StrokeLineJoin.ROUND);
        $this$roundCorners.setStrokeLineCap(StrokeLineCap.ROUND);
        $this$roundCorners.setStrokeMiterLimit(50.0);
    }

    private final double[] generatePoints(double size) {
        List points = new ArrayList();
        double angle = 0.0;
        angle = 90.0;
        int n = 6;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            double x = size * Math.cos(Math.toRadians(angle)) + size;
            double y = size * Math.sin(Math.toRadians(angle)) + size;
            angle += (double)60;
            points.add(x);
            points.add(y);
        }
        return CollectionsKt.toDoubleArray((Collection)points);
    }

    private final Paint buildPaint(SingleLayerVisual visual) {
        Paint paint;
        SingleLayerVisual singleLayerVisual = visual;
        if (singleLayerVisual instanceof ColorVisual) {
            paint = (Paint)FXConverters.INSTANCE.toFXColor$bgw_gui(((ColorVisual)visual).getColor());
        } else if (singleLayerVisual instanceof ImageVisual) {
            paint = (Paint)new ImagePattern(FXConverters.INSTANCE.toFXImage$bgw_gui(((ImageVisual)visual).getImage()));
        } else if (singleLayerVisual instanceof TextVisual) {
            Color color = Color.TRANSPARENT;
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"TRANSPARENT");
            paint = (Paint)color;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return paint;
    }
}

