/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.util;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.aqua.bgw.util.Trig;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0003H\u0086\u0002J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0011\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0006J\u0016\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0000J\u0011\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0003H\u0086\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u001a"}, d2={"Ltools/aqua/bgw/util/Coordinate;", "", "xCoord", "", "yCoord", "(Ljava/lang/Number;Ljava/lang/Number;)V", "", "getXCoord", "()D", "getYCoord", "div", "denominator", "equals", "", "other", "hashCode", "", "minus", "plus", "rotated", "angle", "center", "times", "factor", "toString", "", "bgw-gui"})
public class Coordinate {
    private final double xCoord;
    private final double yCoord;

    public Coordinate(@NotNull Number xCoord, @NotNull Number yCoord) {
        Intrinsics.checkNotNullParameter((Object)xCoord, (String)"xCoord");
        Intrinsics.checkNotNullParameter((Object)yCoord, (String)"yCoord");
        this.xCoord = xCoord.doubleValue();
        this.yCoord = yCoord.doubleValue();
    }

    public /* synthetic */ Coordinate(Number number, Number number2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            number = 0;
        }
        if ((n & 2) != 0) {
            number2 = 0;
        }
        this(number, number2);
    }

    public final double getXCoord() {
        return this.xCoord;
    }

    public final double getYCoord() {
        return this.yCoord;
    }

    @NotNull
    public final Coordinate plus(@NotNull Coordinate other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Coordinate(this.xCoord + other.xCoord, this.yCoord + other.yCoord);
    }

    @NotNull
    public final Coordinate minus(@NotNull Coordinate other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Coordinate(this.xCoord - other.xCoord, this.yCoord - other.yCoord);
    }

    @NotNull
    public final Coordinate times(@NotNull Number factor) {
        Intrinsics.checkNotNullParameter((Object)factor, (String)"factor");
        return new Coordinate(this.xCoord * factor.doubleValue(), this.yCoord * factor.doubleValue());
    }

    @NotNull
    public final Coordinate div(@NotNull Number denominator) {
        Intrinsics.checkNotNullParameter((Object)denominator, (String)"denominator");
        return new Coordinate(this.xCoord / denominator.doubleValue(), this.yCoord / denominator.doubleValue());
    }

    @NotNull
    public final Coordinate rotated(@NotNull Number angle, @NotNull Coordinate center) {
        Intrinsics.checkNotNullParameter((Object)angle, (String)"angle");
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        return new Coordinate(Trig.INSTANCE.cosD(angle) * (this.xCoord - center.xCoord) - Trig.INSTANCE.sinD(angle) * (this.yCoord - center.yCoord) + center.xCoord, Trig.INSTANCE.sinD(angle) * (this.xCoord - center.xCoord) + Trig.INSTANCE.cosD(angle) * (this.yCoord - center.yCoord) + center.yCoord);
    }

    @NotNull
    public final Coordinate rotated(double angle) {
        return this.rotated(angle, new Coordinate(0, 0));
    }

    @NotNull
    public String toString() {
        return "X = " + this.xCoord + ", Y = " + this.yCoord;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Coordinate)) {
            return false;
        }
        return this.xCoord == ((Coordinate)other).xCoord && this.yCoord == ((Coordinate)other).yCoord;
    }

    public int hashCode() {
        return Double.hashCode(this.xCoord) - Double.hashCode(this.yCoord);
    }

    public Coordinate() {
        this(null, null, 3, null);
    }
}

