/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.builder;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Paint;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tools.aqua.bgw.builder.FXConverters;
import tools.aqua.bgw.components.ComponentView;
import tools.aqua.bgw.core.Alignment;
import tools.aqua.bgw.util.Font;
import tools.aqua.bgw.visual.ColorVisual;
import tools.aqua.bgw.visual.CompoundVisual;
import tools.aqua.bgw.visual.ImageVisual;
import tools.aqua.bgw.visual.SingleLayerVisual;
import tools.aqua.bgw.visual.TextVisual;
import tools.aqua.bgw.visual.Visual;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0013H\u0002J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\u001c\u0010\u0018\u001a\u00020\u0019*\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u001eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ltools/aqua/bgw/builder/VisualBuilder;", "", "()V", "MAX_HEX", "", "build", "Ljavafx/scene/layout/Pane;", "componentView", "Ltools/aqua/bgw/components/ComponentView;", "build$bgw_gui", "buildColorVisual", "visual", "Ltools/aqua/bgw/visual/ColorVisual;", "buildCompoundVisual", "Ljavafx/scene/layout/StackPane;", "Ltools/aqua/bgw/visual/CompoundVisual;", "buildImageVisual", "Ltools/aqua/bgw/visual/ImageVisual;", "buildTextVisual", "Ltools/aqua/bgw/visual/TextVisual;", "buildVisual", "Ljavafx/scene/layout/Region;", "Ltools/aqua/bgw/visual/Visual;", "buildVisual$bgw_gui", "newPadding", "", "offsetX", "offsetY", "readImage", "Ljavafx/scene/image/Image;", "Ljava/awt/image/BufferedImage;", "bgw-gui"})
public final class VisualBuilder {
    @NotNull
    public static final VisualBuilder INSTANCE = new VisualBuilder();
    public static final double MAX_HEX = 255.0;

    private VisualBuilder() {
    }

    @NotNull
    public final Pane build$bgw_gui(@NotNull ComponentView componentView) {
        Intrinsics.checkNotNullParameter((Object)componentView, (String)"componentView");
        Pane root = new Pane();
        componentView.getVisualProperty$bgw_gui().setGUIListenerAndInvoke$bgw_gui(componentView.getVisual(), (Function2<Visual, Visual, Unit>)((Function2)new Function2<Visual, Visual, Unit>(root){
            final /* synthetic */ Pane $root;
            {
                this.$root = $root;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Visual visual, @NotNull Visual nV) {
                void $this$invoke_u24lambda_u2d0;
                Intrinsics.checkNotNullParameter((Object)visual, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)nV, (String)"nV");
                this.$root.getChildren().clear();
                Region region = VisualBuilder.INSTANCE.buildVisual$bgw_gui(nV);
                Pane pane = this.$root;
                Region region2 = region;
                ObservableList observableList = this.$root.getChildren();
                boolean bl = false;
                $this$invoke_u24lambda_u2d0.prefWidthProperty().bind((ObservableValue)pane.prefWidthProperty());
                $this$invoke_u24lambda_u2d0.prefHeightProperty().bind((ObservableValue)pane.prefHeightProperty());
                observableList.add((Object)region);
            }
        }));
        return root;
    }

    @NotNull
    public final Region buildVisual$bgw_gui(@NotNull Visual visual) {
        Region region;
        Intrinsics.checkNotNullParameter((Object)visual, (String)"visual");
        Visual visual2 = visual;
        if (visual2 instanceof ColorVisual) {
            region = (Region)this.buildColorVisual((ColorVisual)visual);
        } else if (visual2 instanceof ImageVisual) {
            region = (Region)this.buildImageVisual((ImageVisual)visual);
        } else if (visual2 instanceof TextVisual) {
            region = (Region)this.buildTextVisual((TextVisual)visual);
        } else if (visual2 instanceof CompoundVisual) {
            region = (Region)this.buildCompoundVisual((CompoundVisual)visual);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return region;
    }

    private final Pane buildColorVisual(ColorVisual visual) {
        Pane pane;
        Pane $this$buildColorVisual_u24lambda_u2d0 = pane = new Pane();
        boolean bl = false;
        visual.getColorProperty().setGUIListenerAndInvoke$bgw_gui(visual.getColor(), (Function2<Color, Color, Unit>)((Function2)new Function2<Color, Color, Unit>($this$buildColorVisual_u24lambda_u2d0, visual){
            final /* synthetic */ Pane $this_apply;
            final /* synthetic */ ColorVisual $visual;
            {
                this.$this_apply = $receiver;
                this.$visual = $visual;
                super(2);
            }

            public final void invoke(@NotNull Color color, @NotNull Color nV) {
                Intrinsics.checkNotNullParameter((Object)color, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)nV, (String)"nV");
                String string = "%02x";
                Object[] objectArray = new Object[]{nV.getRGB()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
                string = string2;
                int n = 2;
                String string3 = string.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                this.$this_apply.setStyle("-fx-background-color: #" + string3 + ";" + this.$visual.getStyle());
                this.$this_apply.setOpacity((double)nV.getAlpha() / 255.0 * this.$visual.getTransparency());
            }
        }));
        visual.getTransparencyProperty().setGUIListenerAndInvoke$bgw_gui(visual.getTransparency(), (Function2)new Function2<Double, Double, Unit>($this$buildColorVisual_u24lambda_u2d0, visual){
            final /* synthetic */ Pane $this_apply;
            final /* synthetic */ ColorVisual $visual;
            {
                this.$this_apply = $receiver;
                this.$visual = $visual;
                super(2);
            }

            public final void invoke(double d, double nV) {
                this.$this_apply.setOpacity((double)this.$visual.getColor().getAlpha() / 255.0 * nV);
            }
        });
        visual.getStyleProperty().setGUIListenerAndInvoke$bgw_gui(visual.getStyle(), (Function2)new Function2<String, String, Unit>($this$buildColorVisual_u24lambda_u2d0, visual){
            final /* synthetic */ Pane $this_apply;
            final /* synthetic */ ColorVisual $visual;
            {
                this.$this_apply = $receiver;
                this.$visual = $visual;
                super(2);
            }

            public final void invoke(@NotNull String string, @NotNull String nV) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)nV, (String)"nV");
                String string2 = "%02x";
                Object[] objectArray = new Object[]{this.$visual.getColor().getRGB()};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
                string2 = string3;
                int n = 2;
                String string4 = string2.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                this.$this_apply.setStyle("-fx-background-color: #" + string4 + ";" + nV);
            }
        });
        return pane;
    }

    private final Pane buildImageVisual(ImageVisual visual) {
        Pane pane;
        Pane $this$buildImageVisual_u24lambda_u2d1 = pane = new Pane();
        boolean bl = false;
        ImageView imageView = new ImageView();
        visual.getImageProperty().setGUIListenerAndInvoke$bgw_gui(visual.getImage(), (Function2<BufferedImage, BufferedImage, Unit>)((Function2)new Function2<BufferedImage, BufferedImage, Unit>(imageView){
            final /* synthetic */ ImageView $imageView;
            {
                this.$imageView = $imageView;
                super(2);
            }

            public final void invoke(@NotNull BufferedImage bufferedImage, @NotNull BufferedImage nV) {
                Intrinsics.checkNotNullParameter((Object)bufferedImage, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)nV, (String)"nV");
                this.$imageView.setImage(VisualBuilder.access$readImage(VisualBuilder.INSTANCE, nV));
            }
        }));
        visual.getTransparencyProperty().setGUIListenerAndInvoke$bgw_gui(visual.getTransparency(), (Function2)new Function2<Double, Double, Unit>($this$buildImageVisual_u24lambda_u2d1){
            final /* synthetic */ Pane $this_apply;
            {
                this.$this_apply = $receiver;
                super(2);
            }

            public final void invoke(double d, double nV) {
                this.$this_apply.setOpacity(nV);
            }
        });
        visual.getStyleProperty().setGUIListenerAndInvoke$bgw_gui(visual.getStyle(), (Function2)new Function2<String, String, Unit>($this$buildImageVisual_u24lambda_u2d1){
            final /* synthetic */ Pane $this_apply;
            {
                this.$this_apply = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String string, @NotNull String nV) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)nV, (String)"nV");
                this.$this_apply.setStyle(nV);
            }
        });
        imageView.fitWidthProperty().bind((ObservableValue)$this$buildImageVisual_u24lambda_u2d1.prefWidthProperty());
        imageView.fitHeightProperty().bind((ObservableValue)$this$buildImageVisual_u24lambda_u2d1.prefHeightProperty());
        $this$buildImageVisual_u24lambda_u2d1.getChildren().add((Object)imageView);
        return pane;
    }

    private final StackPane buildTextVisual(TextVisual visual) {
        Label label2;
        StackPane stackPane;
        StackPane $this$buildTextVisual_u24lambda_u2d3 = stackPane = new StackPane();
        boolean bl = false;
        Label $this$buildTextVisual_u24lambda_u2d3_u24lambda_u2d2 = label2 = new Label();
        boolean bl2 = false;
        $this$buildTextVisual_u24lambda_u2d3_u24lambda_u2d2.setMinWidth(0.0);
        $this$buildTextVisual_u24lambda_u2d3_u24lambda_u2d2.setMinHeight(0.0);
        visual.getTextProperty().setGUIListenerAndInvoke$bgw_gui(visual.getText(), (Function2)new Function2<String, String, Unit>($this$buildTextVisual_u24lambda_u2d3_u24lambda_u2d2){
            final /* synthetic */ Label $this_apply;
            {
                this.$this_apply = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String string, @NotNull String nV) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)nV, (String)"nV");
                this.$this_apply.setText(nV);
            }
        });
        visual.getTransparencyProperty().setGUIListenerAndInvoke$bgw_gui(visual.getTransparency(), (Function2)new Function2<Double, Double, Unit>($this$buildTextVisual_u24lambda_u2d3_u24lambda_u2d2){
            final /* synthetic */ Label $this_apply;
            {
                this.$this_apply = $receiver;
                super(2);
            }

            public final void invoke(double d, double nV) {
                this.$this_apply.setOpacity(nV);
            }
        });
        visual.getFontProperty().setGUIListenerAndInvoke$bgw_gui(visual.getFont(), (Function2<Font, Font, Unit>)((Function2)new Function2<Font, Font, Unit>($this$buildTextVisual_u24lambda_u2d3_u24lambda_u2d2, visual){
            final /* synthetic */ Label $this_apply;
            final /* synthetic */ TextVisual $visual;
            {
                this.$this_apply = $receiver;
                this.$visual = $visual;
                super(2);
            }

            public final void invoke(@NotNull Font font, @NotNull Font nV) {
                Intrinsics.checkNotNullParameter((Object)font, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)nV, (String)"nV");
                this.$this_apply.setStyle(FXConverters.INSTANCE.toFXFontCSS$bgw_gui(nV) + this.$visual.getStyle());
                this.$this_apply.setTextFill((Paint)FXConverters.INSTANCE.toFXColor$bgw_gui(nV.getColor()));
            }
        }));
        visual.getStyleProperty().setGUIListenerAndInvoke$bgw_gui(visual.getStyle(), (Function2)new Function2<String, String, Unit>($this$buildTextVisual_u24lambda_u2d3_u24lambda_u2d2, visual){
            final /* synthetic */ Label $this_apply;
            final /* synthetic */ TextVisual $visual;
            {
                this.$this_apply = $receiver;
                this.$visual = $visual;
                super(2);
            }

            public final void invoke(@NotNull String string, @NotNull String nV) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)nV, (String)"nV");
                this.$this_apply.setStyle(FXConverters.INSTANCE.toFXFontCSS$bgw_gui(this.$visual.getFont()) + nV);
            }
        });
        $this$buildTextVisual_u24lambda_u2d3_u24lambda_u2d2.wrapTextProperty().set(true);
        Label label3 = label2;
        visual.getAlignmentProperty().setGUIListenerAndInvoke$bgw_gui(visual.getAlignment(), (Function2<Alignment, Alignment, Unit>)((Function2)new Function2<Alignment, Alignment, Unit>($this$buildTextVisual_u24lambda_u2d3){
            final /* synthetic */ StackPane $this_apply;
            {
                this.$this_apply = $receiver;
                super(2);
            }

            public final void invoke(@NotNull Alignment alignment, @NotNull Alignment nV) {
                Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)((Object)nV), (String)"nV");
                this.$this_apply.setAlignment(FXConverters.INSTANCE.toFXPos$bgw_gui(nV));
            }
        }));
        visual.getOffsetXProperty().setGUIListenerAndInvoke$bgw_gui(visual.getOffsetX(), (Function2)new Function2<Double, Double, Unit>($this$buildTextVisual_u24lambda_u2d3, visual){
            final /* synthetic */ StackPane $this_apply;
            final /* synthetic */ TextVisual $visual;
            {
                this.$this_apply = $receiver;
                this.$visual = $visual;
                super(2);
            }

            public final void invoke(double d, double d2) {
                VisualBuilder.access$newPadding(VisualBuilder.INSTANCE, this.$this_apply, this.$visual.getOffsetX(), this.$visual.getOffsetY());
            }
        });
        visual.getOffsetYProperty().setGUIListenerAndInvoke$bgw_gui(visual.getOffsetX(), (Function2)new Function2<Double, Double, Unit>($this$buildTextVisual_u24lambda_u2d3, visual){
            final /* synthetic */ StackPane $this_apply;
            final /* synthetic */ TextVisual $visual;
            {
                this.$this_apply = $receiver;
                this.$visual = $visual;
                super(2);
            }

            public final void invoke(double d, double d2) {
                VisualBuilder.access$newPadding(VisualBuilder.INSTANCE, this.$this_apply, this.$visual.getOffsetX(), this.$visual.getOffsetY());
            }
        });
        $this$buildTextVisual_u24lambda_u2d3.getChildren().add((Object)label3);
        return stackPane;
    }

    private final void newPadding(StackPane $this$newPadding, double offsetX, double offsetY) {
        double topInset = offsetY >= 0.0 ? offsetY : 0.0;
        double rightInset = offsetX < 0.0 ? Math.abs(offsetX) : 0.0;
        double bottomInset = offsetY < 0.0 ? Math.abs(offsetY) : 0.0;
        double leftInset = offsetX >= 0.0 ? offsetX : 0.0;
        $this$newPadding.setPadding(new Insets(topInset, rightInset, bottomInset, leftInset));
    }

    private final StackPane buildCompoundVisual(CompoundVisual visual) {
        StackPane stackPane;
        StackPane $this$buildCompoundVisual_u24lambda_u2d4 = stackPane = new StackPane();
        boolean bl = false;
        visual.setGUIListenerAndInvoke$bgw_gui((Function0<Unit>)((Function0)new Function0<Unit>($this$buildCompoundVisual_u24lambda_u2d4, visual){
            final /* synthetic */ StackPane $this_apply;
            final /* synthetic */ CompoundVisual $visual;
            {
                this.$this_apply = $receiver;
                this.$visual = $visual;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$onEach$iv;
                void var4_7;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                this.$this_apply.getChildren().clear();
                Iterable iterable = this.$visual.getChildren();
                ObservableList observableList = this.$this_apply.getChildren();
                boolean $i$f$map = false;
                void var3_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SingleLayerVisual singleLayerVisual = (SingleLayerVisual)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(VisualBuilder.INSTANCE.buildVisual$bgw_gui((Visual)it));
                }
                $this$map$iv = (List)destination$iv$iv;
                StackPane stackPane = this.$this_apply;
                boolean $i$f$onEach = false;
                void $this$onEach_u24lambda_u2d16$iv = var4_7 = $this$onEach$iv;
                boolean bl = false;
                for (T element$iv : $this$onEach_u24lambda_u2d16$iv) {
                    Region it = (Region)element$iv;
                    boolean bl2 = false;
                    it.prefWidthProperty().bind((ObservableValue)stackPane.prefWidthProperty());
                    it.prefHeightProperty().bind((ObservableValue)stackPane.prefHeightProperty());
                }
                observableList.addAll((Collection)var4_7);
            }
        }));
        return stackPane;
    }

    private final Image readImage(BufferedImage $this$readImage) {
        WritableImage imageWriter = new WritableImage($this$readImage.getWidth(), $this$readImage.getHeight());
        PixelWriter pixelWriter = imageWriter.getPixelWriter();
        int n = $this$readImage.getWidth();
        for (int x = 0; x < n; ++x) {
            int n2 = $this$readImage.getHeight();
            for (int y = 0; y < n2; ++y) {
                pixelWriter.setArgb(x, y, $this$readImage.getRGB(x, y));
            }
        }
        return (Image)imageWriter;
    }

    public static final /* synthetic */ Image access$readImage(VisualBuilder $this, BufferedImage $receiver) {
        return $this.readImage($receiver);
    }

    public static final /* synthetic */ void access$newPadding(VisualBuilder $this, StackPane $receiver, double offsetX, double offsetY) {
        $this.newPadding($receiver, offsetX, offsetY);
    }
}

