/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.util;

import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tools.aqua.bgw.util.Coordinate;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bB'\b\u0002\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u0012\u0006\u0010\r\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\tJ\b\u0010%\u001a\u00020&H\u0016R\u0011\u0010\r\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0014\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0010R\u0011\u0010\u001b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0010R\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0010R\u0011\u0010\u001e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0010R\u0011\u0010 \u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0019\u00a8\u0006'"}, d2={"Ltools/aqua/bgw/util/CoordinatePlain;", "", "topLeftX", "", "topLeftY", "bottomRightX", "bottomRightY", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "topLeft", "Ltools/aqua/bgw/util/Coordinate;", "bottomRight", "(Ltools/aqua/bgw/util/Coordinate;Ltools/aqua/bgw/util/Coordinate;)V", "topRight", "bottomLeft", "(Ltools/aqua/bgw/util/Coordinate;Ltools/aqua/bgw/util/Coordinate;Ltools/aqua/bgw/util/Coordinate;Ltools/aqua/bgw/util/Coordinate;)V", "getBottomLeft", "()Ltools/aqua/bgw/util/Coordinate;", "bottomLeftBound", "getBottomLeftBound", "getBottomRight", "bottomRightBound", "getBottomRightBound", "height", "", "getHeight", "()D", "getTopLeft", "topLeftBound", "getTopLeftBound", "getTopRight", "topRightBound", "getTopRightBound", "width", "getWidth", "rotated", "angle", "center", "toString", "", "bgw-core"})
public class CoordinatePlain {
    @NotNull
    private final Coordinate topLeft;
    @NotNull
    private final Coordinate topRight;
    @NotNull
    private final Coordinate bottomLeft;
    @NotNull
    private final Coordinate bottomRight;
    @NotNull
    private final Coordinate topLeftBound;
    @NotNull
    private final Coordinate topRightBound;
    @NotNull
    private final Coordinate bottomLeftBound;
    @NotNull
    private final Coordinate bottomRightBound;
    private final double width;
    private final double height;

    private CoordinatePlain(Coordinate topLeft, Coordinate topRight, Coordinate bottomLeft, Coordinate bottomRight) {
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.bottomLeft = bottomLeft;
        this.bottomRight = bottomRight;
        double[] dArray = new double[]{this.topRight.getXCoord(), this.bottomLeft.getXCoord(), this.bottomRight.getXCoord()};
        double minX = ComparisonsKt.minOf((double)this.topLeft.getXCoord(), (double[])dArray);
        double[] dArray2 = new double[]{this.topRight.getXCoord(), this.bottomLeft.getXCoord(), this.bottomRight.getXCoord()};
        double maxX = ComparisonsKt.maxOf((double)this.topLeft.getXCoord(), (double[])dArray2);
        double[] dArray3 = new double[]{this.topRight.getYCoord(), this.bottomLeft.getYCoord(), this.bottomRight.getYCoord()};
        double minY = ComparisonsKt.minOf((double)this.topLeft.getYCoord(), (double[])dArray3);
        double[] dArray4 = new double[]{this.topRight.getYCoord(), this.bottomLeft.getYCoord(), this.bottomRight.getYCoord()};
        double maxY = ComparisonsKt.maxOf((double)this.topLeft.getYCoord(), (double[])dArray4);
        this.topLeftBound = new Coordinate(minX, minY);
        this.topRightBound = new Coordinate(maxX, minY);
        this.bottomLeftBound = new Coordinate(minX, maxY);
        this.bottomRightBound = new Coordinate(maxX, maxY);
        this.width = maxX - minX;
        this.height = maxY - minY;
    }

    @NotNull
    public final Coordinate getTopLeft() {
        return this.topLeft;
    }

    @NotNull
    public final Coordinate getTopRight() {
        return this.topRight;
    }

    @NotNull
    public final Coordinate getBottomLeft() {
        return this.bottomLeft;
    }

    @NotNull
    public final Coordinate getBottomRight() {
        return this.bottomRight;
    }

    @NotNull
    public final Coordinate getTopLeftBound() {
        return this.topLeftBound;
    }

    @NotNull
    public final Coordinate getTopRightBound() {
        return this.topRightBound;
    }

    @NotNull
    public final Coordinate getBottomLeftBound() {
        return this.bottomLeftBound;
    }

    @NotNull
    public final Coordinate getBottomRightBound() {
        return this.bottomRightBound;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public CoordinatePlain(@NotNull Number topLeftX, @NotNull Number topLeftY, @NotNull Number bottomRightX, @NotNull Number bottomRightY) {
        Intrinsics.checkNotNullParameter((Object)topLeftX, (String)"topLeftX");
        Intrinsics.checkNotNullParameter((Object)topLeftY, (String)"topLeftY");
        Intrinsics.checkNotNullParameter((Object)bottomRightX, (String)"bottomRightX");
        Intrinsics.checkNotNullParameter((Object)bottomRightY, (String)"bottomRightY");
        this(new Coordinate(topLeftX, topLeftY), new Coordinate(bottomRightX, topLeftY), new Coordinate(topLeftX, bottomRightY), new Coordinate(bottomRightX, bottomRightY));
        boolean bl = topLeftX.doubleValue() <= bottomRightX.doubleValue();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Top left corner is not to the right of bottom left corner.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = topLeftY.doubleValue() <= bottomRightY.doubleValue();
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Top left corner is not to the right of bottom left corner.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public CoordinatePlain(@NotNull Coordinate topLeft, @NotNull Coordinate bottomRight) {
        Intrinsics.checkNotNullParameter((Object)topLeft, (String)"topLeft");
        Intrinsics.checkNotNullParameter((Object)bottomRight, (String)"bottomRight");
        this(topLeft.getXCoord(), topLeft.getYCoord(), bottomRight.getXCoord(), bottomRight.getYCoord());
    }

    @NotNull
    public final CoordinatePlain rotated(@NotNull Number angle, @NotNull Coordinate center) {
        Intrinsics.checkNotNullParameter((Object)angle, (String)"angle");
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        return new CoordinatePlain(this.topLeft.rotated(angle, center), this.topRight.rotated(angle, center), this.bottomLeft.rotated(angle, center), this.bottomRight.rotated(angle, center));
    }

    @NotNull
    public String toString() {
        return "CoordinatePlain(topLeft=" + this.topLeft + ", topRight=" + this.topRight + ", bottomLeft=" + this.bottomLeft + ", bottomRight=" + this.bottomRight + ", width=" + this.width + ", height=" + this.height + ")";
    }
}

