/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.components.layoutviews;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import tools.aqua.bgw.components.ComponentView;
import tools.aqua.bgw.components.layoutviews.LayoutView;
import tools.aqua.bgw.observable.IObservable;
import tools.aqua.bgw.observable.ObservableArrayList;
import tools.aqua.bgw.util.Coordinate;
import tools.aqua.bgw.visual.Visual;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B7\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001d\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u00002\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ\u001f\u0010\u001c\u001a\u00020\u00172\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u001d\"\u00028\u0000\u00a2\u0006\u0002\u0010\u001eJ\u0014\u0010\u001c\u001a\u00020\u00172\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000 J\u000e\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020\u0017J\u0015\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0002H\u0010\u00a2\u0006\u0002\b(J\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020*J\u000f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000-H\u0096\u0002J\u0006\u0010.\u001a\u00020\u001aJ\u0013\u0010/\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u00100J\f\u00101\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eJ\u0015\u00102\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0010\u00a2\u0006\u0002\b3J\u000e\u00104\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#R,\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e8F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00065"}, d2={"Ltools/aqua/bgw/components/layoutviews/Pane;", "T", "Ltools/aqua/bgw/components/ComponentView;", "Ltools/aqua/bgw/components/layoutviews/LayoutView;", "", "height", "", "width", "posX", "posY", "visual", "Ltools/aqua/bgw/visual/Visual;", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ltools/aqua/bgw/visual/Visual;)V", "<set-?>", "", "components", "getComponents", "()Ljava/util/List;", "observableComponents", "Ltools/aqua/bgw/observable/ObservableArrayList;", "getObservableComponents$bgw_core", "()Ltools/aqua/bgw/observable/ObservableArrayList;", "add", "", "component", "index", "", "(Ltools/aqua/bgw/components/ComponentView;I)V", "addAll", "", "([Ltools/aqua/bgw/components/ComponentView;)V", "collection", "", "addComponentsListener", "listener", "Ltools/aqua/bgw/observable/IObservable;", "clearComponentsListener", "getChildPosition", "Ltools/aqua/bgw/util/Coordinate;", "child", "getChildPosition$bgw_core", "isEmpty", "", "isNotEmpty", "iterator", "", "numberOfComponents", "remove", "(Ltools/aqua/bgw/components/ComponentView;)V", "removeAll", "removeChild", "removeChild$bgw_core", "removeComponentsListener", "bgw-core"})
public final class Pane<T extends ComponentView>
extends LayoutView<T>
implements Iterable<T>,
KMappedMarker {
    @NotNull
    private final ObservableArrayList<T> observableComponents;
    @NotNull
    private List<? extends T> components;

    public Pane(@NotNull Number height, @NotNull Number width, @NotNull Number posX, @NotNull Number posY, @NotNull Visual visual) {
        Intrinsics.checkNotNullParameter((Object)height, (String)"height");
        Intrinsics.checkNotNullParameter((Object)width, (String)"width");
        Intrinsics.checkNotNullParameter((Object)posX, (String)"posX");
        Intrinsics.checkNotNullParameter((Object)posY, (String)"posY");
        Intrinsics.checkNotNullParameter((Object)visual, (String)"visual");
        super(height, width, posX, posY, visual, null);
        this.observableComponents = new ObservableArrayList(null, 1, null);
        this.components = CollectionsKt.toList((Iterable)this.observableComponents);
    }

    public /* synthetic */ Pane(Number number, Number number2, Number number3, Number number4, Visual visual, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            number = 0;
        }
        if ((n & 2) != 0) {
            number2 = 0;
        }
        if ((n & 4) != 0) {
            number3 = 0;
        }
        if ((n & 8) != 0) {
            number4 = 0;
        }
        if ((n & 0x10) != 0) {
            visual = Visual.Companion.getEMPTY();
        }
        this(number, number2, number3, number4, visual);
    }

    @NotNull
    public final ObservableArrayList<T> getObservableComponents$bgw_core() {
        return this.observableComponents;
    }

    @NotNull
    public final List<T> getComponents() {
        return CollectionsKt.toList((Iterable)this.observableComponents);
    }

    public final void addComponentsListener(@NotNull IObservable listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.observableComponents.addListener(listener);
    }

    public final void removeComponentsListener(@NotNull IObservable listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.observableComponents.removeListener(listener);
    }

    public final void clearComponentsListener() {
        this.observableComponents.clearListeners();
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void add(@NotNull T component, int index) {
        void $this$add_u24lambda_u2d3;
        Intrinsics.checkNotNullParameter(component, (String)"component");
        boolean bl = !this.observableComponents.contains(component);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Component " + component + " is already contained in this " + this + ".";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = ((ComponentView)component).getParent() == null;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Component " + component + " is already contained in another container.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = 0 <= index ? index <= this.observableComponents.getSize() : false;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Index " + index + " is out of list range.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        T t = component;
        bl2 = false;
        bl3 = false;
        T bl6 = t;
        int n = index;
        ObservableArrayList<T> observableArrayList = this.observableComponents;
        boolean bl7 = false;
        $this$add_u24lambda_u2d3.setParent$bgw_core(this);
        Unit unit = Unit.INSTANCE;
        observableArrayList.add(n, t);
    }

    public static /* synthetic */ void add$default(Pane pane, ComponentView componentView, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = pane.observableComponents.getSize();
        }
        pane.add(componentView, n);
    }

    public final void addAll(T ... components) {
        Intrinsics.checkNotNullParameter(components, (String)"components");
        try {
            this.addAll(ArraysKt.toList((Object[])components));
        }
        catch (IllegalArgumentException e2) {
            throw new IllegalArgumentException(e2.getMessage());
        }
    }

    public final synchronized void addAll(@NotNull Collection<? extends T> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        try {
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ComponentView it = (ComponentView)element$iv;
                boolean bl = false;
                Pane.add$default(this, it, 0, 2, null);
            }
        }
        catch (IllegalArgumentException e2) {
            throw new IllegalArgumentException(e2.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void remove(@NotNull T component) {
        void $this$remove_u24lambda_u2d5;
        Intrinsics.checkNotNullParameter(component, (String)"component");
        T t = component;
        boolean bl = false;
        boolean bl2 = false;
        T t2 = t;
        ObservableArrayList<T> observableArrayList = this.observableComponents;
        boolean bl3 = false;
        $this$remove_u24lambda_u2d5.setParent$bgw_core(null);
        Unit unit = Unit.INSTANCE;
        observableArrayList.remove(t);
    }

    @NotNull
    public final synchronized List<T> removeAll() {
        List tmp = CollectionsKt.toList((Iterable)this.observableComponents);
        Iterable $this$forEach$iv = this.observableComponents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ComponentView it = (ComponentView)element$iv;
            boolean bl = false;
            it.setParent$bgw_core(null);
        }
        this.observableComponents.clear();
        return tmp;
    }

    public final int numberOfComponents() {
        return this.observableComponents.getSize();
    }

    public final boolean isEmpty() {
        return this.observableComponents.isEmpty();
    }

    public final boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @Override
    @NotNull
    public Coordinate getChildPosition$bgw_core(@NotNull ComponentView child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        return new Coordinate(child.getPosX(), child.getPosY());
    }

    @Override
    public void removeChild$bgw_core(@NotNull ComponentView component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        try {
            this.remove(component);
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException(component + " type is incompatible with container's type.");
        }
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.observableComponents.iterator();
    }

    public Pane() {
        this(null, null, null, null, null, 31, null);
    }
}

