/*
 * Decompiled with CFR 0.152.
 */
package tools.android.networkinterfacewatcher;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import tools.android.networkinterfacewatcher.NetworkUtil;

public class NetworkInterfaceWatcher
extends BroadcastReceiver {
    private boolean enableLogcat = false;
    private boolean stop = false;
    private boolean debounce = false;
    private long debounceMillis = 0L;
    private Debouncer debouncer;
    private Handler mHandler = new Handler(new HandlerThread("NetworkInterfaceWatcher-single-thread"){
        {
            this.start();
        }
    }.getLooper());
    private int flags = 255;

    public NetworkInterfaceWatcher() {
        this(false, 0L);
    }

    public NetworkInterfaceWatcher(boolean enableLogcat) {
        this(enableLogcat, 0L);
    }

    public NetworkInterfaceWatcher(long debounceMillis) {
        this(false, debounceMillis);
    }

    public NetworkInterfaceWatcher(boolean enableLogcat, long debounceMillis) {
        this.enableLogcat = enableLogcat;
        if (debounceMillis <= 0L) {
            this.debounce = false;
        } else if (debounceMillis < 100L) {
            this.debounce = true;
            this.debounceMillis = 100L;
            this.debouncer = new Debouncer(this.debounceMillis);
        } else if (debounceMillis > 5000L) {
            this.debounce = true;
            this.debounceMillis = 5000L;
            this.debouncer = new Debouncer(this.debounceMillis);
        } else {
            this.debounce = true;
            this.debounceMillis = debounceMillis;
            this.debouncer = new Debouncer(this.debounceMillis);
        }
    }

    protected void networkUnavailable() {
        this.say("NetworkWatcher", "call networkUnavailable");
    }

    protected void networkHardwareAvailable() {
    }

    protected void networkHardwareInvalid() {
    }

    protected void networkConnect() {
    }

    protected void networkDisconnect() {
    }

    protected void nonWifiState() {
        this.say("NetworkWatcher", "call nonWifiState");
    }

    protected void wifiState() {
        this.say("NetworkWatcher", "call wifiState");
    }

    public void pause() {
        this.say("NetworkWatcher", "pause");
        this.stop = true;
    }

    public void resume() {
        this.say("NetworkWatcher", "resume");
        this.stop = false;
    }

    public void release() {
        this.say("NetworkWatcher", "unregist");
        this.mHandler = null;
        this.debouncer = null;
    }

    public void onReceive(Context context, Intent intent) {
        this.say("NetworkWatcher", "receive intent");
        if (this.stop) {
            return;
        }
        this.mHandler.post((Runnable)new ContextRunnable(context){

            @Override
            public void run(Context context) {
                NetworkInterfaceWatcher.this.onReceiveIntent(context);
            }
        });
    }

    private void onReceiveIntent(Context context) {
        if (!NetworkUtil.isNetworkHardwareAvailable(context) || !NetworkUtil.checkNetworkState(context)) {
            this.flags = 255;
            this.say("NetworkWatcher", "network hardware invalid or disconnect");
            this.networkUnavailable();
        }
        if (!NetworkUtil.isNetworkHardwareAvailable(context)) {
            this.say("NetworkWatcher", "network hardware invalid");
            if ((this.flags >> 0 & 1) == 1) {
                this.flags = this.flags & 0xFE | 0xFE;
                this.networkHardwareInvalid();
            }
            this.say("NetworkWatcher", "ret@0");
            return;
        }
        this.say("NetworkWatcher", "network hardware available");
        if ((this.flags >> 1 & 1) == 1) {
            this.flags = this.flags & 0xFC | 1;
            this.networkHardwareAvailable();
        }
        if (!NetworkUtil.checkNetworkState(context)) {
            this.say("NetworkWatcher", "network disconnect");
            if ((this.flags >> 2 & 1) == 1) {
                this.flags = this.flags & 0xFB | 0xF8;
                this.networkDisconnect();
            }
            this.say("NetworkWatcher", "ret@1");
            return;
        }
        this.say("NetworkWatcher", "network connect");
        if ((this.flags >> 3 & 1) == 1) {
            this.flags = this.flags & 0xF3 | 4;
            this.networkConnect();
        }
        if (!NetworkUtil.checkWifiState(context)) {
            this.say("NetworkWatcher", "non-wifi state");
            if ((this.flags >> 4 & 1) == 1) {
                this.flags = this.flags & 0xEF | 0xE0;
                this.nonWifiState();
            }
            this.say("NetworkWatcher", "ret@2");
            return;
        }
        this.say("NetworkWatcher", "wifi state");
        if ((this.flags >> 5 & 1) == 1) {
            this.flags = this.flags & 0xCF | 0x10;
            this.wifiState();
        }
        this.say("NetworkWatcher", "ret@3");
    }

    protected void say(String who, String what) {
        if (this.enableLogcat) {
            Log.d((String)who, (String)what);
        }
    }

    class Debouncer {
        long debounceMillis = 0L;
        int lastFlags = 255;
        long lastTs = 0L;

        public Debouncer(long debounceMillis) {
            this.debounceMillis = debounceMillis;
        }

        public void post(int flags, Runnable runnable) {
        }
    }

    abstract class ContextRunnable
    implements Runnable {
        Context context = null;

        public ContextRunnable(Context context) {
            this.context = context;
        }

        @Override
        public void run() {
            this.run(this.context);
        }

        public abstract void run(Context var1);
    }
}

