/*
 * Decompiled with CFR 0.152.
 */
package tools.android.networkinterfacewatcher;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import tools.android.networkinterfacewatcher.ConnectionType;
import tools.android.networkinterfacewatcher.NetworkAvailabilityListener;
import tools.android.networkinterfacewatcher.NetworkChangeListener;
import tools.android.networkinterfacewatcher.NetworkInterfaceWatcher;
import tools.android.networkinterfacewatcher.NetworkState;
import tools.android.networkinterfacewatcher.NetworkType;
import tools.android.networkinterfacewatcher.NetworkUtil;

public class NetworkWatcher {
    protected NetworkInterfaceWatcher connectivityWatcher;
    protected NetworkState state;
    protected ConnectionType type;
    private Object lock = new Object();
    private NetworkAvailabilityListener mNetworkAvailabilityListener;
    private NetworkChangeListener mNetworkChangeListener;

    public NetworkWatcher(Context context) {
        this.init(context, false, 0L);
    }

    public NetworkWatcher(Context context, boolean enableLogcat) {
        this.init(context, enableLogcat, 0L);
    }

    public NetworkWatcher(Context context, long debounceMillis) {
        this.init(context, false, debounceMillis);
    }

    public NetworkWatcher(Context context, boolean enableLogcat, long debounceMillis) {
        this.init(context, enableLogcat, debounceMillis);
    }

    public NetworkWatcher(Context context, NetworkChangeListener listener) {
        this.setNetworkChangeListener(listener);
        this.init(context, false, 0L);
    }

    public NetworkWatcher(Context context, boolean enableLogcat, NetworkChangeListener listener) {
        this.setNetworkChangeListener(listener);
        this.init(context, enableLogcat, 0L);
    }

    public NetworkWatcher(Context context, long debounceMillis, NetworkChangeListener listener) {
        this.setNetworkChangeListener(listener);
        this.init(context, false, debounceMillis);
    }

    public NetworkWatcher(Context context, boolean enableLogcat, long debounceMillis, NetworkChangeListener listener) {
        this.setNetworkChangeListener(listener);
        this.init(context, enableLogcat, debounceMillis);
    }

    public NetworkWatcher(Context context, NetworkAvailabilityListener listener) {
        this.setNetworkAvailabilityListener(listener);
        this.init(context, false, 0L);
    }

    public NetworkWatcher(Context context, boolean enableLogcat, NetworkAvailabilityListener listener) {
        this.setNetworkAvailabilityListener(listener);
        this.init(context, enableLogcat, 0L);
    }

    public NetworkWatcher(Context context, long debounceMillis, NetworkAvailabilityListener listener) {
        this.setNetworkAvailabilityListener(listener);
        this.init(context, false, debounceMillis);
    }

    public NetworkWatcher(Context context, boolean enableLogcat, long debounceMillis, NetworkAvailabilityListener listener) {
        this.setNetworkAvailabilityListener(listener);
        this.init(context, enableLogcat, debounceMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, boolean enableLogcat, long debounceMillis) {
        this.connectivityWatcher = new NetworkInterfaceWatcher(enableLogcat, debounceMillis){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void networkUnavailable() {
                super.networkUnavailable();
                NetworkType oldType = NetworkWatcher.this.getNetType();
                NetworkWatcher.this.state = NetworkState.unavailable;
                NetworkWatcher.this.type = null;
                NetworkType newType = NetworkWatcher.this.getNetType();
                Object object = NetworkWatcher.this.lock;
                synchronized (object) {
                    try {
                        if (NetworkWatcher.this.mNetworkAvailabilityListener != null) {
                            NetworkWatcher.this.mNetworkAvailabilityListener.onUnavailable();
                        } else {
                            NetworkWatcher.this.onUnavailable();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (oldType != newType) {
                    object = NetworkWatcher.this.lock;
                    synchronized (object) {
                        try {
                            if (NetworkWatcher.this.mNetworkChangeListener != null) {
                                NetworkWatcher.this.mNetworkChangeListener.onChange(oldType, newType);
                            } else {
                                NetworkWatcher.this.onChange(oldType, newType);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void nonWifiState() {
                super.nonWifiState();
                NetworkType oldType = NetworkWatcher.this.getNetType();
                NetworkWatcher.this.state = NetworkState.available;
                NetworkWatcher.this.type = ConnectionType.MOBILE;
                NetworkType newType = NetworkWatcher.this.getNetType();
                Object object = NetworkWatcher.this.lock;
                synchronized (object) {
                    try {
                        if (NetworkWatcher.this.mNetworkAvailabilityListener != null) {
                            NetworkWatcher.this.mNetworkAvailabilityListener.onAvailable(ConnectionType.MOBILE);
                        } else {
                            NetworkWatcher.this.onAvailable(ConnectionType.MOBILE);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (oldType != newType) {
                    object = NetworkWatcher.this.lock;
                    synchronized (object) {
                        try {
                            if (NetworkWatcher.this.mNetworkChangeListener != null) {
                                NetworkWatcher.this.mNetworkChangeListener.onChange(oldType, newType);
                            } else {
                                NetworkWatcher.this.onChange(oldType, newType);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void wifiState() {
                super.wifiState();
                NetworkType oldType = NetworkWatcher.this.getNetType();
                NetworkWatcher.this.state = NetworkState.available;
                NetworkWatcher.this.type = ConnectionType.WIFI;
                NetworkType newType = NetworkWatcher.this.getNetType();
                Object object = NetworkWatcher.this.lock;
                synchronized (object) {
                    try {
                        if (NetworkWatcher.this.mNetworkAvailabilityListener != null) {
                            NetworkWatcher.this.mNetworkAvailabilityListener.onAvailable(ConnectionType.WIFI);
                        } else {
                            NetworkWatcher.this.onAvailable(ConnectionType.WIFI);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                object = NetworkWatcher.this.lock;
                synchronized (object) {
                    if (oldType != newType) {
                        try {
                            if (NetworkWatcher.this.mNetworkChangeListener != null) {
                                NetworkWatcher.this.mNetworkChangeListener.onChange(oldType, newType);
                            } else {
                                NetworkWatcher.this.onChange(oldType, newType);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        try {
            context.registerReceiver((BroadcastReceiver)this.connectivityWatcher, filter);
            this.connectivityWatcher.say("NetworkWatcher", "regist");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.state = NetworkState.unavailable;
        this.type = null;
        if (NetworkUtil.checkNetworkState(context)) {
            this.state = NetworkState.available;
            this.type = !NetworkUtil.checkWifiState(context) ? ConnectionType.MOBILE : ConnectionType.WIFI;
        }
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.mNetworkChangeListener != null) {
                    this.mNetworkChangeListener.onInit(this.getNetType());
                } else {
                    this.onInit(this.getNetType());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public NetworkState getState() {
        return this.state;
    }

    public ConnectionType getType() {
        return this.type;
    }

    public NetworkType getNetType() {
        if (NetworkState.unavailable == this.getState()) {
            return NetworkType.Disconnect;
        }
        if (NetworkState.available == this.getState()) {
            if (ConnectionType.MOBILE == this.getType()) {
                return NetworkType.Mobile;
            }
            if (ConnectionType.WIFI == this.getType()) {
                return NetworkType.Wifi;
            }
        }
        return NetworkType.Unknown;
    }

    private void setNetworkAvailabilityListener(NetworkAvailabilityListener l) {
        this.mNetworkAvailabilityListener = l;
    }

    private void setNetworkChangeListener(NetworkChangeListener l) {
        this.mNetworkChangeListener = l;
    }

    public void release(Context context) {
        if (this.connectivityWatcher != null) {
            try {
                context.unregisterReceiver((BroadcastReceiver)this.connectivityWatcher);
                this.connectivityWatcher.say("NetworkWatcher", "unregist");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.connectivityWatcher = null;
        this.mNetworkAvailabilityListener = null;
        this.mNetworkChangeListener = null;
    }

    protected void onUnavailable() {
    }

    protected void onAvailable(ConnectionType type) {
    }

    protected void onInit(NetworkType initType) {
    }

    protected void onChange(NetworkType oldType, NetworkType newType) {
    }
}

