/*
 * Decompiled with CFR 0.152.
 */
package tools.android.networkinterfacewatcher;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

public class NetworkUtil {
    public static boolean checkNetworkState(Context context) {
        try {
            NetworkInfo info;
            ConnectivityManager connectivity = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
            if (connectivity != null && (info = connectivity.getActiveNetworkInfo()) != null && info.isConnected() && info.getState() == NetworkInfo.State.CONNECTED) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean checkWifiState(Context context) {
        try {
            ConnectivityManager connectManager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
            NetworkInfo wifi = connectManager.getNetworkInfo(1);
            if (wifi.isAvailable() && wifi.isConnected()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isNetworkHardwareAvailable(Context context) {
        return NetworkUtil.isWifiHardwareAvailable(context) || NetworkUtil.isMobileHardwareAvailable(context);
    }

    public static boolean isWifiHardwareAvailable(Context context) {
        try {
            ConnectivityManager connectManager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
            NetworkInfo wifi = connectManager.getNetworkInfo(1);
            if (wifi != null && wifi.isAvailable()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isMobileHardwareAvailable(Context context) {
        try {
            ConnectivityManager connectManager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
            NetworkInfo mobile = connectManager.getNetworkInfo(0);
            if (mobile != null && mobile.isAvailable()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

