/*
 * Decompiled with CFR 0.152.
 */
package tools.android.networkinterfacewatcher;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import tools.android.networkinterfacewatcher.NetworkUtil;

public class NetworkInterfaceWatcher
extends BroadcastReceiver {
    private boolean enableLogcat = false;
    private boolean debounce = false;
    private long debounceMillis = 0L;
    private Handler mHandler = new Handler(new HandlerThread("NetworkInterfaceWatcher-single-thread"){
        {
            this.start();
        }
    }.getLooper());
    private static int flags = 255;

    public NetworkInterfaceWatcher() {
        this(false, 0L);
    }

    public NetworkInterfaceWatcher(boolean enableLogcat) {
        this(enableLogcat, 0L);
    }

    public NetworkInterfaceWatcher(long debounceMillis) {
        this(false, debounceMillis);
    }

    public NetworkInterfaceWatcher(boolean enableLogcat, long debounceMillis) {
        this.enableLogcat = enableLogcat;
        if (debounceMillis <= 0L) {
            this.debounce = false;
        } else if (debounceMillis < 100L) {
            this.debounce = true;
            this.debounceMillis = 100L;
        } else if (debounceMillis > 5000L) {
            this.debounce = true;
            this.debounceMillis = 5000L;
        } else {
            this.debounce = true;
            this.debounceMillis = debounceMillis;
        }
    }

    protected void networkUnavailable() {
    }

    protected void networkHardwareAvailable() {
    }

    protected void networkHardwareInvalid() {
    }

    protected void networkConnect() {
    }

    protected void networkDisconnect() {
    }

    protected void nonWifiState() {
    }

    protected void wifiState() {
    }

    public void onReceive(Context context, Intent intent) {
        this.mHandler.post((Runnable)new ContextRunnable(context){

            @Override
            public void run(Context context) {
                NetworkInterfaceWatcher.this.onReceiveIntent(context);
            }
        });
    }

    private void onReceiveIntent(Context context) {
        this.say("NetworkWatcher", "receive intent");
        if (!NetworkUtil.isNetworkHardwareAvailable(context) || !NetworkUtil.checkNetworkState(context)) {
            flags = 255;
            this.networkUnavailable();
        }
        if (!NetworkUtil.isNetworkHardwareAvailable(context)) {
            this.say("NetworkWatcher", "network hardware invalid");
            if ((flags >> 0 & 1) == 1) {
                flags = flags & 0xFE | 0xFE;
                this.networkHardwareInvalid();
            }
            return;
        }
        this.say("NetworkWatcher", "network hardware available");
        if ((flags >> 1 & 1) == 1) {
            flags = flags & 0xFC | 1;
            this.networkHardwareAvailable();
        }
        if (!NetworkUtil.checkNetworkState(context)) {
            this.say("NetworkWatcher", "network disconnect");
            if ((flags >> 2 & 1) == 1) {
                flags = flags & 0xFB | 0xF8;
                this.networkDisconnect();
            }
            return;
        }
        this.say("NetworkWatcher", "network connect");
        if ((flags >> 3 & 1) == 1) {
            flags = flags & 0xF3 | 4;
            this.networkConnect();
        }
        if (!NetworkUtil.checkWifiState(context)) {
            this.say("NetworkWatcher", "non-wifi state");
            if ((flags >> 4 & 1) == 1) {
                flags = flags & 0xEF | 0xE0;
                this.nonWifiState();
            }
            return;
        }
        this.say("NetworkWatcher", "wifi state");
        if ((flags >> 5 & 1) == 1) {
            flags = flags & 0xCF | 0x10;
            this.wifiState();
        }
    }

    protected void say(String who, String what) {
        if (this.enableLogcat) {
            Log.d((String)who, (String)what);
        }
    }

    abstract class ContextRunnable
    implements Runnable {
        Context context = null;

        public ContextRunnable(Context context) {
            this.context = context;
        }

        @Override
        public void run() {
            this.run(this.context);
        }

        public abstract void run(Context var1);
    }
}

