/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.OutputBuffer;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServerSession;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.log.Log;

public class ContextManager {
    public static final String TOMCAT_VERSION = "3.3.2 Final";
    public static final String TOMCAT_NAME = "Tomcat Web Server";
    public static final String TOMCAT_HOME = "tomcat.home";
    public static final String TOMCAT_INSTALL = "tomcat.install";
    public static final int STATE_NEW = 0;
    public static final int STATE_CONFIG = 1;
    public static final int STATE_INIT = 2;
    public static final int STATE_START = 3;
    private int state = 0;
    private Vector contextsV = new Vector();
    private Hashtable contexts = new Hashtable();
    private int debug = 0;
    private String workDir = "work";
    private String home;
    private String installDir;
    private Container defaultContainer;
    private ClassLoader parentLoader;
    private ClassLoader commonLoader;
    private ClassLoader containerLoader;
    private ClassLoader appsLoader;
    private Hashtable properties = new Hashtable();
    public static final int NOTE_COUNT = 8;
    private int[] noteId = new int[8];
    public static final int MAX_NOTES = 32;
    public static final int RESERVED = 5;
    public static final int SERVER_NOTE = 0;
    public static final int CONTAINER_NOTE = 1;
    public static final int REQUEST_NOTE = 2;
    public static final int HANDLER_NOTE = 3;
    public static final int SESSION_NOTE = 4;
    public static final int MODULE_NOTE = 5;
    public static final int REQ_RE_NOTE = 0;
    private String[][] noteName = new String[8][32];
    private Object[] notes = new Object[32];
    private Log loghelper = Log.getLog((String)"org/apache/tomcat/core", (String)"ContextManager");

    public ContextManager() {
        this.defaultContainer = this.createContainer();
        this.defaultContainer.setContext(null);
        this.defaultContainer.setContextManager(this);
        this.defaultContainer.setPath(null);
    }

    public void setHome(String home) {
        this.home = home;
        if (home != null) {
            System.getProperties().put(TOMCAT_HOME, home);
        }
    }

    public String getHome() {
        return this.home;
    }

    public String getInstallDir() {
        return this.installDir;
    }

    public void setInstallDir(String tH) {
        this.installDir = tH;
    }

    public void setWorkDir(String wd) {
        if (this.debug > 0) {
            this.log("set work dir " + wd);
        }
        this.workDir = wd;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setDebug(int level) {
        if (level != this.debug) {
            this.log("Setting debug level to " + level);
        }
        this.debug = level;
    }

    public final int getDebug() {
        return this.debug;
    }

    public String getProperty(String name) {
        return (String)this.properties.get(name);
    }

    public void setProperty(String name, String value) {
        if (name != null && value != null) {
            this.properties.put(name, value);
        }
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    public final int getState() {
        return this.state;
    }

    public void setState(int state) throws TomcatException {
        BaseInterceptor[] existingI = this.defaultContainer.getInterceptors();
        for (int i = 0; i < existingI.length; ++i) {
            existingI[i].engineState(this, state);
        }
        this.state = state;
    }

    protected void setState1(int state) {
        this.state = state;
    }

    public void setParentLoader(ClassLoader cl) {
        this.parentLoader = cl;
    }

    public ClassLoader getParentLoader() {
        return this.parentLoader;
    }

    public void setCommonLoader(ClassLoader cl) {
        this.commonLoader = cl;
    }

    public ClassLoader getCommonLoader() {
        return this.commonLoader;
    }

    public void setContainerLoader(ClassLoader cl) {
        this.containerLoader = cl;
    }

    public ClassLoader getContainerLoader() {
        return this.containerLoader;
    }

    public void setAppsLoader(ClassLoader cl) {
        this.appsLoader = cl;
    }

    public ClassLoader getAppsLoader() {
        return this.appsLoader;
    }

    public Container getContainer() {
        return this.defaultContainer;
    }

    public void setContainer(Container newDefaultContainer) {
        this.defaultContainer = newDefaultContainer;
    }

    public void addInterceptor(BaseInterceptor ri) throws TomcatException {
        Context ctx;
        ri.setContextManager(this);
        this.defaultContainer.addInterceptor(ri);
        ri.addInterceptor(this, null, ri);
        BaseInterceptor[] existingI = this.defaultContainer.getInterceptors();
        for (int i = 0; i < existingI.length; ++i) {
            if (existingI[i] == ri) continue;
            existingI[i].addInterceptor(this, null, ri);
        }
        if (this.state == 0) {
            return;
        }
        ri.engineInit(this);
        if (this.state == 1) {
            return;
        }
        Enumeration enumeration = this.getContexts();
        while (enumeration.hasMoreElements()) {
            ctx = (Context)enumeration.nextElement();
            try {
                ri.addContext(this, ctx);
            }
            catch (TomcatException ex) {
                this.log("Error adding context " + ctx + " to " + ri);
            }
        }
        enumeration = this.getContexts();
        while (enumeration.hasMoreElements()) {
            ctx = (Context)enumeration.nextElement();
            try {
                ri.contextInit(ctx);
            }
            catch (TomcatException ex) {
                this.log("Error adding context " + ctx + " to " + ri);
            }
        }
        if (this.state == 2) {
            return;
        }
        ri.engineStart(this);
    }

    public void removeInterceptor(BaseInterceptor ri) throws TomcatException {
        BaseInterceptor[] existingI = this.defaultContainer.getInterceptors();
        for (int i = 0; i < existingI.length; ++i) {
            existingI[i].removeInterceptor(this, null, ri);
        }
        ri.removeInterceptor(this, null, ri);
        this.defaultContainer.removeInterceptor(ri);
        if (this.state == 0) {
            return;
        }
        if (this.state == 3) {
            ri.engineStop(this);
        }
        if (this.state >= 2) {
            Context ctx;
            Enumeration enumeration = this.getContexts();
            while (enumeration.hasMoreElements()) {
                ctx = (Context)enumeration.nextElement();
                try {
                    ri.contextShutdown(ctx);
                }
                catch (TomcatException ex) {
                    this.log("Error shuting down context " + ctx + " to " + ri);
                }
            }
            enumeration = this.getContexts();
            while (enumeration.hasMoreElements()) {
                ctx = (Context)enumeration.nextElement();
                try {
                    ri.removeContext(this, ctx);
                }
                catch (TomcatException ex) {
                    this.log("Error removing context " + ctx + " to " + ri);
                }
            }
        }
    }

    public void init() throws TomcatException {
        Context ctx;
        if (this.state >= 1) {
            return;
        }
        if (this.debug > 0) {
            this.log("Tomcat init");
        }
        BaseInterceptor[] existingI = this.defaultContainer.getInterceptors();
        for (int i = 0; i < existingI.length; ++i) {
            existingI[i].engineInit(this);
        }
        this.setState(1);
        this.log("Tomcat configured and in stable state ");
        existingI = this.defaultContainer.getInterceptors();
        Enumeration enumeration = this.getContexts();
        while (enumeration.hasMoreElements()) {
            ctx = (Context)enumeration.nextElement();
            if (!ctx.isTrusted()) continue;
            this.fireAddContext(ctx, existingI);
        }
        enumeration = this.getContexts();
        while (enumeration.hasMoreElements()) {
            ctx = (Context)enumeration.nextElement();
            if (!ctx.isTrusted()) continue;
            try {
                ctx.init();
            }
            catch (TomcatException ex) {
                this.log("Error initializing " + ctx, ex);
            }
        }
        existingI = this.defaultContainer.getInterceptors();
        enumeration = this.getContexts();
        while (enumeration.hasMoreElements()) {
            ctx = (Context)enumeration.nextElement();
            if (ctx.isTrusted()) continue;
            this.fireAddContext(ctx, existingI);
        }
        enumeration = this.getContexts();
        while (enumeration.hasMoreElements()) {
            ctx = (Context)enumeration.nextElement();
            if (ctx.isTrusted()) continue;
            try {
                ctx.init();
            }
            catch (TomcatException ex) {
                this.log("Error initializing " + ctx, ex);
            }
        }
        this.setState(2);
    }

    private void fireAddContext(Context ctx, BaseInterceptor[] existingI) {
        ctx.setContextManager(this);
        try {
            for (int i = 0; i < existingI.length; ++i) {
                existingI[i].addContext(this, ctx);
            }
        }
        catch (TomcatException ex) {
            this.log("Error adding context " + ctx, ex);
            return;
        }
        try {
            ctx.setState(1);
            this.log("Adding  " + ctx.toString());
        }
        catch (TomcatException ex) {
            this.log("Error adding context " + ctx, ex);
            return;
        }
    }

    public void start() throws TomcatException {
        if (this.state == 0) {
            this.init();
        }
        if (this.state == 3) {
            return;
        }
        BaseInterceptor[] cI = this.defaultContainer.getInterceptors();
        for (int i = 0; i < cI.length; ++i) {
            cI[i].engineStart(this);
        }
        this.setState(3);
    }

    public void stop() throws TomcatException {
        this.setState(2);
        BaseInterceptor[] cI = this.defaultContainer.getInterceptors();
        for (int i = 0; i < cI.length; ++i) {
            cI[i].engineStop(this);
        }
    }

    public void shutdown() throws TomcatException {
        if (this.state == 3) {
            this.stop();
        }
        Enumeration enumeration = this.getContexts();
        while (enumeration.hasMoreElements()) {
            Context ctx = (Context)enumeration.nextElement();
            try {
                ctx.shutdown();
            }
            catch (TomcatException ex) {
                this.log("Error shuting down context " + ctx);
            }
        }
        BaseInterceptor[] cI = this.defaultContainer.getInterceptors();
        for (int i = 0; i < cI.length; ++i) {
            try {
                cI[i].engineShutdown(this);
                continue;
            }
            catch (Exception ex) {
                this.log("shutdown.engineShutdown", ex);
            }
        }
        this.setState(0);
    }

    public Enumeration getContexts() {
        return this.contextsV.elements();
    }

    public Enumeration getContextNames() {
        return this.contexts.keys();
    }

    public Context getContext(String name) {
        return (Context)this.contexts.get(name);
    }

    public void addContext(Context ctx) throws TomcatException {
        ctx.setContextManager(this);
        ctx.setState(0);
        this.contextsV.addElement(ctx);
        this.contexts.put(ctx.getName(), ctx);
        if (this.getState() == 0) {
            return;
        }
        try {
            BaseInterceptor[] cI = ctx.getContainer().getInterceptors();
            for (int i = 0; i < cI.length; ++i) {
                cI[i].addContext(this, ctx);
            }
            ctx.setState(1);
            this.log("Adding context " + ctx.toString());
        }
        catch (TomcatException ex) {
            this.log("Context not added " + ctx, ex);
            throw ex;
        }
    }

    public void removeContext(Context context) throws TomcatException {
        if (context == null) {
            return;
        }
        this.log("Removing context " + context.toString());
        this.contextsV.removeElement(context);
        this.contexts.remove(context.getName());
        if (this.getState() == 0) {
            return;
        }
        if (context.getState() == 0) {
            return;
        }
        if (context.getState() == 3) {
            context.shutdown();
        }
        BaseInterceptor[] cI = context.getContainer().getInterceptors();
        for (int i = 0; i < cI.length; ++i) {
            cI[i].removeContext(this, context);
        }
        context.setState(0);
    }

    public void initRequest(Request req, Response resp) {
        resp.setRequest(req);
        req.setResponse(resp);
        req.setContextManager(this);
        resp.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(Request req, Response res) {
        BaseInterceptor[] reqI222;
        if (this.state != 3) {
            req.setAttribute("javax.servlet.error.message", "Server is starting");
            this.handleStatus(req, res, 503);
        } else {
            this.internalService(req, res);
        }
        try {
            try {
                res.finish();
            }
            catch (Throwable ex) {
                BaseInterceptor[] reqI222;
                this.handleError(req, res, ex);
                Object var5_4 = null;
                if (req.getContext() == null) {
                    BaseInterceptor[] reqI2222 = this.getContainer().getInterceptors(13);
                } else {
                    reqI222 = req.getContext().getContainer().getInterceptors(12);
                }
                int i = 0;
                while (true) {
                    if (i >= reqI222.length) {
                        req.recycle();
                        res.recycle();
                        return;
                    }
                    reqI222[i].postRequest(req, res);
                    ++i;
                }
            }
            Object var5_3 = null;
            if (req.getContext() == null) {
                BaseInterceptor[] reqI2222 = this.getContainer().getInterceptors(13);
            } else {
                reqI222 = req.getContext().getContainer().getInterceptors(12);
            }
        }
        catch (Throwable throwable) {
            BaseInterceptor[] reqI222;
            Object var5_5 = null;
            if (req.getContext() == null) {
                BaseInterceptor[] reqI2222 = this.getContainer().getInterceptors(13);
            } else {
                reqI222 = req.getContext().getContainer().getInterceptors(12);
            }
            int i = 0;
            while (true) {
                if (i >= reqI222.length) {
                    req.recycle();
                    res.recycle();
                    throw throwable;
                }
                reqI222[i].postRequest(req, res);
                ++i;
            }
        }
        for (int i = 0; i < reqI222.length; ++i) {
            reqI222[i].postRequest(req, res);
        }
        req.recycle();
        res.recycle();
    }

    private void internalService(Request req, Response res) {
        try {
            int status = res.getStatus();
            if (status >= 400) {
                if (this.debug > 0) {
                    this.log("Error reading request " + req + " " + status);
                }
                this.handleStatus(req, res, status);
                return;
            }
            status = this.processRequest(req);
            if (status != 0) {
                if (this.debug > 0) {
                    this.log("Error mapping the request " + req + " " + status);
                }
                this.handleStatus(req, res, status);
                return;
            }
            if (req.getHandler() == null) {
                status = 404;
                if (this.debug > 0) {
                    this.log("No handler for request " + req + " " + status);
                }
                this.handleStatus(req, res, status);
                return;
            }
            Container sct = req.getSecurityContext();
            if (sct != null) {
                status = 0;
                BaseInterceptor[] reqI = req.getContext().getContainer().getInterceptors(4);
                for (int i = 0; i < reqI.length && (status = reqI[i].authorize(req, res, sct.getRoles())) == -1; ++i) {
                }
            }
            if (status != 0) {
                if (this.debug > 0) {
                    this.log("Unauthorized " + req + " " + status);
                }
                if (status == -1) {
                    status = 401;
                }
                this.handleStatus(req, res, status);
                return;
            }
            req.getHandler().service(req, res);
        }
        catch (Throwable t) {
            this.handleError(req, res, t);
        }
    }

    public int processRequest(Request req) {
        int i;
        if (this.debug > 9) {
            this.log("Before processRequest(): " + req.toString());
        }
        int status = 0;
        BaseInterceptor[] ri = this.defaultContainer.getInterceptors(0);
        for (i = 0; i < ri.length; ++i) {
            status = ri[i].postReadRequest(req);
            if (status == 0) continue;
            return status;
        }
        ri = this.defaultContainer.getInterceptors(2);
        for (i = 0; i < ri.length; ++i) {
            status = ri[i].contextMap(req);
            if (status == 0) continue;
            return status;
        }
        req.setState(2);
        if (req.getContext() == null) {
            req.setAttribute("javax.servlet.error.message", "No context found");
        }
        if (req.getContext().getState() != 3) {
            req.setAttribute("javax.servlet.error.message", "Context " + req.getContext() + " not ready");
            return 503;
        }
        ri = req.getContext().getContainer().getInterceptors(1);
        for (i = 0; i < ri.length; ++i) {
            if (this.debug > 1) {
                this.log("RequestMap " + ri[i]);
            }
            if ((status = ri[i].requestMap(req)) == 0) continue;
            return status;
        }
        req.setState(3);
        if (this.debug > 9) {
            this.log("After processRequest(): " + req.toString());
        }
        return 0;
    }

    public Request createRequest(Context ctx, String urlPath) {
        String contextPath = ctx.getPath();
        String origPath = urlPath;
        if (!"".equals(contextPath) && !"/".equals(contextPath)) {
            urlPath = urlPath.startsWith("/") ? contextPath + urlPath : contextPath + "/" + urlPath;
        } else if (!urlPath.startsWith("/")) {
            urlPath = "/" + urlPath;
        }
        if (this.debug > 4) {
            this.log("createRequest " + origPath + " " + urlPath);
        }
        Request req = this.createSubRequest(ctx.getHost(), urlPath);
        req.setContext(ctx);
        return req;
    }

    private Request createSubRequest(String host, String urlPath) {
        String queryString = null;
        int i = urlPath.indexOf("?");
        int len = urlPath.length();
        if (i > -1) {
            if (i < len) {
                queryString = urlPath.substring(i + 1, urlPath.length());
            }
            urlPath = urlPath.substring(0, i);
        }
        Request lr = this.createRequest();
        Response res = this.createResponse(lr);
        lr.setContextManager(this);
        lr.setResponse(res);
        res.setRequest(lr);
        lr.requestURI().setString(urlPath);
        lr.queryString().setString(queryString);
        if (host != null) {
            lr.serverName().setString(host);
        }
        return lr;
    }

    public Context getContext(Context base, String path) {
        if (!path.startsWith("/")) {
            return null;
        }
        Request lr = this.createSubRequest(base.getHost(), path);
        this.processRequest(lr);
        return lr.getContext();
    }

    public void handleStatus(Request req, Response res, int code) {
        if (code != 0) {
            res.setStatus(code);
        }
        BaseInterceptor[] ri = req.getContext() == null ? this.getContainer().getInterceptors(13) : req.getContext().getContainer().getInterceptors(13);
        for (int i = 0; i < ri.length; ++i) {
            int status = ri[i].handleError(req, res, null);
            if (status == 0) continue;
            return;
        }
    }

    public void handleError(Request req, Response res, Throwable t) {
        BaseInterceptor[] ri = req.getContext() == null ? this.getContainer().getInterceptors(13) : req.getContext().getContainer().getInterceptors(13);
        if (ri == null) {
            this.log("handleError with no error handlers " + req + " " + req.getContext());
            return;
        }
        for (int i = 0; i < ri.length; ++i) {
            int status = ri[i].handleError(req, res, t);
            if (status == 0) continue;
            return;
        }
    }

    public synchronized int getNoteId(int noteType, String name) throws TomcatException {
        for (int i = 0; i < this.noteId[noteType]; ++i) {
            if (!name.equals(this.noteName[noteType][i])) continue;
            return i;
        }
        if (this.noteId[noteType] >= 32) {
            throw new TomcatException("Too many notes ");
        }
        if (this.noteId[noteType] < 5) {
            this.noteId[noteType] = 5;
        }
        this.noteName[noteType][this.noteId[noteType]] = name;
        int n = noteType;
        int n2 = this.noteId[n];
        this.noteId[n] = n2 + 1;
        return n2;
    }

    public String getNoteName(int noteType, int noteId) {
        return this.noteName[noteType][noteId];
    }

    public final void setNote(int pos, Object value) {
        this.notes[pos] = value;
    }

    public final Object getNote(int pos) {
        return this.notes[pos];
    }

    public Object getNote(String name) throws TomcatException {
        int id = this.getNoteId(0, name);
        return this.getNote(id);
    }

    public void setNote(String name, Object value) throws TomcatException {
        int id = this.getNoteId(0, name);
        this.setNote(id, value);
    }

    public Log getLog() {
        return this.loghelper;
    }

    public void setLog(Log log) {
        this.loghelper = log;
    }

    public void log(String msg) {
        this.loghelper.log(msg);
    }

    public void log(String msg, Throwable t) {
        this.loghelper.log(msg, t);
    }

    public void log(String msg, int level) {
        this.loghelper.log(msg, level);
    }

    public void log(String msg, Throwable t, int level) {
        this.loghelper.log(msg, t, level);
    }

    public Context createContext() {
        return new Context();
    }

    public Request createRequest() {
        Request req = new Request();
        return req;
    }

    public Response createResponse(Request req) {
        return new Response();
    }

    public Container createContainer() {
        return new Container();
    }

    public OutputBuffer createOutputBuffer() {
        return new OutputBuffer();
    }

    public OutputBuffer createOutputBuffer(int size) {
        return new OutputBuffer(size);
    }

    public ServerSession createServerSession() {
        ServerSession ss = new ServerSession();
        ss.setContextManager(this);
        return ss;
    }
}

