/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.File;
import java.net.FileNameMap;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Handler;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.http.MimeMap;
import org.apache.tomcat.util.log.Log;

public class Context {
    public static final String ATTRIB_PREFIX = "org.apache.tomcat";
    public static final String ATTRIB_PROTECTION_DOMAIN = "org.apache.tomcat.protection_domain";
    public static final String ATTRIB_REAL_CONTEXT = "org.apache.tomcat.context";
    public static final int STATE_NEW = 0;
    public static final int STATE_ADDED = 1;
    public static final int STATE_DISABLED = 2;
    public static final int STATE_READY = 3;
    private String name;
    private String path = "";
    private String docBase;
    private String absPath;
    private Hashtable properties = new Hashtable();
    private int state = 0;
    private ContextManager contextM;
    private Object contextFacade;
    private int debug = 0;
    private boolean reloadable = true;
    private Hashtable attributes = new Hashtable();
    private File workDir;
    private Hashtable servlets = new Hashtable();
    private Hashtable initializationParameters = new Hashtable();
    private Vector welcomeFilesV = new Vector();
    private String[] welcomeFiles = null;
    private Hashtable errorPages = new Hashtable();
    private MimeMap mimeTypes = new MimeMap();
    private int sessionTimeOut = -1;
    private boolean isDistributable = false;
    private Hashtable mappings = new Hashtable();
    private Hashtable constraints = new Hashtable();
    private Hashtable containers = new Hashtable();
    private Container defaultContainer = null;
    private String authMethod;
    private String realmName;
    private String formLoginPage;
    private String formErrorPage;
    private String engineHeader = null;
    private String vhost = null;
    private String vhostip = null;
    private Vector vhostAliases = new Vector();
    private boolean trusted = false;
    private static Log defaultContextLog = Log.getLog((String)"org/apache/tomcat/core", (String)"Context");
    private Log loghelper = defaultContextLog;
    private Log loghelperServlet;
    private String apiLevel = "2.2";
    private ClassLoader classLoader;
    private Vector classPath = new Vector();
    private boolean reload;
    private String description = null;
    private String icon = null;
    private Hashtable tagLibs = new Hashtable();
    private Hashtable envEntryTypes = new Hashtable();
    private Hashtable envEntryValues = new Hashtable();
    private int attributeInfo;

    public Context() {
        this.defaultContainer = new Container();
        this.defaultContainer.setContext(this);
        this.defaultContainer.setPath(null);
    }

    public void addContainer(Container ct) throws TomcatException {
        BaseInterceptor[] cI = this.defaultContainer.getInterceptors();
        for (int i = 0; i < cI.length; ++i) {
            cI[i].addContainer(ct);
        }
    }

    public void addServletMapping(String path, String servletName) throws TomcatException {
        if (this.mappings.get(path) != null) {
            this.log("Removing duplicate " + path + " -> " + this.mappings.get(path));
            this.mappings.remove(path);
            Container ct = (Container)this.containers.get(path);
            this.removeContainer(ct);
        }
        Handler sw = this.getServletByName(servletName);
        Container map = this.contextM.createContainer();
        map.setContext(this);
        map.setHandlerName(servletName);
        map.setHandler(sw);
        map.setPath(path);
        BaseInterceptor[] cI = this.defaultContainer.getInterceptors();
        for (int i = 0; i < cI.length; ++i) {
            cI[i].addContainer(map);
        }
        sw = this.getServletByName(servletName);
        if (sw == null) {
            this.removeContainer(map);
            throw new TomcatException("Mapping with invalid servlet  " + path + " " + servletName);
        }
        this.containers.put(path, map);
        this.mappings.put(path, sw);
        if (this.debug > 4) {
            this.log("Map " + path + " -> " + this.mappings.get(path));
        }
    }

    public void addSecurityConstraint(String[] path, String[] methods, String[] roles, String transport) throws TomcatException {
        for (int i = 0; i < path.length; ++i) {
            Container ct = this.contextM.createContainer();
            ct.setContext(this);
            ct.setTransport(transport);
            ct.setRoles(roles);
            ct.setPath(path[i]);
            ct.setMethods(methods);
            this.constraints.put(path[i], ct);
            BaseInterceptor[] cI = ct.getInterceptors();
            for (int j = 0; j < cI.length; ++j) {
                cI[j].addContainer(ct);
            }
        }
    }

    public boolean allowAttribute(String name) {
        if (this.isTrusted()) {
            return true;
        }
        this.log("Attempt to access internal attribute in untrusted app", null, 1);
        return false;
    }

    public Object getFacade() {
        return this.contextFacade;
    }

    public void setFacade(Object obj) {
        if (this.contextFacade != null) {
            this.log("Changing facade " + this.contextFacade + " " + obj);
        }
        this.contextFacade = obj;
    }

    public final ContextManager getContextManager() {
        return this.contextM;
    }

    public void setContextManager(ContextManager cm) {
        if (this.contextM != null) {
            return;
        }
        this.contextM = cm;
        if (this.defaultContainer == null) {
            this.defaultContainer = this.contextM.createContainer();
            this.defaultContainer.setContext(this);
            this.defaultContainer.setPath(null);
        }
        try {
            this.attributeInfo = cm.getNoteId(2, "req.attribute");
        }
        catch (TomcatException ex) {
            ex.printStackTrace();
        }
    }

    protected void setContextManager1(ContextManager cm) {
        this.contextM = cm;
    }

    public Container getContainer() {
        return this.defaultContainer;
    }

    public final int getState() {
        return this.state;
    }

    public void setState(int state) throws TomcatException {
        BaseInterceptor[] csI = this.getContainer().getInterceptors();
        for (int i = 0; i < csI.length; ++i) {
            csI[i].contextState(this, state);
        }
        if (this.state == 0 && state == 1) {
            BaseInterceptor[] cI = this.getContainer().getInterceptors();
            for (int i = 0; i < cI.length; ++i) {
                if (cI[i].getContext() != this) continue;
                try {
                    cI[i].addInterceptor(this.contextM, this, cI[i]);
                    BaseInterceptor[] existingI = this.defaultContainer.getInterceptors();
                    for (int j = 0; j < existingI.length; ++j) {
                        if (existingI[j] == cI[i]) continue;
                        existingI[j].addInterceptor(this.contextM, this, cI[i]);
                    }
                    cI[i].setContextManager(this.contextM);
                    cI[i].engineInit(this.contextM);
                    cI[i].addContext(this.contextM, this);
                    continue;
                }
                catch (TomcatException ex) {
                    this.log("Error adding module " + cI[i] + " to " + this, ex);
                }
            }
        }
        this.state = state;
    }

    protected void setState1(int state) {
        this.state = state;
    }

    public void init() throws TomcatException {
        if (this.state == 3) {
            this.log("Already initialized ");
            return;
        }
        this.getContainer().resetInterceptorCache(16);
        if (this.contextM == null || this.contextM.getState() == 0) {
            this.log("ERROR: ContextManager is not yet initialized ");
            return;
        }
        BaseInterceptor[] cI = this.getContainer().getInterceptors();
        for (int i = 0; i < cI.length; ++i) {
            cI[i].contextInit(this);
        }
        this.setState(3);
    }

    public void shutdown() throws TomcatException {
        this.setState(2);
        BaseInterceptor[] cI = this.getContainer().getInterceptors();
        for (int i = 0; i < cI.length; ++i) {
            cI[i].contextShutdown(this);
        }
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        this.name = (this.vhost == null ? "DEFAULT:" : this.vhost + ":") + ("".equals(this.path) ? "/ROOT" : this.path);
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        if ("/".equals(path)) {
            path = "";
        }
        this.path = path;
        this.loghelper = Log.getLog((String)"org/apache/tomcat/core", (String)("Ctx(" + this.getId() + ") "));
        this.name = null;
    }

    public void setHost(String h) {
        this.vhost = h;
        this.name = null;
    }

    public String getHost() {
        return this.vhost;
    }

    public final void setHostAddress(String ip) {
        this.vhostip = ip;
    }

    public final String getHostAddress() {
        return this.vhostip;
    }

    public void setDocBase(String docB) {
        this.docBase = docB;
    }

    public String getDocBase() {
        return this.docBase;
    }

    public String getAbsolutePath() {
        return this.absPath;
    }

    public void setAbsolutePath(String s) {
        this.absPath = s;
    }

    public String getProperty(String n) {
        return (String)this.properties.get(n);
    }

    public void setProperty(String n, String v) {
        this.properties.put(n, v);
    }

    public void setReloadable(boolean b) {
        this.reloadable = b;
    }

    public boolean getReloadable() {
        return this.reloadable;
    }

    public void setServletAPI(String s) {
        if (s == null) {
            return;
        }
        if (s.endsWith("23") || s.endsWith("2.3")) {
            this.apiLevel = "2.3";
        } else if (s.endsWith("22") || s.endsWith("2.2")) {
            this.apiLevel = "2.2";
        } else {
            this.log("Unknown API " + s);
        }
    }

    public String getServletAPI() {
        return this.apiLevel;
    }

    public String[] getWelcomeFiles() {
        if (this.welcomeFiles == null) {
            this.welcomeFiles = new String[this.welcomeFilesV.size()];
            for (int i = 0; i < this.welcomeFiles.length; ++i) {
                this.welcomeFiles[i] = (String)this.welcomeFilesV.elementAt(i);
            }
        }
        return this.welcomeFiles;
    }

    public void addWelcomeFile(String s) {
        if (s == null) {
            return;
        }
        if ((s = s.trim()).length() == 0) {
            return;
        }
        this.welcomeFiles = null;
        this.welcomeFilesV.addElement(s);
    }

    public String getInitParameter(String name) {
        return (String)this.initializationParameters.get(name);
    }

    public void addInitParameter(String name, String value) {
        this.initializationParameters.put(name, value);
    }

    public Enumeration getInitParameterNames() {
        return this.initializationParameters.keys();
    }

    public Object getAttribute(String name) {
        Object o = this.attributes.get(name);
        if (o != null) {
            return o;
        }
        if (name.equals(ATTRIB_REAL_CONTEXT)) {
            if (!this.allowAttribute(name)) {
                return null;
            }
            return this;
        }
        BaseInterceptor[] reqI = this.getContainer().getInterceptors(14);
        for (int i = 0; i < reqI.length && (o = reqI[i].getInfo(this, null, this.attributeInfo, name)) == null; ++i) {
        }
        return o;
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public void setAttribute(String name, Object object) {
        this.attributes.put(name, object);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void addTaglib(String uri, String location) {
        this.tagLibs.put(uri, location);
    }

    public String getTaglibLocation(String uri) {
        return (String)this.tagLibs.get(uri);
    }

    public Enumeration getTaglibs() {
        return this.tagLibs.keys();
    }

    public void addEnvEntry(String name, String type, String value, String description) {
        this.log("Add env-entry " + name + "  " + type + " " + value + " " + description);
        if (name == null || type == null) {
            throw new IllegalArgumentException();
        }
        this.envEntryTypes.put(name, type);
        if (value != null) {
            this.envEntryValues.put(name, value);
        }
    }

    public String getEnvEntryType(String name) {
        return (String)this.envEntryTypes.get(name);
    }

    public String getEnvEntryValue(String name) {
        return (String)this.envEntryValues.get(name);
    }

    public Enumeration getEnvEntries() {
        return this.envEntryTypes.keys();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public boolean isDistributable() {
        return this.isDistributable;
    }

    public void setDistributable(boolean isDistributable) {
        this.isDistributable = isDistributable;
    }

    public int getSessionTimeOut() {
        return this.sessionTimeOut;
    }

    public void setSessionTimeOut(int sessionTimeOut) {
        this.sessionTimeOut = sessionTimeOut;
    }

    public FileNameMap getMimeMap() {
        return this.mimeTypes;
    }

    public void addContentType(String ext, String type) {
        this.mimeTypes.addContentType(ext, type);
    }

    public String getErrorPage(int errorCode) {
        return this.getErrorPage(String.valueOf(errorCode));
    }

    public void addErrorPage(String errorType, String value) {
        this.errorPages.put(errorType, value);
    }

    public String getErrorPage(String errorCode) {
        return (String)this.errorPages.get(errorCode);
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getFormLoginPage() {
        return this.formLoginPage;
    }

    public String getFormErrorPage() {
        return this.formErrorPage;
    }

    public void setFormLoginPage(String page) {
        this.formLoginPage = page;
    }

    public void setFormErrorPage(String page) {
        this.formErrorPage = page;
    }

    public void setLoginConfig(String authMethod, String realmName, String formLoginPage, String formErrorPage) {
        this.authMethod = authMethod;
        this.realmName = realmName;
        this.formLoginPage = formLoginPage;
        this.formErrorPage = formErrorPage;
    }

    public Enumeration getContainers() {
        return this.containers.elements();
    }

    public Enumeration getContainerLocations() {
        return this.containers.keys();
    }

    public Container getContainer(String path) {
        return (Container)this.containers.get(path);
    }

    public void removeContainer(Container ct) throws TomcatException {
        this.containers.remove(ct.getPath());
        BaseInterceptor[] cI = ct.getInterceptors();
        for (int i = 0; i < cI.length; ++i) {
            cI[i].removeContainer(ct);
        }
    }

    public void addServlet(Handler wrapper) throws TomcatException {
        this.addHandler(wrapper);
    }

    public void addHandler(Handler wrapper) throws TomcatException {
        wrapper.setState(1);
        String name = wrapper.getName();
        wrapper.setContextManager(this.contextM);
        if (this.getServletByName(name) != null) {
            this.log("Removing duplicate servlet " + name + " " + wrapper);
            this.removeServletByName(name);
        }
        if (this.debug > 5) {
            this.log("Adding servlet=" + name + "-> " + wrapper);
        }
        BaseInterceptor[] cI = this.defaultContainer.getInterceptors();
        for (int i = 0; i < cI.length; ++i) {
            cI[i].addHandler(wrapper);
        }
        this.servlets.put(name, wrapper);
    }

    public void removeHandler(Handler handler) throws TomcatException {
        if (handler == null) {
            return;
        }
        BaseInterceptor[] cI = this.defaultContainer.getInterceptors();
        for (int i = 0; i < cI.length; ++i) {
            cI[i].removeHandler(handler);
        }
        this.servlets.remove(handler.getName());
        handler.setState(0);
    }

    public void removeServletByName(String servletName) throws TomcatException {
        Handler h = this.getServletByName(servletName);
        this.removeHandler(h);
    }

    public Handler getServletByName(String servletName) {
        return (Handler)this.servlets.get(servletName);
    }

    public Enumeration getServletNames() {
        return this.servlets.keys();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
    }

    public void addClassPath(URL url) {
        this.classPath.addElement(url);
    }

    public URL[] getClassPath() {
        int i;
        if (this.classPath == null) {
            return new URL[0];
        }
        URL[] serverCP = new URL[]{};
        URL[] urls = new URL[this.classPath.size() + serverCP.length];
        int pos = 0;
        for (i = 0; i < serverCP.length; ++i) {
            urls[pos++] = serverCP[i];
        }
        for (i = 0; i < this.classPath.size(); ++i) {
            urls[pos++] = (URL)this.classPath.elementAt(i);
        }
        return urls;
    }

    public void setDebug(int level) {
        if (level != this.debug) {
            this.log("Setting debug to " + level);
        }
        this.debug = level;
    }

    public int getDebug() {
        return this.debug;
    }

    public String toString() {
        return this.getName();
    }

    public String getId() {
        return (this.vhost == null ? "" : this.vhost + ":") + this.path;
    }

    public void log(String msg) {
        this.loghelper.log(msg);
    }

    public void log(String msg, Throwable t) {
        this.loghelper.log(msg, t);
    }

    public void log(String msg, Throwable t, int level) {
        this.loghelper.log(msg, t, level);
    }

    public void logServlet(String msg, Throwable t) {
        if (this.loghelperServlet == null) {
            this.loghelperServlet = this.loghelper;
        }
        if (t == null) {
            this.loghelperServlet.log(msg);
        } else {
            this.loghelperServlet.log(msg, t);
        }
    }

    public void setLog(Log logger) {
        this.loghelper = logger;
    }

    public void setServletLog(Log logger) {
        this.loghelperServlet = logger;
    }

    public Log getLog() {
        return this.loghelper;
    }

    public Log getServletLog() {
        return this.loghelperServlet;
    }

    public void setEngineHeader(String s) {
        this.engineHeader = s;
    }

    public String getEngineHeader() {
        return this.engineHeader;
    }

    public void setWorkDir(String workDir) {
        this.workDir = new File(workDir);
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public void addHostAlias(String alias) {
        this.vhostAliases.addElement(alias);
    }

    public Enumeration getHostAliases() {
        return this.vhostAliases.elements();
    }

    public void setTrusted(boolean t) {
        this.trusted = t;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public void addInterceptor(BaseInterceptor ri) throws TomcatException {
        ri.setContext(this);
        this.defaultContainer.addInterceptor(ri);
        if (this.getState() == 0) {
            return;
        }
        ri.addInterceptor(this.contextM, this, ri);
        BaseInterceptor[] existingI = this.defaultContainer.getInterceptors();
        for (int i = 0; i < existingI.length; ++i) {
            if (existingI[i] == ri) continue;
            existingI[i].addInterceptor(this.contextM, this, ri);
        }
        ri.setContextManager(this.contextM);
        ri.engineInit(this.contextM);
        ri.addContext(this.contextM, this);
        if (this.getState() == 1) {
            return;
        }
        ri.contextInit(this);
        if (this.contextM.getState() == 3) {
            ri.engineStart(this.contextM);
        }
    }
}

