/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.puretls;

import COM.claymoresystems.cert.X509Cert;
import COM.claymoresystems.ptls.SSLSocket;
import COM.claymoresystems.sslg.SSLPolicyInt;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Vector;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.net.SSLSupport;

class PureTLSSupport
implements SSLSupport {
    private SSLSocket ssl;

    PureTLSSupport(SSLSocket sock) {
        this.ssl = sock;
    }

    public String getCipherSuite() throws IOException {
        int cs = this.ssl.getCipherSuite();
        return SSLPolicyInt.getCipherSuiteName((int)cs);
    }

    public Object[] getPeerCertificateChain() throws IOException {
        return this.getPeerCertificateChain(false);
    }

    public Object[] getPeerCertificateChain(boolean force) throws IOException {
        Vector v = this.ssl.getCertificateChain();
        if (v == null && force) {
            SSLPolicyInt policy = new SSLPolicyInt();
            policy.requireClientAuth(true);
            policy.handshakeOnConnect(false);
            policy.waitOnClose(false);
            this.ssl.renegotiate(policy);
            v = this.ssl.getCertificateChain();
        }
        if (v == null) {
            return null;
        }
        Object[] chain = new X509Certificate[v.size()];
        try {
            int i = 1;
            while (i <= v.size()) {
                byte[] buffer = ((X509Cert)v.elementAt(v.size() - i)).getDER();
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                chain[i] = (X509Certificate)cf.generateCertificate(stream);
                ++i;
            }
        }
        catch (CertificateException e) {
            throw new IOException("JDK's broken cert handling can't parse this certificate (which PureTLS likes");
        }
        return chain;
    }

    public Integer getKeySize() throws IOException {
        int cs = this.ssl.getCipherSuite();
        String cipherSuite = SSLPolicyInt.getCipherSuiteName((int)cs);
        int size = 0;
        int i = 0;
        while (i < SSLSupport.ciphers.length) {
            if (cipherSuite.indexOf(SSLSupport.ciphers[i].phrase) >= 0) {
                size = SSLSupport.ciphers[i].keySize;
                break;
            }
            ++i;
        }
        Integer keySize = new Integer(size);
        return keySize;
    }

    public String getSessionId() throws IOException {
        byte[] ssl_session = this.ssl.getSessionID();
        if (ssl_session == null) {
            return null;
        }
        return HexUtils.convert(ssl_session);
    }
}

