/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.http11.Http11Processor;
import org.apache.tomcat.util.net.PoolTcpEndpoint;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.apache.tomcat.util.net.TcpConnection;
import org.apache.tomcat.util.net.TcpConnectionHandler;
import org.apache.tomcat.util.res.StringManager;

public class Http11Protocol
implements ProtocolHandler {
    protected static StringManager sm = StringManager.getManager((String)"org.apache.coyote.http11");
    Adapter adapter;
    Http11ConnectionHandler cHandler = new Http11ConnectionHandler(this);
    protected PoolTcpEndpoint ep = new PoolTcpEndpoint();
    protected boolean secure;
    protected ServerSocketFactory socketFactory;
    protected SSLImplementation sslImplementation;
    protected Hashtable attributes = new Hashtable();
    protected String socketFactoryName = null;
    protected String sslImplementationName = null;
    private int maxKeepAliveRequests = 100;
    private int timeout = 300000;
    private String reportedname;
    private int socketCloseDelay = -1;
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$coyote$http11$Http11Protocol == null ? (class$org$apache$coyote$http11$Http11Protocol = Http11Protocol.class$("org.apache.coyote.http11.Http11Protocol")) : class$org$apache$coyote$http11$Http11Protocol));
    static /* synthetic */ Class class$org$apache$coyote$http11$Http11Protocol;

    public void setAttribute(String name, Object value) {
        log.debug((Object)sm.getString("http11protocol.setattribute", (Object)name, value));
        this.attributes.put(name, value);
    }

    public Object getAttribute(String key) {
        return null;
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public void init() throws Exception {
        this.ep.setConnectionHandler((TcpConnectionHandler)this.cHandler);
        try {
            this.checkSocketFactory();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("http11protocol.socketfactory.initerror"), (Throwable)ex);
            throw ex;
        }
        if (this.socketFactory != null) {
            Enumeration attE = this.attributes.keys();
            while (attE.hasMoreElements()) {
                String key = (String)attE.nextElement();
                Object v = this.attributes.get(key);
                this.socketFactory.setAttribute(key, v);
            }
        }
        try {
            this.ep.initEndpoint();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("http11protocol.endpoint.initerror"), (Throwable)ex);
            throw ex;
        }
        log.info((Object)sm.getString("http11protocol.init", (Object)("" + this.ep.getPort())));
    }

    public void start() throws Exception {
        try {
            this.ep.startEndpoint();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("http11protocol.endpoint.starterror"), (Throwable)ex);
            throw ex;
        }
        log.info((Object)sm.getString("http11protocol.start", (Object)("" + this.ep.getPort())));
    }

    public void destroy() throws Exception {
        this.ep.stopEndpoint();
    }

    public void setPools(boolean t) {
        this.ep.setPoolOn(t);
        this.setAttribute("pools", "" + t);
    }

    public void setMaxThreads(int maxThreads) {
        this.ep.setMaxThreads(maxThreads);
        this.setAttribute("maxThreads", "" + maxThreads);
    }

    public void setMaxSpareThreads(int maxThreads) {
        this.ep.setMaxSpareThreads(maxThreads);
        this.setAttribute("maxSpareThreads", "" + maxThreads);
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.ep.setMinSpareThreads(minSpareThreads);
        this.setAttribute("minSpareThreads", "" + minSpareThreads);
    }

    public void setBacklog(int i) {
        this.ep.setBacklog(i);
        this.setAttribute("backlog", "" + i);
    }

    public void setPort(int port) {
        this.ep.setPort(port);
        this.setAttribute("port", "" + port);
    }

    public void setAddress(InetAddress ia) {
        this.ep.setAddress(ia);
        this.setAttribute("address", "" + ia);
    }

    public void setHostName(String name) {
    }

    public void setSocketFactory(String valueS) {
        this.socketFactoryName = valueS;
        this.setAttribute("socketFactory", valueS);
    }

    public void setSSLImplementation(String valueS) {
        this.sslImplementationName = valueS;
        this.setAttribute("sslImplementation", valueS);
    }

    public void setTcpNoDelay(boolean b) {
        this.ep.setTcpNoDelay(b);
        this.setAttribute("tcpNoDelay", "" + b);
    }

    public void setSoLinger(int i) {
        this.ep.setSoLinger(i);
        this.setAttribute("soLinger", "" + i);
    }

    public void setSoTimeout(int i) {
        this.ep.setSoTimeout(i);
        this.setAttribute("soTimeout", "" + i);
    }

    public void setServerSoTimeout(int i) {
        this.ep.setServerSoTimeout(i);
        this.setAttribute("serverSoTimeout", "" + i);
    }

    public void setKeystore(String k) {
        this.setAttribute("keystore", k);
    }

    public void setKeypass(String k) {
        this.attributes.put("keypass", k);
    }

    public void setKeytype(String k) {
        this.setAttribute("keystoreType", k);
    }

    public void setClientauth(String k) {
        this.setAttribute("clientauth", k);
    }

    public void setProtocol(String k) {
        this.setAttribute("protocol", k);
    }

    public void setAlgorithm(String k) {
        this.setAttribute("algorithm", k);
    }

    public void setSecure(boolean b) {
        this.secure = b;
        this.setAttribute("secure", "" + b);
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.maxKeepAliveRequests = mkar;
        this.setAttribute("maxKeepAliveRequests", "" + mkar);
    }

    public void setSocketCloseDelay(int d) {
        this.socketCloseDelay = d;
        this.setAttribute("socketCloseDelay", "" + d);
    }

    private static ServerSocketFactory string2SocketFactory(String val) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> chC = Class.forName(val);
        return (ServerSocketFactory)chC.newInstance();
    }

    public void setTimeout(int timeouts) {
        this.timeout = timeouts * 1000;
        this.setAttribute("timeout", "" + timeouts);
    }

    public void setReportedname(String reportedName) {
        this.reportedname = reportedName;
    }

    private void checkSocketFactory() throws Exception {
        if (this.secure) {
            this.sslImplementation = SSLImplementation.getInstance((String)this.sslImplementationName);
            this.socketFactory = this.sslImplementation.getServerSocketFactory();
            this.ep.setServerSocketFactory(this.socketFactory);
        }
        if (this.socketFactoryName != null) {
            this.socketFactory = Http11Protocol.string2SocketFactory(this.socketFactoryName);
            this.ep.setServerSocketFactory(this.socketFactory);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Http11ConnectionHandler
    implements TcpConnectionHandler {
        Http11Protocol proto;

        Http11ConnectionHandler(Http11Protocol proto) {
            this.proto = proto;
        }

        public void setAttribute(String name, Object value) {
        }

        public void setServer(Object o) {
        }

        public Object[] init() {
            Object[] thData = new Object[3];
            Http11Processor processor = new Http11Processor();
            processor.setAdapter(this.proto.adapter);
            processor.setMaxKeepAliveRequests(this.proto.maxKeepAliveRequests);
            processor.setTimeout(this.proto.timeout);
            thData[1] = processor;
            thData[2] = null;
            return thData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processConnection(TcpConnection connection, Object[] thData) {
            Socket socket = null;
            Http11Processor processor = null;
            try {
                processor = (Http11Processor)thData[1];
                if (processor instanceof ActionHook) {
                    processor.action(ActionCode.ACTION_START, null);
                }
                socket = connection.getSocket();
                InputStream in = socket.getInputStream();
                OutputStream out = socket.getOutputStream();
                if (this.proto.secure) {
                    SSLSupport sslSupport = null;
                    if (this.proto.sslImplementation != null) {
                        sslSupport = this.proto.sslImplementation.getSSLSupport(socket);
                    }
                    processor.setSSLSupport(sslSupport);
                } else {
                    processor.setSSLSupport(null);
                }
                processor.setSocket(socket);
                processor.process(in, out);
                if (this.proto.socketCloseDelay >= 0) {
                    try {
                        Thread.sleep(this.proto.socketCloseDelay);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                TcpConnection.shutdownInput((Socket)socket);
            }
            catch (SocketException e) {
                log.info((Object)sm.getString("http11protocol.proto.socketexception.info"));
                log.debug((Object)sm.getString("http11protocol.proto.socketexception.debug"), (Throwable)e);
            }
            catch (IOException e) {
                log.info((Object)sm.getString("http11protocol.proto.ioexception.info"));
                log.debug((Object)sm.getString("http11protocol.proto.ioexception.debug"), (Throwable)e);
            }
            catch (Throwable e) {
                log.error((Object)sm.getString("http11protocol.proto.error"), e);
            }
            finally {
                if (processor instanceof ActionHook) {
                    processor.action(ActionCode.ACTION_STOP, null);
                }
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e) {}
            }
        }
    }
}

