/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ssi;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.ssi.ByteArrayServletOutputStream;
import org.apache.catalina.ssi.ResponseIncludeWrapper;
import org.apache.catalina.ssi.SSIExternalResolver;
import org.apache.catalina.ssi.SSIServletRequestUtil;

public class SSIServletExternalResolver
implements SSIExternalResolver {
    protected final String[] VARIABLE_NAMES = new String[]{"AUTH_TYPE", "CONTENT_LENGTH", "CONTENT_TYPE", "DOCUMENT_NAME", "DOCUMENT_URI", "GATEWAY_INTERFACE", "PATH_INFO", "PATH_TRANSLATED", "QUERY_STRING", "QUERY_STRING_UNESCAPED", "REMOTE_ADDR", "REMOTE_HOST", "REMOTE_USER", "REQUEST_METHOD", "SCRIPT_NAME", "SERVER_NAME", "SERVER_PORT", "SERVER_PROTOCOL", "SERVER_SOFTWARE"};
    protected HttpServlet servlet;
    protected HttpServletRequest req;
    protected HttpServletResponse res;
    protected boolean isVirtualWebappRelative;
    protected int debug;
    protected String inputEncoding;

    public SSIServletExternalResolver(HttpServlet servlet, HttpServletRequest req, HttpServletResponse res, boolean isVirtualWebappRelative, int debug, String inputEncoding) {
        this.servlet = servlet;
        this.req = req;
        this.res = res;
        this.isVirtualWebappRelative = isVirtualWebappRelative;
        this.debug = debug;
        this.inputEncoding = inputEncoding;
    }

    public void log(String message, Throwable throwable) {
        if (throwable != null) {
            this.servlet.log(message, throwable);
        } else {
            this.servlet.log(message);
        }
    }

    public void addVariableNames(Collection variableNames) {
        for (int i = 0; i < this.VARIABLE_NAMES.length; ++i) {
            String variableName = this.VARIABLE_NAMES[i];
            String variableValue = this.getVariableValue(variableName);
            if (variableValue == null) continue;
            variableNames.add(variableName);
        }
        Enumeration e = this.req.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (this.isNameReserved(name)) continue;
            variableNames.add(name);
        }
    }

    protected Object getReqAttributeIgnoreCase(String targetName) {
        Object object;
        block1: {
            String name;
            object = null;
            if (this.isNameReserved(targetName) || (object = this.req.getAttribute(targetName)) != null) break block1;
            Enumeration e = this.req.getAttributeNames();
            while (e.hasMoreElements() && (!targetName.equalsIgnoreCase(name = (String)e.nextElement()) || this.isNameReserved(name) || (object = this.req.getAttribute(name)) == null)) {
            }
        }
        return object;
    }

    protected boolean isNameReserved(String name) {
        return name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("sun.");
    }

    public void setVariableValue(String name, String value) {
        if (!this.isNameReserved(name)) {
            this.req.setAttribute(name, (Object)value);
        }
    }

    public String getVariableValue(String name) {
        String retVal = null;
        Object object = this.getReqAttributeIgnoreCase(name);
        retVal = object != null ? object.toString() : this.getCGIVariable(name);
        return retVal;
    }

    protected String getCGIVariable(String name) {
        String retVal = null;
        if (name.equalsIgnoreCase("AUTH_TYPE")) {
            retVal = this.req.getAuthType();
        } else if (name.equalsIgnoreCase("CONTENT_LENGTH")) {
            int contentLength = this.req.getContentLength();
            if (contentLength >= 0) {
                retVal = Integer.toString(contentLength);
            }
        } else if (name.equalsIgnoreCase("CONTENT_TYPE")) {
            retVal = this.req.getContentType();
        } else if (name.equalsIgnoreCase("DOCUMENT_NAME")) {
            String requestURI = this.req.getRequestURI();
            retVal = requestURI.substring(requestURI.lastIndexOf(47) + 1);
        } else if (name.equalsIgnoreCase("DOCUMENT_URI")) {
            retVal = this.req.getRequestURI();
        } else if (name.equalsIgnoreCase("GATEWAY_INTERFACE")) {
            retVal = "CGI/1.1";
        } else if (name.equalsIgnoreCase("PATH_INFO")) {
            retVal = this.req.getPathInfo();
        } else if (name.equalsIgnoreCase("PATH_TRANSLATED")) {
            retVal = this.req.getPathTranslated();
        } else if (name.equalsIgnoreCase("QUERY_STRING")) {
            retVal = this.nullToEmptyString(this.req.getQueryString());
        } else if (name.equalsIgnoreCase("QUERY_STRING_UNESCAPED")) {
            String queryString = this.req.getQueryString();
            if (queryString != null) {
                retVal = URLDecoder.decode(queryString);
            }
        } else if (name.equalsIgnoreCase("REMOTE_ADDR")) {
            retVal = this.req.getRemoteAddr();
        } else if (name.equalsIgnoreCase("REMOTE_HOST")) {
            retVal = this.req.getRemoteHost();
        } else if (name.equalsIgnoreCase("REMOTE_USER")) {
            retVal = this.req.getRemoteUser();
        } else if (name.equalsIgnoreCase("REQUEST_METHOD")) {
            retVal = this.req.getMethod();
        } else if (name.equalsIgnoreCase("SCRIPT_NAME")) {
            retVal = this.req.getServletPath();
        } else if (name.equalsIgnoreCase("SERVER_NAME")) {
            retVal = this.req.getServerName();
        } else if (name.equalsIgnoreCase("SERVER_PORT")) {
            retVal = Integer.toString(this.req.getServerPort());
        } else if (name.equalsIgnoreCase("SERVER_PROTOCOL")) {
            retVal = this.req.getProtocol();
        } else if (name.equalsIgnoreCase("SERVER_SOFTWARE")) {
            ServletContext servletContext = this.servlet.getServletContext();
            retVal = servletContext.getServerInfo();
        }
        return retVal;
    }

    public Date getCurrentDate() {
        return new Date();
    }

    protected String nullToEmptyString(String string) {
        String retVal = string;
        if (retVal == null) {
            retVal = "";
        }
        return retVal;
    }

    protected String getPathWithoutFileName(String servletPath) {
        String retVal = null;
        int lastSlash = servletPath.lastIndexOf(47);
        if (lastSlash >= 0) {
            retVal = servletPath.substring(0, lastSlash + 1);
        }
        return retVal;
    }

    protected String getPathWithoutContext(String servletPath) {
        String retVal = null;
        int secondSlash = servletPath.indexOf(47, 1);
        if (secondSlash >= 0) {
            retVal = servletPath.substring(secondSlash);
        }
        return retVal;
    }

    protected String getAbsolutePath(String path) throws IOException {
        String pathWithoutContext = SSIServletRequestUtil.getRelativePath(this.req);
        String prefix = this.getPathWithoutFileName(pathWithoutContext);
        if (prefix == null) {
            throw new IOException("Couldn't remove filename from path: " + pathWithoutContext);
        }
        String fullPath = prefix + path;
        String retVal = SSIServletRequestUtil.normalize(fullPath);
        if (retVal == null) {
            throw new IOException("Normalization yielded null on path: " + fullPath);
        }
        return retVal;
    }

    protected ServletContextAndPath getServletContextAndPathFromNonVirtualPath(String nonVirtualPath) throws IOException {
        if (nonVirtualPath.startsWith("/") || nonVirtualPath.startsWith("\\")) {
            throw new IOException("A non-virtual path can't be absolute: " + nonVirtualPath);
        }
        if (nonVirtualPath.indexOf("../") >= 0) {
            throw new IOException("A non-virtual path can't contain '../' : " + nonVirtualPath);
        }
        String path = this.getAbsolutePath(nonVirtualPath);
        ServletContext servletContext = this.servlet.getServletContext();
        ServletContextAndPath csAndP = new ServletContextAndPath(servletContext, path);
        return csAndP;
    }

    protected ServletContextAndPath getServletContextAndPathFromVirtualPath(String virtualPath) throws IOException {
        ServletContext servletContext = this.servlet.getServletContext();
        String path = null;
        if (!virtualPath.startsWith("/") && !virtualPath.startsWith("\\")) {
            path = this.getAbsolutePath(virtualPath);
        } else {
            String normalized = SSIServletRequestUtil.normalize(virtualPath);
            if (this.isVirtualWebappRelative) {
                path = normalized;
            } else {
                if ((servletContext = servletContext.getContext(normalized)) == null) {
                    throw new IOException("Couldn't get context for path: " + normalized);
                }
                if (!this.isRootContext(servletContext)) {
                    path = this.getPathWithoutContext(normalized);
                    if (path == null) {
                        throw new IOException("Couldn't remove context from path: " + normalized);
                    }
                } else {
                    path = normalized;
                }
            }
        }
        return new ServletContextAndPath(servletContext, path);
    }

    protected boolean isRootContext(ServletContext servletContext) {
        return servletContext == servletContext.getContext("/");
    }

    protected ServletContextAndPath getServletContextAndPath(String originalPath, boolean virtual) throws IOException {
        ServletContextAndPath csAndP = null;
        if (this.debug > 0) {
            this.log("SSIServletExternalResolver.getServletContextAndPath( " + originalPath + ", " + virtual + ")", null);
        }
        csAndP = virtual ? this.getServletContextAndPathFromVirtualPath(originalPath) : this.getServletContextAndPathFromNonVirtualPath(originalPath);
        return csAndP;
    }

    protected URLConnection getURLConnection(String originalPath, boolean virtual) throws IOException {
        String path;
        ServletContextAndPath csAndP = this.getServletContextAndPath(originalPath, virtual);
        ServletContext context = csAndP.getServletContext();
        URL url = context.getResource(path = csAndP.getPath());
        if (url == null) {
            throw new IOException("Context did not contain resource: " + path);
        }
        URLConnection urlConnection = url.openConnection();
        return urlConnection;
    }

    public long getFileLastModified(String path, boolean virtual) throws IOException {
        long lastModified = 0L;
        URLConnection urlConnection = this.getURLConnection(path, virtual);
        lastModified = urlConnection.getLastModified();
        return lastModified;
    }

    public long getFileSize(String path, boolean virtual) throws IOException {
        long fileSize = -1L;
        URLConnection urlConnection = this.getURLConnection(path, virtual);
        fileSize = urlConnection.getContentLength();
        return fileSize;
    }

    public String getFileText(String originalPath, boolean virtual) throws IOException {
        try {
            ServletContextAndPath csAndP = this.getServletContextAndPath(originalPath, virtual);
            ServletContext context = csAndP.getServletContext();
            String path = csAndP.getPath();
            RequestDispatcher rd = context.getRequestDispatcher(path);
            if (rd == null) {
                throw new IOException("Couldn't get request dispatcher for path: " + path);
            }
            ByteArrayServletOutputStream basos = new ByteArrayServletOutputStream();
            ResponseIncludeWrapper responseIncludeWrapper = new ResponseIncludeWrapper(this.res, basos);
            rd.include((ServletRequest)this.req, (ServletResponse)responseIncludeWrapper);
            responseIncludeWrapper.flushOutputStreamOrWriter();
            byte[] bytes = basos.toByteArray();
            String retVal = this.inputEncoding == null ? new String(bytes) : new String(bytes, this.inputEncoding);
            if (retVal.equals("")) {
                throw new IOException("Couldn't find file: " + path);
            }
            return retVal;
        }
        catch (ServletException e) {
            throw new IOException("Couldn't include file: " + originalPath + " because of ServletException: " + e.getMessage());
        }
    }

    protected class ServletContextAndPath {
        protected ServletContext servletContext;
        protected String path;

        public ServletContextAndPath(ServletContext servletContext, String path) {
            this.servletContext = servletContext;
            this.path = path;
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }

        public String getPath() {
            return this.path;
        }
    }
}

