/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.naming.ContextAccessController;
import org.apache.naming.StringManager;

public class ContextBindings {
    private static Hashtable contextNameBindings = new Hashtable();
    private static Hashtable threadBindings = new Hashtable();
    private static Hashtable threadNameBindings = new Hashtable();
    private static Hashtable clBindings = new Hashtable();
    private static Hashtable clNameBindings = new Hashtable();
    protected static StringManager sm = StringManager.getManager("org.apache.naming");

    public static void bindContext(Object name, Context context) {
        ContextBindings.bindContext(name, context, null);
    }

    public static void bindContext(Object name, Context context, Object token) {
        if (ContextAccessController.checkSecurityToken(name, token)) {
            contextNameBindings.put(name, context);
        }
    }

    public static void unbindContext(Object name) {
        ContextBindings.unbindContext(name, null);
    }

    public static void unbindContext(Object name, Object token) {
        if (ContextAccessController.checkSecurityToken(name, token)) {
            contextNameBindings.remove(name);
        }
    }

    static Context getContext(Object name) {
        return (Context)contextNameBindings.get(name);
    }

    public static void bindThread(Object name) throws NamingException {
        ContextBindings.bindThread(name, null);
    }

    public static void bindThread(Object name, Object token) throws NamingException {
        if (ContextAccessController.checkSecurityToken(name, token)) {
            Context context = (Context)contextNameBindings.get(name);
            if (context == null) {
                throw new NamingException(sm.getString("contextBindings.unknownContext", name));
            }
            threadBindings.put(Thread.currentThread(), context);
            threadNameBindings.put(Thread.currentThread(), name);
        }
    }

    public static void unbindThread(Object name) {
        ContextBindings.unbindThread(name, null);
    }

    public static void unbindThread(Object name, Object token) {
        if (ContextAccessController.checkSecurityToken(name, token)) {
            threadBindings.remove(Thread.currentThread());
            threadNameBindings.remove(Thread.currentThread());
        }
    }

    public static Context getThread() throws NamingException {
        Context context = (Context)threadBindings.get(Thread.currentThread());
        if (context == null) {
            throw new NamingException(sm.getString("contextBindings.noContextBoundToThread"));
        }
        return context;
    }

    static Object getThreadName() throws NamingException {
        Object name = threadNameBindings.get(Thread.currentThread());
        if (name == null) {
            throw new NamingException(sm.getString("contextBindings.noContextBoundToThread"));
        }
        return name;
    }

    public static boolean isThreadBound() {
        return threadBindings.containsKey(Thread.currentThread());
    }

    public static void bindClassLoader(Object name) throws NamingException {
        ContextBindings.bindClassLoader(name, null);
    }

    public static void bindClassLoader(Object name, Object token) throws NamingException {
        ContextBindings.bindClassLoader(name, token, Thread.currentThread().getContextClassLoader());
    }

    public static void bindClassLoader(Object name, Object token, ClassLoader classLoader) throws NamingException {
        if (ContextAccessController.checkSecurityToken(name, token)) {
            Context context = (Context)contextNameBindings.get(name);
            if (context == null) {
                throw new NamingException(sm.getString("contextBindings.unknownContext", name));
            }
            clBindings.put(classLoader, context);
            clNameBindings.put(classLoader, name);
        }
    }

    public static void unbindClassLoader(Object name) {
        ContextBindings.unbindClassLoader(name, null);
    }

    public static void unbindClassLoader(Object name, Object token) {
        if (ContextAccessController.checkSecurityToken(name, token)) {
            clBindings.remove(Thread.currentThread().getContextClassLoader());
            clNameBindings.remove(Thread.currentThread().getContextClassLoader());
        }
    }

    public static Context getClassLoader() throws NamingException {
        Context context = (Context)clBindings.get(Thread.currentThread().getContextClassLoader());
        if (context == null) {
            throw new NamingException(sm.getString("contextBindings.noContextBoundToCL"));
        }
        return context;
    }

    static Object getClassLoaderName() throws NamingException {
        Object name = clNameBindings.get(Thread.currentThread().getContextClassLoader());
        if (name == null) {
            throw new NamingException(sm.getString("contextBindings.noContextBoundToCL"));
        }
        return name;
    }

    public static boolean isClassLoaderBound() {
        return clBindings.containsKey(Thread.currentThread().getContextClassLoader());
    }
}

