/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.parser;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.parser.MyEntityResolver;
import org.apache.jasper.parser.MyErrorHandler;
import org.apache.jasper.parser.TreeNode;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ParserUtils {
    protected ClassLoader classLoader = null;
    protected ErrorHandler errorHandler = new MyErrorHandler();
    protected EntityResolver entityResolver = new MyEntityResolver();
    private static HashMap classLoaders = new HashMap();

    protected TreeNode convert(TreeNode parent, Node node) {
        NodeList children;
        TreeNode treeNode = new TreeNode(node.getNodeName(), parent);
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int n = attributes.getLength();
            int i = 0;
            while (i < n) {
                Node attribute = attributes.item(i);
                treeNode.addAttribute(attribute.getNodeName(), attribute.getNodeValue());
                ++i;
            }
        }
        if ((children = node.getChildNodes()) != null) {
            int n = children.getLength();
            int i = 0;
            while (i < n) {
                Node child = children.item(i);
                if (!(child instanceof Comment)) {
                    if (child instanceof Text) {
                        String body = ((Text)child).getData();
                        if (body != null && (body = body.trim()).length() > 0) {
                            treeNode.setBody(body);
                        }
                    } else {
                        TreeNode treeNode2 = this.convert(treeNode, child);
                    }
                }
                ++i;
            }
        }
        return treeNode;
    }

    public static synchronized ClassLoader createClassLoader(ClassLoader parentLoader) throws MalformedURLException {
        URLClassLoader classLoader = (URLClassLoader)classLoaders.get(parentLoader);
        if (classLoader != null) {
            return classLoader;
        }
        URL[] urls = new URL[]{new URL("file:///classes/jaxp.jar"), new URL("file:///classes/crimson.jar")};
        classLoader = new URLClassLoader(urls, parentLoader);
        classLoaders.put(parentLoader, classLoader);
        System.out.println("PUF:  createClassLoader:\r\n" + classLoader);
        urls = classLoader.getURLs();
        int i = 0;
        while (i < urls.length) {
            System.out.println("PUF:    url=" + urls[i]);
            ++i;
        }
        return classLoader;
    }

    public static synchronized ParserUtils createParserUtils(ClassLoader parentLoader) {
        ParserUtils parserUtils = null;
        parserUtils = new ParserUtils();
        parserUtils.setClassLoader(parentLoader);
        return parserUtils;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("usage: java ParserUtils {filename}");
            System.exit(1);
        }
        try {
            ParserUtils pu = new ParserUtils();
            System.out.println("Opening " + args[0]);
            FileInputStream fis = new FileInputStream(args[0]);
            System.out.println("Execute the parse");
            TreeNode tree = pu.parseXMLDocument(args[0], fis);
            System.out.println("Dump results");
            System.out.println(tree);
        }
        catch (Throwable t) {
            System.out.println("Exception: " + t.toString());
            t.printStackTrace(System.out);
        }
    }

    public TreeNode parseXMLDocument(String uri, InputStream is) throws JasperException {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(this.entityResolver);
            builder.setErrorHandler(this.errorHandler);
            document = builder.parse(is);
        }
        catch (ParserConfigurationException ex) {
            throw new JasperException(Constants.getString((String)"jsp.error.parse.xml", (Object[])new Object[]{uri, ex.getMessage()}));
        }
        catch (SAXParseException ex) {
            throw new JasperException(Constants.getString((String)"jsp.error.parse.xml.line", (Object[])new Object[]{uri, new Integer(ex.getLineNumber()), new Integer(ex.getColumnNumber()), ex.getMessage()}));
        }
        catch (SAXException sx) {
            throw new JasperException(Constants.getString((String)"jsp.error.parse.xml", (Object[])new Object[]{uri, sx.getMessage()}));
        }
        catch (IOException io) {
            throw new JasperException(Constants.getString((String)"jsp.error.parse.xml", (Object[])new Object[]{uri, io.toString()}));
        }
        return this.convert(null, document.getDocumentElement());
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

