/*
 * Decompiled with CFR 0.152.
 */
package develop.p2p.lib.bukkit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TitleNotification {
    private final Map<UUID, String> mainTitleMap = new HashMap<UUID, String>();
    private final Map<UUID, String> subTitleMap = new HashMap<UUID, String>();
    private final List<UUID> isShowing = new ArrayList<UUID>();
    private final Plugin plugin;

    public TitleNotification(Plugin plugin) {
        this.plugin = plugin;
    }

    public void setSubTitle(final Player player, String string) {
        this.isShowing.add(player.getUniqueId());
        this.subTitleMap.put(player.getUniqueId(), string);
        player.sendTitle(this.mainTitleMap.getOrDefault(player.getUniqueId(), ""), string, 0, 10, 0);
        new BukkitRunnable(){
            private final UUID uuid;
            private int time;
            {
                this.uuid = player.getUniqueId();
                this.time = 0;
            }

            public void run() {
                if (!(TitleNotification.this.mainTitleMap.containsKey(this.uuid) || TitleNotification.this.isShowing.contains(this.uuid) && TitleNotification.this.subTitleMap.containsKey(this.uuid))) {
                    TitleNotification.this.isShowing.remove(this.uuid);
                    this.cancel();
                    return;
                }
                if (this.time++ < 10) {
                    return;
                }
                TitleNotification.this.subTitleMap.remove(this.uuid);
                if (!TitleNotification.this.mainTitleMap.containsKey(this.uuid)) {
                    TitleNotification.this.isShowing.remove(this.uuid);
                }
                this.cancel();
            }
        }.runTaskTimer(this.plugin, 0L, 1L);
    }

    public void setMainTitle(final Player player, String string) {
        this.isShowing.add(player.getUniqueId());
        this.mainTitleMap.put(player.getUniqueId(), string);
        player.sendTitle(string, this.subTitleMap.getOrDefault(player.getUniqueId(), ""), 0, 10, 0);
        new BukkitRunnable(){
            private UUID uuid;
            private int time;
            {
                this.uuid = player.getUniqueId();
                this.time = 0;
            }

            public void run() {
                if (!(TitleNotification.this.subTitleMap.containsKey(this.uuid) || TitleNotification.this.isShowing.contains(this.uuid) && TitleNotification.this.mainTitleMap.containsKey(this.uuid))) {
                    TitleNotification.this.isShowing.remove(this.uuid);
                    this.cancel();
                    return;
                }
                if (this.time++ < 10) {
                    return;
                }
                TitleNotification.this.mainTitleMap.remove(this.uuid);
                if (!TitleNotification.this.subTitleMap.containsKey(this.uuid)) {
                    TitleNotification.this.isShowing.remove(this.uuid);
                }
            }
        }.runTaskTimer(this.plugin, 0L, 1L);
    }
}

