/*
 * Decompiled with CFR 0.152.
 */
package develop.p2p.lib.bukkit;

import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;

public class Say2Functional
implements Listener {
    private final HashMap<UUID, FunctionalEntry> say2func;
    private FunctionalEntry consoleFunc;

    public Say2Functional(Plugin plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
        this.say2func = new HashMap();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onSay(AsyncPlayerChatEvent e) {
        if (!this.say2func.containsKey(e.getPlayer().getUniqueId())) {
            return;
        }
        FunctionalEntry entry = this.say2func.get(e.getPlayer().getUniqueId());
        if (entry.keywords != null && Arrays.stream(entry.keywords).noneMatch(s -> entry.matchType.apply(e.getMessage(), (String)s))) {
            return;
        }
        e.setCancelled(true);
        this.say2func.remove(e.getPlayer().getUniqueId());
        if (entry.keywords == null) {
            entry.func.accept(e.getMessage());
            return;
        }
        entry.func.accept((String)Arrays.stream(entry.keywords).filter(s -> entry.matchType.apply(e.getMessage(), (String)s)).collect(Collectors.toList()).get(0));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onConsole(ServerCommandEvent e) {
        if (this.consoleFunc == null || !(e.getSender() instanceof ConsoleCommandSender)) {
            return;
        }
        e.setCancelled(true);
        FunctionalEntry entry = this.consoleFunc;
        if (entry.keywords != null && Arrays.stream(entry.keywords).noneMatch(s -> entry.matchType.apply(e.getCommand(), (String)s))) {
            return;
        }
        e.setCancelled(true);
        this.consoleFunc = null;
        if (entry.keywords == null) {
            entry.func.accept(e.getCommand());
            return;
        }
        entry.func.accept((String)Arrays.stream(entry.keywords).filter(s -> entry.matchType.apply(e.getCommand(), (String)s)).collect(Collectors.toList()).get(0));
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        this.say2func.remove(e.getPlayer().getUniqueId());
    }

    public void add(UUID player, FunctionalEntry func) {
        if (player == null) {
            this.consoleFunc = func;
        } else {
            this.say2func.put(player, func);
        }
    }

    public static class FunctionalEntry {
        public final String[] keywords;
        public final Consumer<String> func;
        public final BiFunction<String, String, Boolean> matchType;

        public FunctionalEntry(BiFunction<String, String, Boolean> matchType, Consumer<String> runas, String ... keywords) {
            this.keywords = keywords.length == 0 ? null : keywords;
            this.func = runas;
            this.matchType = matchType;
        }
    }
}

