/*
 * Decompiled with CFR 0.152.
 */
package develop.p2p.lib;

import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeParser {
    private static final String regex = "^\\d+((year|y)|(month|mo)|(day|d)|(hour|h)|(minute|min|m)|(second|sec|s))s?$";
    private static final String d = "d";
    private static final String h = "h";
    private static final String m = "m";
    private static final String s = "s";

    public static Date convert(String ... args) {
        Calendar c = Calendar.getInstance();
        Pattern p = Pattern.compile(regex, 2);
        block26: for (String arg : args) {
            int num;
            Matcher m = p.matcher(arg);
            if (!m.find()) continue;
            String unit = m.group(1);
            try {
                num = Integer.parseInt(arg.replace(unit, "").replace(s, ""));
            }
            catch (Exception ignored) {
                continue;
            }
            switch (unit.toLowerCase()) {
                case "year": 
                case "y": {
                    c.add(1, num);
                    continue block26;
                }
                case "month": 
                case "mo": {
                    c.add(2, num);
                    continue block26;
                }
                case "day": 
                case "d": {
                    c.add(5, num);
                    continue block26;
                }
                case "hour": 
                case "h": {
                    c.add(10, num);
                    continue block26;
                }
                case "minute": 
                case "min": 
                case "m": {
                    c.add(12, num);
                    continue block26;
                }
                case "second": 
                case "sec": 
                case "s": {
                    c.add(13, num);
                }
            }
        }
        return c.getTime();
    }

    public static String convertFromDate(Date date) {
        long now = new Date().getTime();
        long ago = date.getTime();
        long diff = ago - now;
        long day = diff / 86400000L;
        long hour = diff / 3600000L % 24L;
        long minute = diff / 60000L % 60L;
        long second = diff / 1000L % 60L;
        return day + d + hour + h + minute + m + second + s;
    }
}

