/*
 * Decompiled with CFR 0.152.
 */
package develop.p2p.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.yaml.snakeyaml.Yaml;

public class FileConfiguration {
    private final File cfg;
    private Map<String, Object> config = null;
    private final String fileStr;

    public FileConfiguration(File parent, String name) {
        this.fileStr = name;
        this.cfg = new File(parent, name);
    }

    public void saveDefaultConfig() {
        if (this.cfg.exists()) {
            return;
        }
        this.copyFromInJar(this.fileStr);
    }

    public void loadConfig() {
        this.reloadConfig();
    }

    public void reloadConfig() {
        try (FileInputStream stream = new FileInputStream(this.cfg);
             InputStreamReader reader = new InputStreamReader(stream);){
            Yaml yaml = new Yaml();
            this.config = (Map)yaml.load((Reader)reader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<String, Object> getConfig() {
        if (this.config == null) {
            this.reloadConfig();
        }
        return this.config;
    }

    public <T> T get(String key) {
        try {
            if (!key.contains(".")) {
                if (this.getConfig().get(key) == null) {
                    throw new NullPointerException("Failed to parsing yaml files");
                }
                return (T)this.getConfig().get(key);
            }
            ArrayList<String> keys = new ArrayList<String>(Arrays.asList(key.split("\\.")));
            Map preCfg = this.getConfig();
            int count = 0;
            for (String preKey : keys) {
                if (keys.size() == count + 1) {
                    return (T)preCfg.get(preKey);
                }
                preCfg = (Map)preCfg.get(preKey);
                ++count;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    private void copyFromInJar(String name) {
        try {
            Path to = this.cfg.toPath();
            Files.copy(Objects.requireNonNull(ClassLoader.getSystemResourceAsStream(name)), to, new CopyOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

