/*
 * Decompiled with CFR 0.152.
 */
package tokyo.northside.oxfordapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import tokyo.northside.oxfordapi.HTMLFormatter;
import tokyo.northside.oxfordapi.IOxfordClient;
import tokyo.northside.oxfordapi.OxfordClientException;
import tokyo.northside.oxfordapi.OxfordDictionaryEntry;
import tokyo.northside.oxfordapi.dtd.LexicalEntry;
import tokyo.northside.oxfordapi.dtd.Result;

public abstract class OxfordClientBase
implements IOxfordClient {
    protected static final HttpClientResponseHandler<String> RESPONSE_HANDLER = response -> {
        int status = response.getCode();
        if (status >= 200 && status < 300) {
            try (HttpEntity entity = response.getEntity();){
                if (entity != null) {
                    String string = EntityUtils.toString((HttpEntity)entity);
                    return string;
                }
                String string = null;
                return string;
            }
            catch (ParseException ex) {
                throw new ClientProtocolException((Throwable)ex);
            }
        }
        throw new ClientProtocolException(String.format("Unexpected response status: %d", status));
    };

    @Override
    public List<OxfordDictionaryEntry> getTranslations(Collection<String> words, String source, String target) throws OxfordClientException {
        ArrayList<OxfordDictionaryEntry> dictionaryEntries = new ArrayList<OxfordDictionaryEntry>();
        this.queryTranslations(words, source, target).entrySet().forEach(entry -> {
            for (Result result : (List)entry.getValue()) {
                for (LexicalEntry lexicalEntry : result.getLexicalEntries()) {
                    dictionaryEntries.add(new OxfordDictionaryEntry((String)entry.getKey(), lexicalEntry.getText(), HTMLFormatter.formatDefinitions(lexicalEntry)));
                }
            }
        });
        return dictionaryEntries;
    }

    @Override
    public List<OxfordDictionaryEntry> getDefinitions(Collection<String> words, String language, boolean strict) throws OxfordClientException {
        ArrayList<OxfordDictionaryEntry> dictionaryEntries = new ArrayList<OxfordDictionaryEntry>();
        this.queryEntries(words, language, strict).entrySet().forEach(entry -> {
            for (Result result : (List)entry.getValue()) {
                for (LexicalEntry lexicalEntry : result.getLexicalEntries()) {
                    dictionaryEntries.add(new OxfordDictionaryEntry((String)entry.getKey(), lexicalEntry.getText(), HTMLFormatter.formatDefinitions(lexicalEntry)));
                }
            }
        });
        return dictionaryEntries;
    }
}

