/*
 * Decompiled with CFR 0.152.
 */
package tokyo.northside.oxfordapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import tokyo.northside.oxfordapi.OxfordClientBase;
import tokyo.northside.oxfordapi.OxfordClientException;
import tokyo.northside.oxfordapi.RequestFactory;
import tokyo.northside.oxfordapi.dtd.Result;

public class OxfordClient
extends OxfordClientBase {
    private final String appId;
    private final String appKey;

    public OxfordClient(String appId, String appKey) {
        this.appId = appId;
        this.appKey = appKey;
    }

    @Override
    public Map<String, List<Result>> queryTranslations(Collection<String> words, String source, String target) throws OxfordClientException {
        HashMap<String, List<Result>> result = new HashMap<String, List<Result>>();
        for (String word : words) {
            result.put(word, this.queryTranslation(word, source, target));
        }
        return result;
    }

    @Override
    public List<Result> queryTranslation(String word, String source, String target) throws OxfordClientException {
        HashSet<String> fields = new HashSet<String>(Arrays.asList("definitions", "pronunciations"));
        RequestFactory f = new RequestFactory(this.appId, this.appKey).setType(RequestFactory.QueryType.TRANSLATIONS).setSourceLanguage(source).setTargetLanguage(target).setFields(fields).setQueryWord(word);
        return this.query(f.getUrl(), f.getHeader());
    }

    @Override
    public Map<String, List<Result>> queryEntries(Collection<String> words, String language, boolean strict) throws OxfordClientException {
        HashMap<String, List<Result>> result = new HashMap<String, List<Result>>();
        for (String word : words) {
            result.put(word, this.queryEntry(word, language, strict));
        }
        return result;
    }

    @Override
    public List<Result> queryEntry(String word, String language, boolean strict) throws OxfordClientException {
        RequestFactory f = new RequestFactory(this.appId, this.appKey).setType(RequestFactory.QueryType.ENTRIES).setLanguage(language).setQueryWord(word).setFields(Collections.singleton("definitions")).setStrictMatch(strict);
        return this.query(f.getUrl(), f.getHeader());
    }

    @Override
    public void close() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Result> query(String requestUrl, Map<String, Object> header) throws OxfordClientException {
        String response;
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpGet httpGet = new HttpGet(requestUrl);
            header.forEach((arg_0, arg_1) -> ((HttpGet)httpGet).addHeader(arg_0, arg_1));
            try (CloseableHttpResponse httpResponse = httpclient.execute((ClassicHttpRequest)httpGet);){
                int status = httpResponse.getCode();
                if (status == 429) {
                    throw new OxfordClientException("Got 429 Too many requests, Do you exceed your limit?");
                }
                if (status == 403) {
                    throw new OxfordClientException("Authorization failed.");
                }
                if (status != 404) {
                    if (status != 200) {
                        throw new OxfordClientException(String.format("Unexpected status %d.", status));
                    }
                } else {
                    List<Result> list = Collections.emptyList();
                    return list;
                }
                response = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException | ParseException e) {
            throw new OxfordClientException(e.getMessage());
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(response);
            node = node.get("results");
            return (List)mapper.readValue(node.traverse(), (TypeReference)new TypeReference<List<Result>>(){});
        }
        catch (IOException e) {
            throw new OxfordClientException(e.getMessage());
        }
    }
}

