/*
 * Decompiled with CFR 0.152.
 */
package tokyo.northside.oxfordapi;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import tokyo.northside.oxfordapi.OxfordClientException;

public class RequestFactory {
    private static final String ENDPOINT_URL = "https://od-api.oxforddictionaries.com";
    private static final String BASE_PATH = "/api/v2/";
    private final String appId;
    private final String appKey;
    private QueryType type;
    private String queryWord;
    private String sourceLang;
    private String targetLang;
    private String strictMatch;
    private Set<String> fields;

    public RequestFactory(String appId, String appKey) {
        this.appId = appId;
        this.appKey = appKey;
        this.strictMatch = "false";
        this.sourceLang = "en-gb";
        this.type = QueryType.ENTRIES;
        this.fields = Collections.singleton("definitions");
    }

    public RequestFactory setType(QueryType queryType) {
        this.type = queryType;
        return this;
    }

    public RequestFactory setQueryWord(String word) {
        this.queryWord = word.toLowerCase();
        return this;
    }

    public RequestFactory setLanguage(String language) {
        this.sourceLang = language.equalsIgnoreCase("en") ? "en-gb" : language.toLowerCase();
        return this;
    }

    public RequestFactory setSourceLanguage(String language) {
        this.sourceLang = language.equalsIgnoreCase("en") ? "en-gb" : language.toLowerCase();
        return this;
    }

    public RequestFactory setTargetLanguage(String language) {
        this.targetLang = language.equalsIgnoreCase("en") ? "en-gb" : language.toLowerCase();
        return this;
    }

    public RequestFactory setStrictMatch(boolean strict) {
        this.strictMatch = strict ? "true" : "false";
        return this;
    }

    public RequestFactory setFields(Set<String> newFields) {
        this.fields = newFields;
        return this;
    }

    public Map<String, Object> getHeader() {
        HashMap<String, Object> header = new HashMap<String, Object>();
        header.put("Accept", "application/json");
        header.put("app_id", this.appId);
        header.put("app_key", this.appKey);
        return header;
    }

    public String getPath() throws OxfordClientException {
        if (this.queryWord == null) {
            throw new OxfordClientException("Query word is mandatory");
        }
        switch (this.type) {
            case ENTRIES: {
                return String.format("%sentries/%s/%s", BASE_PATH, this.sourceLang, this.escapeString(this.queryWord));
            }
            case TRANSLATIONS: {
                if (this.targetLang == null) {
                    throw new OxfordClientException("Source and Target languages are mandatory");
                }
                return String.format("%stranslations/%s/%s", BASE_PATH, this.sourceLang, this.targetLang);
            }
        }
        return null;
    }

    public String getQueryString() throws OxfordClientException {
        StringBuilder sb = new StringBuilder();
        switch (this.type) {
            case ENTRIES: {
                sb.append("strictMatch=").append(this.strictMatch);
                break;
            }
            case TRANSLATIONS: {
                if (this.queryWord == null) {
                    throw new OxfordClientException("Query word is mandatory");
                }
                sb.append("q=").append(this.escapeString(this.queryWord));
                break;
            }
            default: {
                return null;
            }
        }
        if (this.fields != null) {
            sb.append("&fields=").append(this.parameterToString(this.fields));
        }
        return sb.toString();
    }

    public String getUrl() throws OxfordClientException {
        if (this.queryWord == null) {
            throw new OxfordClientException("Query word is mandatory");
        }
        return String.format("%s%s?%s", ENDPOINT_URL, this.getPath(), this.getQueryString());
    }

    public String getQueryWord() {
        return this.queryWord;
    }

    private String parameterToString(Collection<String> param) {
        if (param == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (String o : param) {
            if (b.length() > 0) {
                b.append(',');
            }
            b.append(o);
        }
        return b.toString();
    }

    private String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public static enum QueryType {
        ENTRIES,
        TRANSLATIONS;

    }
}

