/*
 * Decompiled with CFR 0.152.
 */
package tokyo.northside.oxfordapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import tokyo.northside.oxfordapi.OxfordClientBase;
import tokyo.northside.oxfordapi.OxfordClientException;
import tokyo.northside.oxfordapi.RequestFactory;
import tokyo.northside.oxfordapi.dtd.Result;

public class OxfordThreadClient
extends OxfordClientBase {
    private static final String ENDPOINT_URL = "https://od-api.oxforddictionaries.com/api/v2/";
    private final String appId;
    private final String appKey;

    public OxfordThreadClient(String appId, String appKey) {
        this.appId = appId;
        this.appKey = appKey;
    }

    @Override
    public Map<String, List<Result>> queryEntries(Collection<String> words, String language, boolean strict) throws OxfordClientException {
        HashMap<String, List<Result>> result = new HashMap<String, List<Result>>();
        try (PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
             CloseableHttpClient httpclient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();){
            ArrayList<RequestFactory> requests = new ArrayList<RequestFactory>();
            for (String query : words) {
                RequestFactory factory = new RequestFactory(this.appId, this.appKey, ENDPOINT_URL);
                factory.setQueryWord(query).setLanguage(language).setStrictMatch(strict);
                requests.add(factory);
            }
            this.runThread(result, httpclient, requests);
        }
        catch (IOException | InterruptedException e) {
            throw new OxfordClientException(e.getMessage());
        }
        return result;
    }

    @Override
    public Map<String, List<Result>> queryTranslations(Collection<String> words, String source, String target) throws OxfordClientException {
        HashMap<String, List<Result>> result = new HashMap<String, List<Result>>();
        try (PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
             CloseableHttpClient httpclient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();){
            ArrayList<RequestFactory> requests = new ArrayList<RequestFactory>();
            for (String query : words) {
                RequestFactory factory = new RequestFactory(this.appId, this.appKey, ENDPOINT_URL);
                factory.setQueryWord(query).setSourceLanguage(source).setTargetLanguage(target);
                requests.add(factory);
            }
            this.runThread(result, httpclient, requests);
        }
        catch (IOException | InterruptedException e) {
            throw new OxfordClientException(e.getMessage());
        }
        return result;
    }

    private void runThread(Map<String, List<Result>> result, CloseableHttpClient httpclient, List<RequestFactory> requests) throws OxfordClientException, InterruptedException {
        GetThread[] threads = new GetThread[requests.size()];
        for (int i = 0; i < threads.length; ++i) {
            HttpGet httpGet = new HttpGet(requests.get(i).getUrl());
            requests.get(i).getHeader().forEach((arg_0, arg_1) -> ((HttpGet)httpGet).addHeader(arg_0, arg_1));
            threads[i] = new GetThread(httpclient, httpGet, requests.get(i).getQueryWord(), result, i + 1);
        }
        for (GetThread thread : threads) {
            thread.start();
        }
        for (GetThread thread : threads) {
            thread.join();
        }
    }

    @Override
    public void close() {
    }

    @Override
    public List<Result> queryTranslation(String word, String source, String target) throws OxfordClientException {
        return this.queryTranslations(Collections.singletonList(word), source, target).get(word);
    }

    @Override
    public List<Result> queryEntry(String word, String language, boolean strict) throws OxfordClientException {
        return this.queryEntries(Collections.singletonList(word), language, strict).get(word);
    }

    private static Map<String, List<Result>> parseResponse(String word, String json) {
        HashMap<String, List<Result>> articles = new HashMap<String, List<Result>>();
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode node = mapper.readTree(json);
            articles.put(word, (List<Result>)mapper.readValue(node.get("results").traverse(), (TypeReference)new TypeReference<List<Result>>(){}));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return articles;
    }

    static class GetThread
    extends Thread {
        private final CloseableHttpClient httpClient;
        private final HttpGet httpget;
        private final Map<String, List<Result>> result;
        private final String word;
        private final int id;

        GetThread(CloseableHttpClient httpClient, HttpGet httpget, String word, Map<String, List<Result>> result, int id) {
            this.httpClient = httpClient;
            this.httpget = httpget;
            this.word = word;
            this.result = result;
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block5: {
                try {
                    String response = (String)this.httpClient.execute((ClassicHttpRequest)this.httpget, OxfordClientBase.RESPONSE_HANDLER);
                    if (response == null) break block5;
                    Map<String, List<Result>> map = this.result;
                    synchronized (map) {
                        this.result.putAll(OxfordThreadClient.parseResponse(this.word, response));
                    }
                }
                catch (IOException e) {
                    System.out.println(this.id + " - error: " + e);
                    System.out.println(this.id + " - request: " + this.httpget.getRequestUri());
                }
            }
        }
    }
}

