/*
 * Decompiled with CFR 0.152.
 */
package tokyo.northside.oxfordapi;

import java.util.HashMap;
import java.util.Map;
import tokyo.northside.oxfordapi.OxfordClientException;

public class RequestFactory {
    private static final String BASE_PATH = "/api/v2";
    private final String endpointUrl;
    private final String appId;
    private final String appKey;
    private QueryType type;
    private String queryWord;
    private String sourceLang;
    private String targetLang;
    private String strictMatch;

    public RequestFactory(String appId, String appKey, String endpointUrl) {
        this.endpointUrl = endpointUrl;
        this.appId = appId;
        this.appKey = appKey;
        this.strictMatch = "false";
        this.sourceLang = "en-gb";
        this.type = QueryType.ENTRIES;
    }

    public RequestFactory setType(QueryType queryType) {
        this.type = queryType;
        return this;
    }

    public RequestFactory setQueryWord(String word) {
        this.queryWord = word.toLowerCase();
        return this;
    }

    public RequestFactory setLanguage(String language) {
        this.sourceLang = language.equalsIgnoreCase("en") ? "en-gb" : language.toLowerCase();
        return this;
    }

    public RequestFactory setSourceLanguage(String language) {
        this.sourceLang = language.equalsIgnoreCase("en") ? "en-gb" : language.toLowerCase();
        return this;
    }

    public RequestFactory setTargetLanguage(String language) {
        this.targetLang = language.equalsIgnoreCase("en") ? "en-gb" : language.toLowerCase();
        return this;
    }

    public RequestFactory setStrictMatch(boolean strict) {
        this.strictMatch = strict ? "true" : "false";
        return this;
    }

    public Map<String, Object> getHeader() {
        HashMap<String, Object> header = new HashMap<String, Object>();
        header.put("Accept", "application/json");
        header.put("app_id", this.appId);
        header.put("app_key", this.appKey);
        return header;
    }

    public String getUri() throws OxfordClientException {
        if (this.queryWord == null) {
            throw new OxfordClientException("Query word is mandatory");
        }
        switch (this.type) {
            case ENTRIES: {
                return String.format("%sentries/%s/%s?strictMatch=%s", BASE_PATH, this.sourceLang, this.queryWord, this.strictMatch);
            }
            case TRANSLATIONS: {
                if (this.targetLang == null) {
                    throw new OxfordClientException("Source and Target languages are mandatory");
                }
                return String.format("%stranslations/%s/%s?q=%s", BASE_PATH, this.sourceLang, this.targetLang, this.queryWord);
            }
        }
        return null;
    }

    public String getPath() throws OxfordClientException {
        if (this.queryWord == null) {
            throw new OxfordClientException("Query word is mandatory");
        }
        switch (this.type) {
            case ENTRIES: {
                return String.format("%sentries/%s/%s", BASE_PATH, this.sourceLang, this.queryWord);
            }
            case TRANSLATIONS: {
                if (this.targetLang == null) {
                    throw new OxfordClientException("Source and Target languages are mandatory");
                }
                return String.format("%stranslations/%s/%s", BASE_PATH, this.sourceLang, this.targetLang);
            }
        }
        return null;
    }

    public String getQueryString() throws OxfordClientException {
        switch (this.type) {
            case ENTRIES: {
                return String.format("strictMatch=%s", this.strictMatch);
            }
            case TRANSLATIONS: {
                if (this.queryWord == null) {
                    throw new OxfordClientException("Query word is mandatory");
                }
                return String.format("?q=%s", this.queryWord);
            }
        }
        return null;
    }

    public String getUrl() throws OxfordClientException {
        if (this.queryWord == null) {
            throw new OxfordClientException("Query word is mandatory");
        }
        switch (this.type) {
            case ENTRIES: {
                return String.format("%sentries/%s/%s?strictMatch=%s", this.endpointUrl, this.sourceLang, this.queryWord, this.strictMatch);
            }
            case TRANSLATIONS: {
                if (this.targetLang == null) {
                    throw new OxfordClientException("Source and Target languages are mandatory");
                }
                return String.format("%stranslations/%s/%s?q=%s", this.endpointUrl, this.sourceLang, this.targetLang, this.queryWord);
            }
        }
        return null;
    }

    public String getQueryWord() {
        return this.queryWord;
    }

    public static enum QueryType {
        ENTRIES,
        TRANSLATIONS;

    }
}

