/*
 * Decompiled with CFR 0.152.
 */
package tokyo.northside.oxfordapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import tokyo.northside.oxfordapi.OxfordClientBase;
import tokyo.northside.oxfordapi.OxfordClientException;
import tokyo.northside.oxfordapi.RequestFactory;
import tokyo.northside.oxfordapi.dtd.Result;

public class OxfordClient
extends OxfordClientBase {
    private static final String BASE_URL_V2 = "https://od-api.oxforddictionaries.com/api/v2";
    private final String endpointUrl;
    private final String appId;
    private final String appKey;

    public OxfordClient(String appId, String appKey, String baseUrl) {
        this.appId = appId;
        this.appKey = appKey;
        this.endpointUrl = baseUrl;
    }

    public OxfordClient(String appId, String appKey) {
        this(appId, appKey, BASE_URL_V2);
    }

    @Override
    public Map<String, List<Result>> queryTranslations(Collection<String> words, String source, String target) throws OxfordClientException {
        HashMap<String, List<Result>> result = new HashMap<String, List<Result>>();
        for (String word : words) {
            result.put(word, this.queryTranslation(word, source, target));
        }
        return result;
    }

    @Override
    public List<Result> queryTranslation(String word, String source, String target) throws OxfordClientException {
        RequestFactory f = new RequestFactory(this.appId, this.appKey, this.endpointUrl).setType(RequestFactory.QueryType.TRANSLATIONS).setSourceLanguage(source).setTargetLanguage(target).setQueryWord(word);
        return this.query(f.getUrl(), f.getHeader());
    }

    @Override
    public Map<String, List<Result>> queryEntries(Collection<String> words, String language, boolean strict) throws OxfordClientException {
        HashMap<String, List<Result>> result = new HashMap<String, List<Result>>();
        for (String word : words) {
            result.put(word, this.queryEntry(word, language, strict));
        }
        return result;
    }

    @Override
    public List<Result> queryEntry(String word, String language, boolean strict) throws OxfordClientException {
        RequestFactory f = new RequestFactory(this.appId, this.appKey, this.endpointUrl).setType(RequestFactory.QueryType.ENTRIES).setLanguage(language).setQueryWord(word).setStrictMatch(strict);
        return this.query(f.getUrl(), f.getHeader());
    }

    @Override
    public void close() {
    }

    public List<Result> query(String requestUrl, Map<String, Object> header) throws OxfordClientException {
        String response;
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpGet httpGet = new HttpGet(requestUrl);
            header.forEach((arg_0, arg_1) -> ((HttpGet)httpGet).addHeader(arg_0, arg_1));
            response = (String)httpclient.execute((ClassicHttpRequest)httpGet, RESPONSE_HANDLER);
        }
        catch (IOException e) {
            throw new OxfordClientException(e.getMessage());
        }
        if (response != null) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode node = mapper.readTree(response);
                node = node.get("results");
                return (List)mapper.readValue(node.traverse(), (TypeReference)new TypeReference<List<Result>>(){});
            }
            catch (IOException e) {
                throw new OxfordClientException(e.getMessage());
            }
        }
        return Collections.emptyList();
    }
}

