/*
 * Decompiled with CFR 0.152.
 */
package tokyo.northside.oxfordapi;

import java.util.HashMap;
import java.util.Map;
import tokyo.northside.oxfordapi.OxfordClientException;

public class RequestFactory {
    private final String endpointUrl;
    private final String appId;
    private final String appKey;
    private QueryType type;
    private String queryWord;
    private String sourceLang;
    private String targetLang;
    private String strictMatch;

    public RequestFactory(String appId, String appKey, String endpointUrl) {
        this.endpointUrl = endpointUrl;
        this.appId = appId;
        this.appKey = appKey;
        this.strictMatch = "false";
        this.sourceLang = "en-gb";
        this.type = QueryType.ENTRIES;
    }

    public void setType(QueryType type) {
        this.type = type;
    }

    public void setQueryWord(String word) {
        this.queryWord = word.toLowerCase();
    }

    public void setLanguage(String language) {
        this.sourceLang = language.equalsIgnoreCase("en") ? "en-gb" : language.toLowerCase();
    }

    public void setSourceLanguage(String language) {
        this.sourceLang = language.equalsIgnoreCase("en") ? "en-gb" : language.toLowerCase();
    }

    public void setTargetLanguage(String language) {
        this.targetLang = language.equalsIgnoreCase("en") ? "en-gb" : language.toLowerCase();
    }

    public void setStrictMatch(boolean strict) {
        this.strictMatch = strict ? "true" : "false";
    }

    public Map<String, Object> getHeader() {
        HashMap<String, Object> header = new HashMap<String, Object>();
        header.put("Accept", "application/json");
        header.put("app_id", this.appId);
        header.put("app_key", this.appKey);
        return header;
    }

    public String getUrl() throws OxfordClientException {
        if (this.queryWord == null) {
            throw new OxfordClientException("Query word is mandatory");
        }
        switch (this.type) {
            case ENTRIES: {
                return String.format("%sentries/%s/%s?strictMatch=%s", this.endpointUrl, this.sourceLang, this.queryWord, this.strictMatch);
            }
            case TRANSLATIONS: {
                if (this.targetLang == null) {
                    throw new OxfordClientException("Source and Target languages are mandatory");
                }
                return String.format("%stranslations/%s/%s?q=%s", this.endpointUrl, this.sourceLang, this.targetLang, this.queryWord);
            }
        }
        return null;
    }

    public static enum QueryType {
        ENTRIES,
        TRANSLATIONS;

    }
}

