/*
 * Decompiled with CFR 0.152.
 */
package tokyo.northside.oxfordapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import tokyo.northside.oxfordapi.OxfordClientException;
import tokyo.northside.oxfordapi.RequestFactory;
import tokyo.northside.oxfordapi.dtd.Result;

public final class OxfordClient {
    private static final String BASE_URL_V2 = "https://od-api.oxforddictionaries.com/api/v2";
    private final String endpointUrl;
    private final String appId;
    private final String appKey;
    private static final HttpClientResponseHandler<String> RESPONSE_HANDLER = response -> {
        int status = response.getCode();
        if (status >= 200 && status < 300) {
            try (HttpEntity entity = response.getEntity();){
                if (entity != null) {
                    String string = EntityUtils.toString((HttpEntity)entity);
                    return string;
                }
                String string = null;
                return string;
            }
            catch (ParseException ex) {
                throw new ClientProtocolException((Throwable)ex);
            }
        }
        throw new ClientProtocolException(String.format("Unexpected response status: %d", status));
    };

    public OxfordClient(String appId, String appKey, String baseUrl) {
        this.appId = appId;
        this.appKey = appKey;
        this.endpointUrl = baseUrl;
    }

    public OxfordClient(String appId, String appKey) {
        this(appId, appKey, BASE_URL_V2);
    }

    public List<Result> getTranslations(String word, String source, String target) throws OxfordClientException {
        RequestFactory f = new RequestFactory(this.appId, this.appKey, this.endpointUrl);
        f.setType(RequestFactory.QueryType.TRANSLATIONS);
        f.setSourceLanguage(source);
        f.setTargetLanguage(target);
        f.setQueryWord(word);
        return this.query(f.getUrl(), f.getHeader());
    }

    public List<Result> getEntries(String word, String language, boolean strict) throws OxfordClientException {
        RequestFactory f = new RequestFactory(this.appId, this.appKey, this.endpointUrl);
        f.setType(RequestFactory.QueryType.ENTRIES);
        f.setLanguage(language);
        f.setQueryWord(word);
        f.setStrictMatch(strict);
        return this.query(f.getUrl(), f.getHeader());
    }

    public List<Result> query(String requestUrl, Map<String, Object> header) throws OxfordClientException {
        String response;
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpGet httpGet = new HttpGet(requestUrl);
            header.forEach((arg_0, arg_1) -> ((HttpGet)httpGet).addHeader(arg_0, arg_1));
            response = (String)httpclient.execute((ClassicHttpRequest)httpGet, RESPONSE_HANDLER);
        }
        catch (IOException e) {
            throw new OxfordClientException(e.getMessage());
        }
        if (response != null) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode node = mapper.readTree(response);
                node = node.get("results");
                return (List)mapper.readValue(node.traverse(), (TypeReference)new TypeReference<List<Result>>(){});
            }
            catch (IOException e) {
                throw new OxfordClientException(e.getMessage());
            }
        }
        return Collections.emptyList();
    }
}

