/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.provider.base;

import java.util.LinkedList;
import java.util.List;
import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.jdbc.SQL;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.xmltags.MixedSqlNode;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.scripting.xmltags.StaticTextSqlNode;
import org.apache.ibatis.scripting.xmltags.WhereSqlNode;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.mapperhelper.MapperHelper;
import tk.mybatis.mapper.mapperhelper.MapperTemplate;

public class BaseSelectProvider
extends MapperTemplate {
    public BaseSelectProvider(Class<?> mapperClass, MapperHelper mapperHelper) {
        super(mapperClass, mapperHelper);
    }

    public SqlNode selectOne(MappedStatement ms) {
        Class<?> entityClass = this.getSelectReturnType(ms);
        this.setResultType(ms, entityClass);
        LinkedList<Object> sqlNodes = new LinkedList<Object>();
        sqlNodes.add(new StaticTextSqlNode("SELECT " + EntityHelper.getSelectColumns(entityClass) + " FROM " + this.tableName(entityClass)));
        sqlNodes.add(new WhereSqlNode(ms.getConfiguration(), this.getAllIfColumnNode(entityClass)));
        return new MixedSqlNode(sqlNodes);
    }

    public SqlNode select(MappedStatement ms) {
        Class<?> entityClass = this.getSelectReturnType(ms);
        this.setResultType(ms, entityClass);
        LinkedList<Object> sqlNodes = new LinkedList<Object>();
        sqlNodes.add(new StaticTextSqlNode("SELECT " + EntityHelper.getSelectColumns(entityClass) + " FROM " + this.tableName(entityClass)));
        sqlNodes.add(new WhereSqlNode(ms.getConfiguration(), this.getAllIfColumnNode(entityClass)));
        String orderByClause = EntityHelper.getOrderByClause(entityClass);
        if (orderByClause.length() > 0) {
            sqlNodes.add(new StaticTextSqlNode("ORDER BY " + orderByClause));
        }
        return new MixedSqlNode(sqlNodes);
    }

    public SqlNode selectByRowBounds(MappedStatement ms) {
        return this.select(ms);
    }

    public void selectByPrimaryKey(MappedStatement ms) {
        final Class<?> entityClass = this.getSelectReturnType(ms);
        List<ParameterMapping> parameterMappings = this.getPrimaryKeyParameterMappings(ms);
        String sql = new SQL(){
            {
                this.SELECT(EntityHelper.getSelectColumns(entityClass));
                this.FROM(BaseSelectProvider.this.tableName(entityClass));
                this.WHERE(EntityHelper.getPrimaryKeyWhere(entityClass));
            }
        }.toString();
        StaticSqlSource sqlSource = new StaticSqlSource(ms.getConfiguration(), sql, parameterMappings);
        this.setSqlSource(ms, (SqlSource)sqlSource);
        this.setResultType(ms, entityClass);
    }

    public SqlNode selectCount(MappedStatement ms) {
        Class<?> entityClass = this.getSelectReturnType(ms);
        LinkedList<Object> sqlNodes = new LinkedList<Object>();
        sqlNodes.add(new StaticTextSqlNode("SELECT COUNT(*) FROM " + this.tableName(entityClass)));
        sqlNodes.add(new WhereSqlNode(ms.getConfiguration(), this.getAllIfColumnNode(entityClass)));
        return new MixedSqlNode(sqlNodes);
    }

    public String selectAll(MappedStatement ms) {
        Class<?> entityClass = this.getSelectReturnType(ms);
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        sql.append("select ").append(EntityHelper.getSelectColumns(entityClass)).append(" from ");
        sql.append(this.tableName(entityClass));
        return sql.toString();
    }
}

