/*
 * Decompiled with CFR 0.152.
 */
package tk.jamunx.ui.scanner.utils;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import java.util.HashSet;
import java.util.Set;

public class GO
extends View {
    private final Object mLock = new Object();
    private int mPreviewWidth;
    private float mWidthScaleFactor = 1.0f;
    private int mPreviewHeight;
    private float mHeightScaleFactor = 1.0f;
    private int mFacing = 0;
    private Set<Graphic> mGraphics = new HashSet<Graphic>();

    public GO(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            this.mGraphics.clear();
        }
        this.postInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Graphic graphic) {
        Object object = this.mLock;
        synchronized (object) {
            this.mGraphics.add(graphic);
        }
        this.postInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Graphic graphic) {
        Object object = this.mLock;
        synchronized (object) {
            this.mGraphics.remove(graphic);
        }
        this.postInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCameraInfo(int previewWidth, int previewHeight, int facing) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPreviewWidth = previewWidth;
            this.mPreviewHeight = previewHeight;
            this.mFacing = facing;
        }
        this.postInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPreviewWidth != 0 && this.mPreviewHeight != 0) {
                this.mWidthScaleFactor = (float)canvas.getWidth() / (float)this.mPreviewWidth;
                this.mHeightScaleFactor = (float)canvas.getHeight() / (float)this.mPreviewHeight;
            }
            for (Graphic graphic : this.mGraphics) {
                graphic.draw(canvas);
            }
        }
    }

    public static abstract class Graphic {
        private GO mOverlay;

        public Graphic(GO overlay) {
            this.mOverlay = overlay;
        }

        public abstract void draw(Canvas var1);

        public float scaleX(float horizontal) {
            return horizontal * this.mOverlay.mWidthScaleFactor;
        }

        public float scaleY(float vertical) {
            return vertical * this.mOverlay.mHeightScaleFactor;
        }

        public float translateX(float x) {
            if (this.mOverlay.mFacing == 1) {
                return (float)this.mOverlay.getWidth() - this.scaleX(x);
            }
            return this.scaleX(x);
        }

        public float translateY(float y) {
            return this.scaleY(y);
        }

        public void postInvalidate() {
            this.mOverlay.postInvalidate();
        }
    }
}

