/*
 * Decompiled with CFR 0.152.
 */
package tk.jamunx.ui.scanner.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.common.images.Size;
import java.io.IOException;
import tk.jamunx.ui.scanner.utils.CS;
import tk.jamunx.ui.scanner.utils.GO;

public class CSP
extends ViewGroup {
    private static final String TAG = "CameraSourcePre";
    private Context mContext;
    private SurfaceView mSurfaceView;
    private boolean mStartRequested;
    private boolean mSurfaceAvailable;
    private CS mCS;
    private GO mOverlay;

    public CSP(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.mStartRequested = false;
        this.mSurfaceAvailable = false;
        this.mSurfaceView = new SurfaceView(context);
        this.mSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)new SurfaceCallback());
        this.addView((View)this.mSurfaceView);
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public void start(CS cs) throws IOException, SecurityException {
        if (cs == null) {
            this.stop();
        }
        this.mCS = cs;
        if (this.mCS != null) {
            this.mStartRequested = true;
            this.startIfReady();
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public void start(CS cs, GO overlay) throws IOException {
        this.mOverlay = overlay;
        this.start(cs);
    }

    public void stop() {
        if (this.mCS != null) {
            this.mCS.stop();
        }
    }

    public void release() {
        if (this.mCS != null) {
            this.mCS.release();
            this.mCS = null;
        }
    }

    @RequiresPermission(value="android.permission.CAMERA")
    private void startIfReady() throws IOException, SecurityException {
        if (this.mStartRequested && this.mSurfaceAvailable) {
            this.mCS.start(this.mSurfaceView.getHolder());
            this.mStartRequested = false;
            if (this.mOverlay != null) {
                Size size = this.mCS.getPreviewSize();
                int min = Math.min(size.getWidth(), size.getHeight());
                int max = Math.max(size.getWidth(), size.getHeight());
                if (this.isPortraitMode()) {
                    this.mOverlay.setCameraInfo(min, max, this.mCS.getCameraFacing());
                } else {
                    this.mOverlay.setCameraInfo(max, min, this.mCS.getCameraFacing());
                }
                this.mOverlay.clear();
            }
            this.mStartRequested = false;
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        int width = metrics.widthPixels;
        int height = metrics.heightPixels;
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).layout(0, 0, width, height);
        }
        try {
            this.startIfReady();
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
    }

    private boolean isPortraitMode() {
        int orientation = this.mContext.getResources().getConfiguration().orientation;
        if (orientation == 2) {
            return false;
        }
        if (orientation == 1) {
            return true;
        }
        Log.d((String)TAG, (String)"isPortraitMode returning false by default");
        return false;
    }

    private class SurfaceCallback
    implements SurfaceHolder.Callback {
        private SurfaceCallback() {
        }

        public void surfaceCreated(SurfaceHolder surface) {
            CSP.this.mSurfaceAvailable = true;
            try {
                CSP.this.startIfReady();
            }
            catch (SecurityException se) {
                Log.e((String)CSP.TAG, (String)"Do not have permission to start the camera", (Throwable)se);
            }
            catch (IOException e) {
                Log.e((String)CSP.TAG, (String)"Could not start camera source.", (Throwable)e);
            }
        }

        public void surfaceDestroyed(SurfaceHolder surface) {
            CSP.this.mSurfaceAvailable = false;
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        }
    }
}

