/*
 * Decompiled with CFR 0.152.
 */
package tk.jamunx.ui.scanner.classes;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.SparseArray;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.Toolbar;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.BarcodeDetector;
import java.io.IOException;
import tk.jamunx.ui.scanner.R;
import tk.jamunx.ui.scanner.utils.CS;
import tk.jamunx.ui.scanner.utils.CSP;
import tk.jamunx.ui.scanner.utils.CheckPermission;

public class ActivityScanner
extends AppCompatActivity {
    public static final String INTENT_FOR_CODE = "ResultScanData";
    public static final String INTENT_SCANNER_TYPE = "type";
    public static final String INTENT_SCANNER_ACTIVITY_NAME = "name";
    public static final String INTENT_SCANNER_DATA_TYPE = "dataType";
    public static final int SCANNER_TYPE_QR = 1;
    public static final int SCANNER_TYPE_BARCODE = 2;
    public static final int TYPE_ALL_FORMAT = 0;
    public static final int TYPE_BARCODE_CODE_128 = 1;
    public static final int TYPE_BARCODE_CODE_39 = 2;
    public static final int TYPE_BARCODE_CODE_93 = 4;
    public static final int TYPE_BARCODE_CODABAR = 8;
    public static final int TYPE_BARCODE_EAN_13 = 32;
    public static final int TYPE_BARCODE_EAN_8 = 64;
    public static final int TYPE_BARCODE_ITF = 128;
    public static final int TYPE_BARCODE_UPC_A = 512;
    public static final int TYPE_BARCODE_UPC_E = 1024;
    public static final int TYPE_QR_CODE = 256;
    public static final int TYPE_QR_PDF417 = 2048;
    public static final int TYPE_QR_DATA_MATRIX = 16;
    public static final int TYPE_QR_AZTEC = 4096;
    private static final int RC_HANDLE_GMS = 9001;
    private Animation slide = null;
    private LinearLayout linearLayout;
    private CSP csp;
    private CS cs;
    private ScaleGestureDetector scaleGestureDetector;
    private AppCompatImageView imageViewFlash;
    private AppCompatImageView imageViewClear;
    private AppCompatImageView imageViewVoice;
    private AppCompatImageView imageViewSubmit;
    private EditText editTextUser;
    private int type;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.checkAndStart();
    }

    private void checkAndStart() {
        if (CheckPermission.checkPermission((Context)this, 126)) {
            this.setContentView(R.layout.library_activity_reader);
            this.type = this.getIntent().getIntExtra(INTENT_SCANNER_TYPE, 1);
            this.setToolbar();
            this.initializeBar();
            this.initializeView();
            this.initializeSlide();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 126: {
                this.checkAndStart();
            }
        }
    }

    private void initializeBar() {
        this.csp = (CSP)this.findViewById(R.id.id_preview);
        this.scaleGestureDetector = new ScaleGestureDetector((Context)this, (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
        BarcodeDetector barcodeDetector = new BarcodeDetector.Builder((Context)this).setBarcodeFormats(this.getIntent().getIntExtra(INTENT_SCANNER_DATA_TYPE, 256)).build();
        if (!barcodeDetector.isOperational()) {
            Toast.makeText((Context)this, (CharSequence)"Not ready yet", (int)1).show();
        }
        if (!barcodeDetector.isOperational()) {
            boolean hasLowStorage;
            IntentFilter lowstorageFilter = new IntentFilter("android.intent.action.DEVICE_STORAGE_LOW");
            boolean bl = hasLowStorage = this.registerReceiver(null, lowstorageFilter) != null;
            if (hasLowStorage) {
                Toast.makeText((Context)this, (int)R.string.library_string_toast_low_storage_error, (int)1).show();
            }
            this.finish();
        }
        CS.Builder builder = new CS.Builder((Context)this, (Detector<?>)barcodeDetector).setFacing(0).setRequestedFps(10.0f).setRequestedPreviewSize(1024, 728).setFocusMode("continuous-picture");
        this.cs = builder.setFlashMode(null).build();
        barcodeDetector.setProcessor((Detector.Processor)new Detector.Processor<Barcode>(){

            public void release() {
            }

            public void receiveDetections(Detector.Detections<Barcode> detections) {
                String qrCode;
                Barcode barcode;
                SparseArray barcodeSparseArray = detections.getDetectedItems();
                if (barcodeSparseArray != null && barcodeSparseArray.size() > 0 && (barcode = (Barcode)barcodeSparseArray.valueAt(0)) != null && (qrCode = barcode.displayValue) != null) {
                    ActivityScanner.this.submitData(qrCode);
                }
            }
        });
    }

    private void initializeSlide() {
        this.linearLayout = (LinearLayout)this.findViewById(R.id.id_relative_scanner);
        this.SlideToDown();
    }

    private void initializeView() {
        this.editTextUser = (EditText)this.findViewById(R.id.id_edit_search);
        this.editTextUser.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (s != null && s.length() > 0) {
                    ActivityScanner.this.imageViewVoice.setVisibility(8);
                    ActivityScanner.this.imageViewSubmit.setVisibility(0);
                    ActivityScanner.this.imageViewClear.setVisibility(0);
                } else {
                    ActivityScanner.this.imageViewVoice.setVisibility(0);
                    ActivityScanner.this.imageViewSubmit.setVisibility(8);
                    ActivityScanner.this.imageViewClear.setVisibility(8);
                }
            }

            public void afterTextChanged(Editable s) {
            }
        });
        this.imageViewClear = (AppCompatImageView)this.findViewById(R.id.id_image_clear);
        this.imageViewSubmit = (AppCompatImageView)this.findViewById(R.id.id_image_submit);
        this.imageViewSubmit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!TextUtils.isEmpty((CharSequence)ActivityScanner.this.editTextUser.getText())) {
                    ActivityScanner.this.submitData(ActivityScanner.this.editTextUser.getText().toString());
                } else {
                    Toast.makeText((Context)ActivityScanner.this, (CharSequence)"Field Cannot be Empty!", (int)1).show();
                }
            }
        });
        this.imageViewVoice = (AppCompatImageView)this.findViewById(R.id.id_image_voice);
        this.imageViewVoice.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
        this.imageViewFlash = (AppCompatImageView)this.findViewById(R.id.id_image_flash);
        if (this.getPackageManager().hasSystemFeature("android.hardware.camera.flash")) {
            this.imageViewFlash.setVisibility(0);
        } else {
            this.imageViewFlash.setVisibility(8);
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.finish();
        }
        return super.onOptionsItemSelected(item);
    }

    public void SlideToAbove() {
        this.slide = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 1.0f, 1, 0.0f);
        this.slide.setDuration(3000L);
        this.slide.setFillAfter(true);
        this.slide.setFillEnabled(true);
        this.linearLayout.startAnimation(this.slide);
        this.slide.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                ActivityScanner.this.linearLayout.clearAnimation();
                ActivityScanner.this.SlideToDown();
            }
        });
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.slide.cancel();
    }

    public void SlideToDown() {
        this.slide = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 0.0f, 1, 1.0f);
        this.slide.setDuration(3000L);
        this.slide.setFillAfter(true);
        this.slide.setFillEnabled(true);
        this.linearLayout.startAnimation(this.slide);
        this.slide.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                ActivityScanner.this.linearLayout.clearAnimation();
                ActivityScanner.this.SlideToAbove();
            }
        });
    }

    private void setToolbar() {
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.id_app_bar);
        if (this.getIntent().getStringExtra(INTENT_SCANNER_ACTIVITY_NAME) != null) {
            toolbar.setTitle((CharSequence)this.getIntent().getStringExtra(INTENT_SCANNER_ACTIVITY_NAME));
        } else if (this.type == 1) {
            toolbar.setTitle(R.string.library_string_activity_name_scanner_qr);
        } else if (this.type == 1) {
            toolbar.setTitle(R.string.library_string_activity_name_scanner_barcode);
        } else {
            toolbar.setTitle(R.string.library_string_activity_name_scanner);
        }
        this.setSupportActionBar(toolbar);
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
    }

    public boolean onTouchEvent(MotionEvent e) {
        boolean b = this.scaleGestureDetector.onTouchEvent(e);
        return b || super.onTouchEvent(e);
    }

    private void startCameraSource() throws SecurityException {
        int code = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(this.getApplicationContext());
        if (code != 0) {
            Dialog dlg = GoogleApiAvailability.getInstance().getErrorDialog((Activity)this, code, 9001);
            dlg.show();
        }
        if (this.cs != null) {
            try {
                this.csp.start(this.cs);
            }
            catch (IOException e) {
                this.cs.release();
                this.cs = null;
            }
        }
    }

    public void onClickFlash(View view) {
        if (this.cs != null) {
            String mode = null;
            if (this.cs.getFlashMode() == null) {
                this.cs.setFlashModeNew("off");
            } else if (this.cs.getFlashMode().equals("off")) {
                this.imageViewFlash.setImageResource(R.drawable.library_icon_vd_flash_on);
                mode = "torch";
            } else if (this.cs.getFlashMode().equals("on")) {
                this.imageViewFlash.setImageResource(R.drawable.library_icon_vd_flash_auto);
                mode = "auto";
            } else {
                this.imageViewFlash.setImageResource(R.drawable.library_icon_vd_flash_off);
                mode = "off";
            }
            this.cs.setFlashModeNew(mode);
        }
    }

    protected void onResume() {
        super.onResume();
        this.startCameraSource();
    }

    protected void onPause() {
        super.onPause();
        if (this.csp != null) {
            this.csp.stop();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.csp != null) {
            this.csp.release();
        }
    }

    private void submitData(String qrCode) {
        Intent intent = new Intent();
        intent.putExtra(INTENT_FOR_CODE, qrCode);
        this.setResult(-1, intent);
        this.finish();
    }

    private class ScaleListener
    implements ScaleGestureDetector.OnScaleGestureListener {
        private ScaleListener() {
        }

        public boolean onScale(ScaleGestureDetector detector) {
            ActivityScanner.this.cs.doZoom(detector.getScaleFactor());
            return false;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            ActivityScanner.this.cs.doZoom(detector.getScaleFactor());
        }
    }
}

