/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.volley.main;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import android.util.LruCache;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.ImageLoader;
import com.android.volley.toolbox.Volley;

public class VolleySingleton {
    private static VolleySingleton instance = null;
    private RequestQueue requestQueue;
    private ImageLoader imageLoader;
    private LruCache<String, Bitmap> lruCache = new LruCache(this.lruCacheSize);
    private int lruCacheSize = 0x400000;

    private VolleySingleton(Context context) {
        this.requestQueue = Volley.newRequestQueue((Context)context);
        this.imageLoader = new ImageLoader(this.requestQueue, new ImageLoader.ImageCache(){

            public Bitmap getBitmap(String url) {
                return (Bitmap)VolleySingleton.this.lruCache.get((Object)url);
            }

            public void putBitmap(@NonNull String url, Bitmap bitmap) {
                VolleySingleton.this.lruCache.put((Object)url, (Object)bitmap);
            }
        });
    }

    public static VolleySingleton get() {
        return instance;
    }

    public static void setInstance(Context context) {
        if (instance == null) {
            instance = new VolleySingleton(context);
        }
    }

    public RequestQueue getRequestQueue() {
        return this.requestQueue;
    }

    public ImageLoader getImageLoader() {
        return this.imageLoader;
    }

    public void clearCache() {
        this.lruCache.evictAll();
    }

    public void clearCacheOfUrl(String url) {
        this.lruCache.remove((Object)url);
    }

    public void setLruCacheSize(Context context, int lruCacheSize) {
        this.lruCacheSize = lruCacheSize;
        instance = null;
        VolleySingleton.setInstance(context);
    }
}

