/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.volley.classes;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.HttpHeaderParser;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.Map;
import tk.jamun.volley.classes.VolleyGSON;
import tk.jamun.volley.classes.VolleyWorkLoad;
import tk.jamun.volley.helpers.VolleyNeeds;
import tk.jamun.volley.helpers.VolleyValues;
import tk.jamun.volley.variables.VolleyResponse;
import tk.jamun.volley.variables.VolleyResponses;

public class VolleyNetworkRequest
extends Request<NetworkResponse> {
    private String mRequestBody;
    @Nullable
    private VolleyResponse.Listener<Integer> mListener;
    private VolleyResponses listener;

    public VolleyNetworkRequest(int method, @NonNull String url, Object payload, Type typeOfPayload, VolleyResponses listener) {
        this(method, url, VolleyGSON.get().toJson(payload, typeOfPayload), listener);
    }

    public VolleyNetworkRequest(@NonNull String url, Object payload, Type typeOfPayload, VolleyResponses listener) {
        this(1, url, VolleyGSON.get().toJson(payload, typeOfPayload), listener);
    }

    public VolleyNetworkRequest(@NonNull String url, VolleyResponses listener) {
        this(0, url, null, listener);
    }

    public VolleyNetworkRequest(@NonNull String url, @Nullable String payload, VolleyResponses listener) {
        this(1, url, payload, listener);
    }

    public VolleyNetworkRequest(int method, @NonNull String url, @Nullable String payload, VolleyResponses listener) {
        super(method, url, VolleyWorkLoad.errorListenerHandler(listener));
        this.listener = listener;
        this.mRequestBody = payload;
    }

    @Deprecated
    public VolleyNetworkRequest(@NonNull String url, @Nullable VolleyResponse.Listener<Integer> listener, @Nullable VolleyResponse.ErrorListener errorListener) {
        this(0, url, null, listener, errorListener);
    }

    public VolleyNetworkRequest(int method, @NonNull String url, @Nullable String payload, @Nullable VolleyResponse.Listener<Integer> listener, @Nullable VolleyResponse.ErrorListener errorListener) {
        super(method, url, VolleyWorkLoad.errorListenerHandler(errorListener));
        this.mListener = listener;
        this.mRequestBody = payload;
    }

    @Deprecated
    public VolleyNetworkRequest(@NonNull String url, @Nullable String payload, @Nullable VolleyResponse.Listener<Integer> listener, @Nullable VolleyResponse.ErrorListener errorListener) {
        this(1, url, payload, listener, errorListener);
    }

    public Map<String, String> getHeaders() {
        return VolleyNeeds.get().setVolleyHeader();
    }

    public String getBodyContentType() {
        return "application/json";
    }

    protected Response<NetworkResponse> parseNetworkResponse(NetworkResponse response) {
        try {
            return Response.success((Object)response, (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
        }
        catch (Exception e) {
            return Response.error((VolleyError)new ParseError((Throwable)e));
        }
    }

    public byte[] getBody() {
        try {
            return this.mRequestBody == null ? null : this.mRequestBody.getBytes(VolleyValues.PROTOCOL_CHARSET);
        }
        catch (UnsupportedEncodingException uee) {
            VolleyLog.wtf((String)"Unsupported Encoding while trying to get the bytes of %s using %s", (Object[])new Object[]{this.mRequestBody, VolleyValues.PROTOCOL_CHARSET});
            return null;
        }
    }

    protected void deliverResponse(NetworkResponse response) {
        if (this.mListener != null) {
            this.mListener.onResponse(response.statusCode);
        }
        if (this.listener != null) {
            this.listener.onStatusCodeResponse(response.statusCode);
        }
    }
}

