/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.volley.classes;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import com.android.volley.toolbox.JsonRequest;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import tk.jamun.volley.classes.VolleyGSON;
import tk.jamun.volley.classes.VolleyWorkLoad;
import tk.jamun.volley.helpers.VolleyNeeds;
import tk.jamun.volley.variables.VolleyResponse;
import tk.jamun.volley.variables.VolleyResponses;

public class VolleyJsonArrayRequest
extends JsonRequest<JSONArray> {
    public VolleyJsonArrayRequest(int method, @NonNull String url, String payload, Type typeOfResponse, VolleyResponses listener) {
        this(method, url, payload, VolleyWorkLoad.responseArrayHandler(listener, typeOfResponse), VolleyWorkLoad.errorWorkLoadHandler(listener));
    }

    public VolleyJsonArrayRequest(int method, @NonNull String url, Object payload, Type typeOfPayload, Type typeOfResponse, VolleyResponses listener) {
        this(method, url, VolleyGSON.get().toJson(payload, typeOfPayload), VolleyWorkLoad.responseArrayHandler(listener, typeOfResponse), VolleyWorkLoad.errorWorkLoadHandler(listener));
    }

    public VolleyJsonArrayRequest(int method, @NonNull String url, Object payload, Type typeOfPayload, VolleyResponses listener) {
        this(method, url, VolleyGSON.get().toJson(payload, typeOfPayload), VolleyWorkLoad.responseArrayHandler(listener, null), VolleyWorkLoad.errorWorkLoadHandler(listener));
    }

    public VolleyJsonArrayRequest(@NonNull String url, Type typeOfResponse, VolleyResponses listener) {
        this(0, url, null, VolleyWorkLoad.responseArrayHandler(listener, typeOfResponse), VolleyWorkLoad.errorWorkLoadHandler(listener));
    }

    public VolleyJsonArrayRequest(@NonNull String url, String payload, Type typeOfResponse, VolleyResponses listener) {
        this(1, url, payload, VolleyWorkLoad.responseArrayHandler(listener, typeOfResponse), VolleyWorkLoad.errorWorkLoadHandler(listener));
    }

    public VolleyJsonArrayRequest(int method, @NonNull String url, String payload, Class<?> modelClass, VolleyResponses listener) {
        this(method, url, payload, VolleyWorkLoad.responseArrayHandler(listener, modelClass), VolleyWorkLoad.errorWorkLoadHandler(listener));
    }

    public VolleyJsonArrayRequest(@NonNull String url, String payload, Class<?> modelClass, VolleyResponses listener) {
        this(1, url, payload, VolleyWorkLoad.responseArrayHandler(listener, modelClass), VolleyWorkLoad.errorWorkLoadHandler(listener));
    }

    public VolleyJsonArrayRequest(int method, @NonNull String url, Class<?> modelClass, VolleyResponses listener) {
        this(method, url, null, VolleyWorkLoad.responseArrayHandler(listener, modelClass), VolleyWorkLoad.errorWorkLoadHandler(listener));
    }

    public VolleyJsonArrayRequest(@NonNull String url, Class<?> modelClass, VolleyResponses listener) {
        this(0, url, null, VolleyWorkLoad.responseArrayHandler(listener, modelClass), VolleyWorkLoad.errorWorkLoadHandler(listener));
    }

    public VolleyJsonArrayRequest(int method, @NonNull String url, VolleyResponses listener) {
        this(method, url, null, VolleyWorkLoad.responseWorkLoadHandlerAllTypeArray(listener), VolleyWorkLoad.errorWorkLoadHandler(listener));
    }

    public VolleyJsonArrayRequest(@NonNull String url, VolleyResponses listener) {
        this(0, url, null, VolleyWorkLoad.responseWorkLoadHandlerAllTypeArray(listener), VolleyWorkLoad.errorWorkLoadHandler(listener));
    }

    public VolleyJsonArrayRequest(int method, @NonNull String url, String payload, VolleyResponses listener) {
        super(method, url, payload, VolleyWorkLoad.arrayListenerHandlerJamun(listener), VolleyWorkLoad.errorListenerHandlerJamun(listener));
    }

    public VolleyJsonArrayRequest(@NonNull String url, String payload, VolleyResponses listener) {
        this(1, url, payload, VolleyWorkLoad.responseWorkLoadHandlerAllTypeArray(listener), VolleyWorkLoad.errorWorkLoadHandler(listener));
    }

    @Deprecated
    public VolleyJsonArrayRequest(int method, @NonNull String url, @Nullable VolleyResponse.Listener<JSONArray> listener, @Nullable VolleyResponse.ErrorListener errorListener) {
        this(method, url, null, listener, errorListener);
    }

    @Deprecated
    public VolleyJsonArrayRequest(@NonNull String url, @Nullable VolleyResponse.Listener<JSONArray> listener, @Nullable VolleyResponse.ErrorListener errorListener) {
        this(0, url, null, listener, errorListener);
    }

    @Deprecated
    public VolleyJsonArrayRequest(@NonNull String url, String payload, @Nullable VolleyResponse.Listener<JSONArray> listener, @Nullable VolleyResponse.ErrorListener errorListener) {
        this(1, url, payload, listener, errorListener);
    }

    public VolleyJsonArrayRequest(int method, @NonNull String url, String payload, @Nullable VolleyResponse.Listener<JSONArray> listener, @Nullable VolleyResponse.ErrorListener errorListener) {
        super(method, url, payload, VolleyWorkLoad.arrayListenerHandler(listener), VolleyWorkLoad.errorListenerHandler(errorListener));
    }

    public VolleyJsonArrayRequest(int method, @NonNull String url, String payload, Response.Listener<JSONArray> listener, Response.ErrorListener errorListener) {
        super(method, url, payload, listener, errorListener);
    }

    public Map<String, String> getHeaders() {
        return VolleyNeeds.get().setVolleyHeader();
    }

    public String getBodyContentType() {
        return "application/json";
    }

    protected Response<JSONArray> parseNetworkResponse(NetworkResponse response) {
        try {
            String jsonString = new String(response.data, HttpHeaderParser.parseCharset((Map)response.headers, (String)"utf-8"));
            return Response.success((Object)new JSONArray(jsonString), (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
        }
        catch (UnsupportedEncodingException e) {
            return Response.error((VolleyError)new ParseError((Throwable)e));
        }
        catch (JSONException je) {
            return Response.error((VolleyError)new ParseError((Throwable)je));
        }
    }
}

