/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.volley.classes;

import android.graphics.Bitmap;
import android.media.ThumbnailUtils;
import android.support.annotation.Nullable;
import android.widget.ImageView;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.ImageLoader;
import com.android.volley.toolbox.NetworkImageView;
import tk.jamun.volley.main.VolleySingleton;
import tk.jamun.volley.variables.VolleyResponse;

public class VolleyImageDownload {
    private static VolleyImageDownload volleyImageDownload;
    private int thumbnailHeight = 500;
    private int thumbnailWidth = 500;

    public static VolleyImageDownload get() {
        if (volleyImageDownload == null) {
            volleyImageDownload = new VolleyImageDownload();
        }
        return volleyImageDownload;
    }

    public int getThumbnailHeight() {
        return this.thumbnailHeight;
    }

    public void setThumbnailHeight(int thumbnailHeight) {
        this.thumbnailHeight = thumbnailHeight;
    }

    public int getThumbnailWidth() {
        return this.thumbnailWidth;
    }

    public void setThumbnailWidth(int thumbnailWidth) {
        this.thumbnailWidth = thumbnailWidth;
    }

    public void downloadImage(String downloadUrl, final ImageView imageView, final VolleyResponse.ErrorImageListener errorImageListener) {
        VolleySingleton.get().getImageLoader().get(downloadUrl, new ImageLoader.ImageListener(){

            public void onResponse(ImageLoader.ImageContainer response, boolean isImmediate) {
                if (response.getBitmap() != null) {
                    imageView.setImageBitmap(response.getBitmap());
                }
            }

            public void onErrorResponse(VolleyError error) {
                if (errorImageListener != null) {
                    errorImageListener.onErrorResponse(error);
                }
            }
        });
    }

    public void downloadImage(String downloadUrl, final @Nullable VolleyResponse.Listener<Bitmap> bitmapListener, final VolleyResponse.ErrorImageListener errorImageListener) {
        VolleySingleton.get().getImageLoader().get(downloadUrl, new ImageLoader.ImageListener(){

            public void onResponse(ImageLoader.ImageContainer response, boolean isImmediate) {
                if (bitmapListener != null) {
                    bitmapListener.onResponse(response.getBitmap());
                }
            }

            public void onErrorResponse(VolleyError error) {
                if (errorImageListener != null) {
                    errorImageListener.onErrorResponse(error);
                }
            }
        });
    }

    public void downloadImageThumbnail(String downloadUrl, final ImageView imageView, final VolleyResponse.ErrorImageListener errorImageListener) {
        VolleySingleton.get().getImageLoader().get(downloadUrl, new ImageLoader.ImageListener(){

            public void onResponse(ImageLoader.ImageContainer response, boolean isImmediate) {
                if (response.getBitmap() != null) {
                    imageView.setImageBitmap(ThumbnailUtils.extractThumbnail((Bitmap)response.getBitmap(), (int)VolleyImageDownload.this.getThumbnailWidth(), (int)VolleyImageDownload.this.getThumbnailHeight()));
                }
            }

            public void onErrorResponse(VolleyError error) {
                errorImageListener.onErrorResponse(error);
            }
        });
    }

    public void downloadImage(String downloadUrl, final ImageView imageView, final int backPlaceHolder) {
        this.downloadImage(downloadUrl, imageView, new VolleyResponse.ErrorImageListener(){

            @Override
            public void onErrorResponse(VolleyError error) {
                imageView.setImageResource(backPlaceHolder);
            }
        });
    }

    public void downloadImage(String image, NetworkImageView imageView, int backPlaceHolder) {
        VolleySingleton.get().getImageLoader().get(image, ImageLoader.getImageListener((ImageView)imageView, (int)backPlaceHolder, (int)backPlaceHolder));
        imageView.setImageUrl(image, VolleySingleton.get().getImageLoader());
    }
}

